/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.est;

import java.io.File;
import java.io.IOException;
import org.xipki.ca.gateway.conf.CaProfileConf;
import org.xipki.ca.gateway.conf.CaProfilesControl;
import org.xipki.ca.gateway.conf.ProtocolConf;
import org.xipki.util.Args;
import org.xipki.util.JSON;
import org.xipki.util.exception.InvalidConfException;

public class EstProtocolConf
extends ProtocolConf {
    private String authenticator;
    private CaProfileConf[] caProfiles;

    public static EstProtocolConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
        Args.notBlank((String)fileName, (String)"fileName");
        EstProtocolConf conf = (EstProtocolConf)((Object)JSON.parseConf((File)new File(fileName), EstProtocolConf.class));
        conf.validate();
        return conf;
    }

    public String getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(String authenticator) {
        this.authenticator = authenticator;
    }

    public CaProfileConf[] getCaProfiles() {
        return this.caProfiles;
    }

    public void setCaProfiles(CaProfileConf[] caProfiles) {
        this.caProfiles = caProfiles;
    }

    public void validate() throws InvalidConfException {
        EstProtocolConf.notBlank((String)this.authenticator, (String)"authenticator");
        if (this.caProfiles != null) {
            new CaProfilesControl(this.caProfiles).validate();
        }
    }
}

