/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.rest;

import java.io.File;
import java.io.IOException;
import org.xipki.ca.gateway.conf.CaProfileConf;
import org.xipki.ca.gateway.conf.CaProfilesControl;
import org.xipki.ca.gateway.conf.ProtocolConf;
import org.xipki.util.Args;
import org.xipki.util.JSON;
import org.xipki.util.exception.InvalidConfException;

public class RestProtocolConf
extends ProtocolConf {
    private String authenticator;
    private CaProfileConf[] caProfiles;

    public static RestProtocolConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
        Args.notBlank((String)fileName, (String)"fileName");
        RestProtocolConf conf = (RestProtocolConf)((Object)JSON.parseConf((File)new File(fileName), RestProtocolConf.class));
        conf.validate();
        return conf;
    }

    public String getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(String authenticator) {
        this.authenticator = authenticator;
    }

    public CaProfileConf[] getCaProfiles() {
        return this.caProfiles;
    }

    public void setCaProfiles(CaProfileConf[] caProfiles) {
        this.caProfiles = caProfiles;
    }

    public void validate() throws InvalidConfException {
        RestProtocolConf.notBlank((String)this.authenticator, (String)"authenticator");
        if (this.caProfiles != null) {
            new CaProfilesControl(this.caProfiles).validate();
        }
    }
}

