/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.scep;

import java.util.HashMap;
import java.util.Map;
import org.xipki.ca.gateway.CaNameSigners;
import org.xipki.ca.gateway.scep.ScepSigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.util.Args;

public class CaNameScepSigners {
    private final ScepSigner defaultSigner;
    private final Map<String, ScepSigner> signers;

    public CaNameScepSigners(CaNameSigners signers) {
        ConcurrentContentSigner signer = signers.getDefaultSigner();
        this.defaultSigner = signer == null ? null : new ScepSigner(signer);
        this.signers = new HashMap<String, ScepSigner>();
        for (String name : signers.signerNames()) {
            this.signers.put(name, new ScepSigner(signers.getSigner(name)));
        }
    }

    public ScepSigner getSigner(String caName) {
        ScepSigner signer = this.signers.get(Args.toNonBlankLower((String)caName, (String)"caName"));
        return signer != null ? signer : this.defaultSigner;
    }
}

