/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.scep;

import java.io.File;
import java.io.IOException;
import org.xipki.ca.gateway.conf.CaNameSignersConf;
import org.xipki.ca.gateway.conf.CaProfileConf;
import org.xipki.ca.gateway.conf.CaProfilesControl;
import org.xipki.ca.gateway.conf.ProtocolConf;
import org.xipki.ca.gateway.scep.ScepControl;
import org.xipki.util.Args;
import org.xipki.util.JSON;
import org.xipki.util.exception.InvalidConfException;

public class ScepProtocolConf
extends ProtocolConf {
    private ScepControl scep;
    private String authenticator;
    private CaProfileConf[] caProfiles;
    private CaNameSignersConf signers;

    public static ScepProtocolConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
        Args.notBlank((String)fileName, (String)"fileName");
        ScepProtocolConf conf = (ScepProtocolConf)((Object)JSON.parseConf((File)new File(fileName), ScepProtocolConf.class));
        conf.validate();
        return conf;
    }

    public ScepControl getScep() {
        return this.scep;
    }

    public void setScep(ScepControl scep) {
        this.scep = scep;
    }

    public String getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(String authenticator) {
        this.authenticator = authenticator;
    }

    public CaProfileConf[] getCaProfiles() {
        return this.caProfiles;
    }

    public void setCaProfiles(CaProfileConf[] caProfiles) {
        this.caProfiles = caProfiles;
    }

    public CaNameSignersConf getSigners() {
        return this.signers;
    }

    public void setSigners(CaNameSignersConf signers) {
        this.signers = signers;
    }

    public void validate() throws InvalidConfException {
        ScepProtocolConf.notBlank((String)this.authenticator, (String)"authenticator");
        if (this.caProfiles != null) {
            new CaProfilesControl(this.caProfiles).validate();
        }
        ScepProtocolConf.notNull((Object)this.signers, (String)"signers");
        ScepProtocolConf.notNull((Object)this.scep, (String)"scep");
    }
}

