/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit;

import org.xipki.util.Args;

public enum AuditLevel {
    ERROR(3, "ERROR"),
    WARN(4, "WARN"),
    INFO(6, "INFO");

    private final int value;
    private final String text;

    private AuditLevel(int value, String text) {
        this.value = value;
        this.text = text;
    }

    public int getValue() {
        return this.value;
    }

    public static AuditLevel forName(String name) {
        Args.notNull((Object)name, (String)"name");
        for (AuditLevel value : AuditLevel.values()) {
            if (!value.name().equals(name)) continue;
            return value;
        }
        throw new IllegalArgumentException("invalid AuditLevel name " + name);
    }

    public static AuditLevel forValue(int value) {
        for (AuditLevel v : AuditLevel.values()) {
            if (v.getValue() != value) continue;
            return v;
        }
        throw new IllegalArgumentException("invalid AuditLevel code " + value);
    }

    public String getText() {
        return this.text;
    }
}

