/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit.services;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.services.MacAuditService;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class FileMacAuditService
extends MacAuditService {
    private static final Logger LOG = LoggerFactory.getLogger(FileMacAuditService.class);
    public static final String KEY_FILE = "file";
    private File logDir;
    private String logFileNamePrefix;
    private String logFileNameSuffix;
    private Instant lastMsOfToday;
    private OutputStreamWriter writer;
    private Path integrityFilePath;

    @Override
    protected void storeLog(Instant date, long thisId, int eventType, String levelText, long previousId, String message, String thisTag) {
        String logLine = this.formatDate(date) + ";" + levelText + ";" + eventType + ";" + this.shardId + ";" + thisId + ";" + previousId + ";" + thisTag + ";" + message;
        try {
            if (date.isAfter(this.lastMsOfToday)) {
                ZonedDateTime now = ZonedDateTime.ofInstant(date, ZoneId.systemDefault());
                int yyyyMMddNow = DateUtil.getYyyyMMdd((ZonedDateTime)now);
                this.lastMsOfToday = DateUtil.getLastMsOfDay((ZonedDateTime)now);
                this.writer.close();
                this.writer = this.buildWriter(yyyyMMddNow);
            }
            this.writer.write(logLine);
            this.writer.write(10);
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
        }
    }

    @Override
    protected void storeIntegrity(String integrityText) {
        if (integrityText != null) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(integrityText.getBytes(StandardCharsets.UTF_8));){
                this.writer.flush();
                Files.copy(is, this.integrityFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    @Override
    protected void doExtraInit(ConfPairs confPairs) throws InvalidConfException {
        String integrityText;
        Object prefix;
        String filePath = confPairs.value(KEY_FILE);
        if (StringUtil.isBlank((String)filePath)) {
            throw new IllegalArgumentException("property file not defined");
        }
        filePath = IoUtil.expandFilepath((String)StringUtil.resolveVariables((String)filePath), (boolean)true);
        File logFile = new File(filePath).getAbsoluteFile();
        this.logDir = logFile.getParentFile();
        try {
            IoUtil.mkdirs((File)this.logDir);
        }
        catch (IOException e) {
            throw new InvalidConfException("error mkdirs for " + this.logDir.getPath());
        }
        String fileName = logFile.getName();
        int idx = fileName.lastIndexOf(46);
        this.logFileNameSuffix = idx == -1 ? "" : fileName.substring(idx);
        Object object = prefix = idx == -1 ? fileName : fileName.substring(0, idx);
        if (this.shardId != 0) {
            prefix = (String)prefix + "-" + this.shardId;
        }
        this.logFileNamePrefix = (String)prefix + "_";
        ZonedDateTime now = ZonedDateTime.now();
        int yyyyMMddNow = DateUtil.getYyyyMMdd((ZonedDateTime)now);
        this.lastMsOfToday = DateUtil.getLastMsOfDay((ZonedDateTime)now);
        File[] existingLogFiles = this.logDir.listFiles();
        int latestYyyyMMdd = 0;
        if (existingLogFiles != null) {
            for (File f : existingLogFiles) {
                String fName = f.getName();
                if (!f.isFile() || !fName.startsWith(this.logFileNamePrefix) || !fName.endsWith(this.logFileNameSuffix) || fName.length() != this.logFileNamePrefix.length() + 10 + this.logFileNameSuffix.length()) continue;
                int startOffset = this.logFileNamePrefix.length();
                String ds = f.getName().substring(startOffset, startOffset + 10);
                try {
                    int yyyyMMdd = Integer.parseInt(ds.substring(0, 4) + ds.substring(5, 7) + ds.substring(8, 10));
                    if (yyyyMMdd > latestYyyyMMdd) {
                        latestYyyyMMdd = yyyyMMdd;
                    }
                }
                catch (Exception ex) {
                    LOG.warn("could not parse name of file {}, ignore it", (Object)f.getAbsolutePath());
                }
                if (latestYyyyMMdd <= yyyyMMddNow) continue;
                throw new IllegalStateException("audit file " + f.getAbsolutePath() + " is generated after " + yyyyMMddNow + ", this is not allowed.");
            }
        }
        this.integrityFilePath = new File(this.logDir, this.logFileNamePrefix.substring(0, this.logFileNamePrefix.length() - 1) + ".integrity").toPath();
        File integrityFile = this.integrityFilePath.toFile();
        try {
            integrityText = integrityFile.exists() ? IoUtil.readLastNonBlankLine((File)integrityFile) : null;
        }
        catch (IOException ex) {
            throw new IllegalStateException("error reading " + integrityFile.getPath(), ex);
        }
        if (latestYyyyMMdd > 0) {
            String lastLine;
            File latestFile = new File(this.logDir, this.buildFilename(latestYyyyMMdd));
            try {
                lastLine = IoUtil.readLastNonBlankLine((File)latestFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("error while reading " + latestFile.getPath());
            }
            StringTokenizer tokenizer = new StringTokenizer(lastLine, ";");
            int count = tokenizer.countTokens();
            String[] tokens = new String[count];
            for (int i = 0; i < count; ++i) {
                tokens[i] = tokenizer.nextToken();
            }
            int previousId = Integer.parseInt(tokens[4]);
            if (previousId < 1) {
                throw new IllegalStateException("invalid previous id " + tokens[5]);
            }
            this.id.set(previousId);
            this.previousTag = tokens[6];
        }
        this.verify(this.id.get(), this.previousTag, integrityText, confPairs);
        this.writer = this.buildWriter(yyyyMMddNow);
    }

    private OutputStreamWriter buildWriter(int yyyyMMdd) {
        FileOutputStream fw;
        File currentLogFile = new File(this.logDir, this.buildFilename(yyyyMMdd));
        try {
            fw = new FileOutputStream(currentLogFile, true);
        }
        catch (IOException ex) {
            throw new IllegalStateException("error opening file " + currentLogFile.getPath());
        }
        return new OutputStreamWriter(fw);
    }

    private String buildFilename(int yyyyMMdd) {
        int year = yyyyMMdd / 10000;
        int month = yyyyMMdd % 10000 / 100;
        int day = yyyyMMdd % 100;
        String dateStr = year + "." + (Serializable)(month < 10 ? "0" + month : Integer.valueOf(month)) + "." + (Serializable)(day < 10 ? "0" + day : Integer.valueOf(day));
        return this.logFileNamePrefix + dateStr + this.logFileNameSuffix;
    }

    @Override
    public void doClose() throws Exception {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }
}

