/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.asn1;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.time.Instant;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.CrlReason;
import org.xipki.security.asn1.Asn1StreamParser;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.SignerUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

public class CrlStreamParser
extends Asn1StreamParser {
    private static final Logger LOG = LoggerFactory.getLogger(CrlStreamParser.class);
    private final File crlFile;
    private final int version;
    private final X500Name issuer;
    private final Instant thisUpdate;
    private final Instant nextUpdate;
    private final AlgorithmIdentifier algorithmIdentifier;
    private final byte[] signature;
    private final BigInteger crlNumber;
    private final BigInteger baseCrlNumber;
    private final Extensions crlExtensions;
    private final int firstRevokedCertificateOffset;
    private final int revokedCertificatesEndIndex;
    private final int tbsCertListOffset;
    private final int tbsCertListEndIndex;

    public CrlStreamParser(File crlFile) throws IOException {
        this.crlFile = (File)Args.notNull((Object)crlFile, (String)"crlFile");
        try (BufferedInputStream instream = new BufferedInputStream(Files.newInputStream(crlFile.toPath(), new OpenOption[0]));){
            byte[] bytes;
            int offset = 0;
            int tag = CrlStreamParser.markAndReadTag(instream);
            if (tag == 45) {
                throw new IllegalArgumentException("The CRL is not DER encoded.");
            }
            CrlStreamParser.assertTag(48, tag, "CertificateList");
            ++offset;
            Asn1StreamParser.MyInt lenBytesSize = new Asn1StreamParser.MyInt();
            CrlStreamParser.readLength(lenBytesSize, instream);
            offset += lenBytesSize.get();
            this.tbsCertListOffset = offset++;
            tag = CrlStreamParser.markAndReadTag(instream);
            CrlStreamParser.assertTag(48, tag, "tbsCertList");
            int tbsCertListLength = CrlStreamParser.readLength(lenBytesSize, instream);
            this.tbsCertListEndIndex = (offset += lenBytesSize.get()) + tbsCertListLength;
            tag = CrlStreamParser.peekTag(instream);
            instream.reset();
            if (tag == 2) {
                bytes = CrlStreamParser.readBlock(instream, "tbsCertList.version");
                offset += bytes.length;
                this.version = ASN1Integer.getInstance((Object)bytes).getValue().intValue();
            } else {
                this.version = 0;
            }
            bytes = CrlStreamParser.readBlock(48, instream, "tbsCertList.signature");
            offset += bytes.length;
            AlgorithmIdentifier tbsSignature = AlgorithmIdentifier.getInstance((Object)bytes);
            bytes = CrlStreamParser.readBlock(48, instream, "tbsCertList.issuer");
            offset += bytes.length;
            this.issuer = X500Name.getInstance((Object)bytes);
            Asn1StreamParser.MyInt bytesLen = new Asn1StreamParser.MyInt();
            this.thisUpdate = CrlStreamParser.readTime(bytesLen, instream, "tbsCertList.thisUpdate");
            offset += bytesLen.get();
            tag = CrlStreamParser.peekTag(instream);
            if (tag != 48) {
                instream.reset();
                this.nextUpdate = CrlStreamParser.readTime(bytesLen, instream, "tbsCertList.thisUpdate");
                offset += bytesLen.get();
                tag = CrlStreamParser.peekTag(instream);
            } else {
                this.nextUpdate = null;
            }
            if (++offset < tbsCertListLength && 48 == tag) {
                CrlStreamParser.markAndReadTag(instream);
                int revokedCertificatesOffset = offset;
                int revokedCertificatesLength = CrlStreamParser.readLength(lenBytesSize, instream);
                this.revokedCertificatesEndIndex = revokedCertificatesOffset + revokedCertificatesLength;
                this.firstRevokedCertificateOffset = offset += lenBytesSize.get();
                CrlStreamParser.skip(instream, revokedCertificatesLength);
                offset += revokedCertificatesLength;
            } else {
                this.revokedCertificatesEndIndex = -1;
                this.firstRevokedCertificateOffset = -1;
            }
            int crlExtensionsTag = 160;
            Extensions extns = null;
            if (offset < this.tbsCertListEndIndex) {
                while (offset < this.tbsCertListEndIndex) {
                    tag = CrlStreamParser.markAndReadTag(instream);
                    ++offset;
                    int length = CrlStreamParser.readLength(bytesLen, instream);
                    offset += bytesLen.get();
                    if (tag != crlExtensionsTag) {
                        CrlStreamParser.skip(instream, length);
                        offset += length;
                        continue;
                    }
                    instream.mark(1);
                    bytes = CrlStreamParser.readBlock(48, instream, "crlExtensions");
                    offset += bytes.length;
                    extns = Extensions.getInstance((Object)bytes);
                }
            }
            this.crlExtensions = extns;
            if (this.crlExtensions != null) {
                bytes = X509Util.getCoreExtValue(this.crlExtensions, Extension.cRLNumber);
                this.crlNumber = bytes == null ? null : ASN1Integer.getInstance((Object)bytes).getValue();
                bytes = X509Util.getCoreExtValue(this.crlExtensions, Extension.deltaCRLIndicator);
                this.baseCrlNumber = bytes == null ? null : ASN1Integer.getInstance((Object)bytes).getPositiveValue();
            } else {
                this.crlNumber = null;
                this.baseCrlNumber = null;
            }
            bytes = CrlStreamParser.readBlock(48, instream, "signatureAlgorithm");
            this.algorithmIdentifier = AlgorithmIdentifier.getInstance((Object)bytes);
            if (!tbsSignature.equals((Object)this.algorithmIdentifier)) {
                throw new IllegalArgumentException("algorithmIdentifier != tbsCertList.signature");
            }
            bytes = CrlStreamParser.readBlock(3, instream, "signature");
            this.signature = ASN1BitString.getInstance((Object)bytes).getBytes();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Instant getThisUpdate() {
        return this.thisUpdate;
    }

    public Instant getNextUpdate() {
        return this.nextUpdate;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public byte[] getSignature() {
        return Arrays.copyOf((byte[])this.signature, (int)this.signature.length);
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    public BigInteger getBaseCrlNumber() {
        return this.baseCrlNumber;
    }

    public boolean isDeltaCrl() {
        return this.baseCrlNumber != null;
    }

    public Extensions getCrlExtensions() {
        return this.crlExtensions;
    }

    public boolean verifySignature(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        PublicKey publicKey;
        try {
            publicKey = KeyUtil.generatePublicKey(publicKeyInfo);
        }
        catch (InvalidKeySpecException ex) {
            throw new IllegalArgumentException("error parsing public key", ex);
        }
        return this.verifySignature(publicKey);
    }

    public boolean verifySignature(PublicKey publicKey) throws IOException {
        try {
            ContentVerifierProvider cvp = SignerUtil.getContentVerifierProvider(publicKey, null);
            ContentVerifier verifier = cvp.get(this.algorithmIdentifier);
            OutputStream sigOut = verifier.getOutputStream();
            try (InputStream crlStream = Files.newInputStream(this.crlFile.toPath(), new OpenOption[0]);){
                int count;
                CrlStreamParser.skip(crlStream, this.tbsCertListOffset);
                int remainingLength = this.tbsCertListEndIndex - this.tbsCertListOffset;
                byte[] buffer = new byte[1024];
                while ((count = crlStream.read(buffer)) != -1) {
                    if (count > 0) {
                        if (count <= remainingLength) {
                            sigOut.write(buffer, 0, count);
                            remainingLength -= count;
                        } else {
                            sigOut.write(buffer, 0, remainingLength);
                            remainingLength = 0;
                        }
                    }
                    if (remainingLength != 0) continue;
                    break;
                }
                if (remainingLength != 0) {
                    throw new IOException("could reading all tbsCertList");
                }
            }
            sigOut.close();
            return verifier.verify(this.getSignature());
        }
        catch (InvalidKeyException | OperatorCreationException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not validate POP of CSR");
            return false;
        }
    }

    public RevokedCertsIterator revokedCertificates() throws IOException {
        return new RevokedCertsIterator();
    }

    public class RevokedCertsIterator
    implements Iterator<RevokedCert>,
    Closeable {
        private BufferedInputStream instream;
        private RevokedCert next;
        private int offset;

        private RevokedCertsIterator() throws IOException {
            this.instream = new BufferedInputStream(Files.newInputStream(CrlStreamParser.this.crlFile.toPath(), new OpenOption[0]));
            Asn1StreamParser.skip(this.instream, CrlStreamParser.this.firstRevokedCertificateOffset);
            this.offset = CrlStreamParser.this.firstRevokedCertificateOffset;
            this.next0();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public RevokedCert next() {
            if (this.next == null) {
                throw new IllegalStateException("no next object anymore");
            }
            RevokedCert ret = this.next;
            this.next0();
            return ret;
        }

        private void next0() {
            byte[] bytes;
            if (this.offset >= CrlStreamParser.this.revokedCertificatesEndIndex) {
                this.next = null;
                return;
            }
            try {
                bytes = Asn1StreamParser.readBlock(48, this.instream, "revokedCertificate");
            }
            catch (IOException ex) {
                throw new IllegalStateException("error reading next revokedCertificate", ex);
            }
            this.offset += bytes.length;
            ASN1Sequence revCert = ASN1Sequence.getInstance((Object)bytes);
            BigInteger serialNumber = ASN1Integer.getInstance((Object)revCert.getObjectAt(0)).getValue();
            Instant revocationDate = Asn1StreamParser.readTime(revCert.getObjectAt(1));
            Instant invalidityDate = null;
            int reason = 0;
            X500Name certificateIssuer = null;
            if (revCert.size() > 2) {
                byte[] coreExtValue;
                Extensions extns;
                block10: {
                    extns = Extensions.getInstance((Object)revCert.getObjectAt(2));
                    coreExtValue = X509Util.getCoreExtValue(extns, Extension.certificateIssuer);
                    if (coreExtValue != null) {
                        certificateIssuer = X500Name.getInstance((Object)GeneralNames.getInstance((Object)coreExtValue).getNames()[0].getName());
                    }
                    if ((coreExtValue = X509Util.getCoreExtValue(extns, Extension.invalidityDate)) != null) {
                        int tag = coreExtValue[0] & 0xFF;
                        try {
                            if (tag == 23) {
                                invalidityDate = DERUTCTime.getInstance((Object)coreExtValue).getDate().toInstant();
                                break block10;
                            }
                            if (tag == 24) {
                                invalidityDate = DERGeneralizedTime.getInstance((Object)coreExtValue).getDate().toInstant();
                                break block10;
                            }
                            throw new IllegalArgumentException("invalid tag " + tag);
                        }
                        catch (ParseException ex) {
                            throw new IllegalArgumentException("error parsing time", ex);
                        }
                    }
                }
                reason = (coreExtValue = X509Util.getCoreExtValue(extns, Extension.reasonCode)) == null ? CrlReason.UNSPECIFIED.getCode() : CRLReason.getInstance((Object)coreExtValue).getValue().intValue();
            }
            this.next = new RevokedCert(serialNumber, revocationDate, reason, invalidityDate, certificateIssuer);
        }

        @Override
        public void close() throws IOException {
            if (this.instream != null) {
                this.instream.close();
            }
            this.instream = null;
        }
    }

    public static class RevokedCert {
        private final BigInteger serialNumber;
        private final long revocationDate;
        private final int reason;
        private final long invalidityDate;
        private final X500Name certificateIssuer;

        private RevokedCert(BigInteger serialNumber, Instant revocationDate, int reason, Instant invalidityDate, X500Name certificateIssuer) {
            this.serialNumber = serialNumber;
            this.revocationDate = revocationDate.getEpochSecond();
            this.reason = reason;
            this.certificateIssuer = certificateIssuer;
            this.invalidityDate = invalidityDate == null ? 0L : (revocationDate.equals(invalidityDate) ? 0L : invalidityDate.getEpochSecond());
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public long getRevocationDate() {
            return this.revocationDate;
        }

        public int getReason() {
            return this.reason;
        }

        public long getInvalidityDate() {
            return this.invalidityDate;
        }

        public X500Name getCertificateIssuer() {
            return this.certificateIssuer;
        }
    }
}

