/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

public abstract class P11Key {
    private static final Logger LOG = LoggerFactory.getLogger(P11Key.class);
    protected final P11Slot slot;
    protected final PKCS11KeyId keyId;
    private boolean sign;
    protected ASN1ObjectIdentifier ecParams;
    protected Integer ecOrderBitSize;
    protected BigInteger rsaModulus;
    protected BigInteger rsaPublicExponent;
    protected BigInteger dsaP;
    protected BigInteger dsaQ;
    protected BigInteger dsaG;
    private boolean publicKeyInitialized;
    private PublicKey publicKey;

    protected P11Key(P11Slot slot, PKCS11KeyId keyId) {
        this.slot = (P11Slot)Args.notNull((Object)slot, (String)"slot");
        this.keyId = (PKCS11KeyId)Args.notNull((Object)keyId, (String)"keyId");
    }

    public P11Key sign(Boolean sign) {
        this.sign = sign == null || sign != false;
        return this;
    }

    public abstract void destroy() throws TokenException;

    public boolean isSign() {
        return this.sign;
    }

    public ASN1ObjectIdentifier getEcParams() {
        return this.ecParams;
    }

    public Integer getEcOrderBitSize() {
        return this.ecOrderBitSize;
    }

    public void setEcParams(ASN1ObjectIdentifier ecParams) {
        if (ecParams == null) {
            this.ecOrderBitSize = null;
        } else {
            try {
                this.ecOrderBitSize = Functions.getCurveOrderBitLength((byte[])ecParams.getEncoded());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.ecParams = ecParams;
    }

    public BigInteger getRsaModulus() {
        return this.rsaModulus;
    }

    public BigInteger getRsaPublicExponent() {
        return this.rsaPublicExponent;
    }

    public void setRsaMParameters(BigInteger modulus, BigInteger publicExponent) {
        this.rsaModulus = modulus;
        this.rsaPublicExponent = publicExponent;
    }

    public BigInteger getDsaP() {
        return this.dsaP;
    }

    public BigInteger getDsaQ() {
        return this.dsaQ;
    }

    public BigInteger getDsaG() {
        return this.dsaG;
    }

    public void setDsaParameters(BigInteger p, BigInteger q, BigInteger g) {
        this.dsaP = p;
        this.dsaQ = q;
        this.dsaG = g;
    }

    public byte[] sign(long mechanism, P11Params parameters, byte[] content) throws TokenException {
        Args.notNull((Object)content, (String)"content");
        if (!this.supportsSign(mechanism)) {
            throw new TokenException("this identity is not suitable for sign with " + PKCS11Constants.ckmCodeToName((long)mechanism));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sign with mechanism {}", (Object)PKCS11Constants.ckmCodeToName((long)mechanism));
        }
        return this.sign0(mechanism, parameters, content);
    }

    public boolean supportsSign(long mechanism) {
        return this.sign && this.keyId.getObjectCLass() != 2L && this.keyId.getKeyType() != 65L && this.slot.supportsMechanism(mechanism, 2048L);
    }

    protected abstract byte[] sign0(long var1, P11Params var3, byte[] var4) throws TokenException;

    public byte[] digestSecretKey(long mechanism) throws TokenException {
        if (!this.supportsDigest(mechanism)) {
            throw new TokenException("cannot digest this identity with " + PKCS11Constants.ckmCodeToName((long)mechanism));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("digest secret key with mechanism {}", (Object)PKCS11Constants.ckmCodeToName((long)mechanism));
        }
        return this.digestSecretKey0(mechanism);
    }

    public boolean supportsDigest(long mechanism) {
        return this.keyId.getObjectCLass() == 4L && this.slot.supportsMechanism(mechanism, 1024L);
    }

    protected abstract byte[] digestSecretKey0(long var1) throws TokenException;

    protected abstract PublicKey getPublicKey0() throws TokenException;

    public P11SlotId getSlotId() {
        return this.slot.getSlotId();
    }

    public PKCS11KeyId getKeyId() {
        return this.keyId;
    }

    public long getKeyType() {
        return this.keyId.getKeyType();
    }

    public boolean isSecretKey() {
        return this.keyId.getObjectCLass() == 4L;
    }

    public PublicKey getPublicKey() {
        if (this.isSecretKey()) {
            return null;
        }
        if (this.publicKeyInitialized) {
            return this.publicKey;
        }
        try {
            this.publicKey = this.getPublicKey0();
        }
        catch (Exception e) {
            LogUtil.error((Logger)LOG, (Throwable)e, (String)("could not initialize public key for (private) key " + this.keyId + " on slot " + this.slot.getSlotId()));
        }
        finally {
            this.publicKeyInitialized = true;
        }
        return this.publicKey;
    }
}

