/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.util.Args;

public abstract class P11Module {
    protected final P11ModuleConf conf;
    private final Map<P11SlotId, P11Slot> slots = new HashMap<P11SlotId, P11Slot>();
    private final List<P11SlotId> slotIds = new ArrayList<P11SlotId>();

    public P11Module(P11ModuleConf conf) {
        this.conf = (P11ModuleConf)Args.notNull((Object)conf, (String)"conf");
    }

    public abstract void close();

    public abstract String getDescription();

    public String getName() {
        return this.conf.getName();
    }

    public boolean isReadOnly() {
        return this.conf.isReadOnly();
    }

    public P11ModuleConf getConf() {
        return this.conf;
    }

    protected void setSlots(Set<P11Slot> slots) {
        this.slots.clear();
        this.slotIds.clear();
        for (P11Slot slot : slots) {
            this.slots.put(slot.getSlotId(), slot);
            this.slotIds.add(slot.getSlotId());
        }
    }

    public P11Slot getSlot(P11SlotId slotId) throws TokenException {
        return Optional.ofNullable(this.slots.get(Args.notNull((Object)slotId, (String)"slotId"))).orElseThrow(() -> new TokenException("unknown slot " + slotId));
    }

    public List<P11SlotId> getSlotIds() {
        return this.slotIds;
    }

    public P11SlotId getSlotIdForIndex(int index) throws TokenException {
        for (P11SlotId id : this.slotIds) {
            if (id.getIndex() != index) continue;
            return id;
        }
        throw new TokenException("could not find slot with index " + index);
    }

    public P11SlotId getSlotIdForId(long id) throws TokenException {
        for (P11SlotId slotId : this.slotIds) {
            if (slotId.getId() != id) continue;
            return slotId;
        }
        throw new TokenException("could not find slot with id " + id);
    }
}

