/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.Passwords;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.pkcs11.Pkcs11conf;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class P11ModuleConf {
    private static final Logger LOG = LoggerFactory.getLogger(P11ModuleConf.class);
    private final String name;
    private final String type;
    private final String nativeLibrary;
    private final Map<String, String> nativeLibraryProperties;
    private final Set<P11SlotIdFilter> excludeSlots;
    private final Set<P11SlotIdFilter> includeSlots;
    private final P11PasswordsRetriever passwordRetriever;
    private final P11MechanismFilter mechanismFilter;
    private final Integer newSessionTimeout;
    private final String userType;
    private final char[] userName;
    private boolean readOnly;
    private int maxMessageSize;
    private Integer numSessions;
    private P11NewObjectConf newObjectConf;
    private List<Long> secretKeyTypes;
    private List<Long> keyPairTypes;

    public P11ModuleConf(Pkcs11conf.Module moduleType, List<Pkcs11conf.MechanismSet> mechanismSets) throws InvalidConfException {
        ArrayList<Long> ll;
        this.name = ((Pkcs11conf.Module)((Object)Args.notNull((Object)((Object)moduleType), (String)"moduleType"))).getName();
        this.readOnly = moduleType.isReadonly();
        this.userType = moduleType.getUser().toUpperCase();
        this.userName = moduleType.getUserName() == null ? null : moduleType.getUserName().toCharArray();
        this.maxMessageSize = moduleType.getMaxMessageSize();
        this.type = moduleType.getType();
        if (this.maxMessageSize < 256) {
            throw new InvalidConfException("invalid maxMessageSize (< 256): " + this.maxMessageSize);
        }
        this.numSessions = moduleType.getNumSessions();
        this.newSessionTimeout = moduleType.getNewSessionTimeout();
        List<String> list = moduleType.getSecretKeyTypes();
        if (list == null) {
            this.secretKeyTypes = null;
        } else {
            ll = new ArrayList<Long>(list.size());
            for (String s : list) {
                Long l = P11ModuleConf.toKeyType(s);
                if (l == null) continue;
                ll.add(l);
            }
            this.secretKeyTypes = Collections.unmodifiableList(ll);
        }
        list = moduleType.getKeyPairTypes();
        if (list == null) {
            this.keyPairTypes = null;
        } else {
            ll = new ArrayList(list.size());
            for (String s : list) {
                Long l = P11ModuleConf.toKeyType(s);
                if (l == null) continue;
                ll.add(l);
            }
            this.keyPairTypes = Collections.unmodifiableList(ll);
        }
        HashMap<String, MechanismSet> mechanismSetsMap = new HashMap<String, MechanismSet>();
        if (mechanismSets != null) {
            for (Object m : mechanismSets) {
                String string = m.getName();
                if (mechanismSetsMap.containsKey(string)) {
                    throw new InvalidConfException("Duplication mechanismSets named " + string);
                }
                MechanismSet mechanismSet = new MechanismSet();
                mechanismSet.includeMechanisms = new HashSet<String>();
                mechanismSet.excludeMechanisms = new HashSet<String>();
                for (String mechStr : m.getMechanisms()) {
                    if ((mechStr = mechStr.trim().toUpperCase()).equals("ALL")) {
                        mechanismSet.includeMechanisms = null;
                        break;
                    }
                    mechanismSet.includeMechanisms.add(mechStr);
                }
                for (String mechStr : m.getExcludeMechanisms()) {
                    mechanismSet.excludeMechanisms.add(mechStr.trim().toUpperCase());
                }
                mechanismSetsMap.put(string, mechanismSet);
            }
        }
        this.mechanismFilter = new P11MechanismFilter();
        List<Pkcs11conf.MechanismFilter> mechFilters = moduleType.getMechanismFilters();
        if (CollectionUtil.isNotEmpty(mechFilters)) {
            for (Pkcs11conf.MechanismFilter mechanismFilter : mechFilters) {
                Set<P11SlotIdFilter> slots = P11ModuleConf.getSlotIdFilters(mechanismFilter.getSlots());
                String mechanismSetName = mechanismFilter.getMechanismSet();
                MechanismSet mechanismSet = (MechanismSet)mechanismSetsMap.get(mechanismSetName);
                if (mechanismSet == null) {
                    throw new InvalidConfException("MechanismSet '" + mechanismSetName + "' is not defined");
                }
                this.mechanismFilter.addEntry(slots, mechanismSet.includeMechanisms, mechanismSet.excludeMechanisms);
            }
        }
        this.passwordRetriever = new P11PasswordsRetriever();
        List<Pkcs11conf.PasswordSet> passwordsList = moduleType.getPasswordSets();
        if (CollectionUtil.isNotEmpty(passwordsList)) {
            for (Pkcs11conf.PasswordSet passwordType : passwordsList) {
                Set<P11SlotIdFilter> slots = P11ModuleConf.getSlotIdFilters(passwordType.getSlots());
                this.passwordRetriever.addPasswordEntry(slots, new ArrayList<String>(passwordType.getPasswords()));
            }
        }
        this.includeSlots = P11ModuleConf.getSlotIdFilters(moduleType.getIncludeSlots());
        this.excludeSlots = P11ModuleConf.getSlotIdFilters(moduleType.getExcludeSlots());
        String string = System.getProperty("os.name").toLowerCase();
        Pkcs11conf.NativeLibrary matchLibrary = P11ModuleConf.getNativeLibrary(moduleType, string);
        this.nativeLibrary = matchLibrary.getPath();
        this.nativeLibraryProperties = matchLibrary.getProperties();
        this.newObjectConf = moduleType.getNewObjectConf() == null ? new P11NewObjectConf() : new P11NewObjectConf(moduleType.getNewObjectConf());
    }

    private static Pkcs11conf.NativeLibrary getNativeLibrary(Pkcs11conf.Module moduleType, String osName) throws InvalidConfException {
        Pkcs11conf.NativeLibrary matchLibrary = null;
        block0: for (Pkcs11conf.NativeLibrary library : moduleType.getNativeLibraries()) {
            List<String> osNames = library.getOperationSystems();
            if (CollectionUtil.isEmpty(osNames)) {
                matchLibrary = library;
                continue;
            }
            for (String entry : osNames) {
                if (!osName.contains(entry.toLowerCase())) continue;
                matchLibrary = library;
                continue block0;
            }
        }
        if (matchLibrary == null) {
            throw new InvalidConfException("could not find PKCS#11 library for OS " + osName);
        }
        return matchLibrary;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getNativeLibrary() {
        return this.nativeLibrary;
    }

    public Map<String, String> getNativeLibraryProperties() {
        return this.nativeLibraryProperties;
    }

    public void setNewObjectConf(P11NewObjectConf newObjectConf) {
        this.newObjectConf = (P11NewObjectConf)Args.notNull((Object)newObjectConf, (String)"newObjectConf");
    }

    public P11NewObjectConf getNewObjectConf() {
        return this.newObjectConf;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getUserType() {
        return this.userType;
    }

    public char[] getUserName() {
        return this.userName;
    }

    public P11PasswordsRetriever getPasswordRetriever() {
        return this.passwordRetriever;
    }

    public void setNumSessions(Integer numSessions) {
        this.numSessions = numSessions;
    }

    public Integer getNumSessions() {
        return this.numSessions;
    }

    public Integer getNewSessionTimeout() {
        return this.newSessionTimeout;
    }

    public void setSecretKeyTypes(List<Long> secretKeyTypes) {
        this.secretKeyTypes = secretKeyTypes;
    }

    public List<Long> getSecretKeyTypes() {
        return this.secretKeyTypes;
    }

    public void setKeyPairTypes(List<Long> keyPairTypes) {
        this.keyPairTypes = keyPairTypes;
    }

    public List<Long> getKeyPairTypes() {
        return this.keyPairTypes;
    }

    public boolean isSlotIncluded(P11SlotId slotId) {
        boolean included;
        Args.notNull((Object)slotId, (String)"slotId");
        if (CollectionUtil.isEmpty(this.includeSlots)) {
            included = true;
        } else {
            included = false;
            for (P11SlotIdFilter entry : this.includeSlots) {
                if (!entry.match(slotId)) continue;
                included = true;
                break;
            }
        }
        if (!included) {
            return false;
        }
        if (CollectionUtil.isEmpty(this.excludeSlots)) {
            return true;
        }
        for (P11SlotIdFilter entry : this.excludeSlots) {
            if (!entry.match(slotId)) continue;
            return false;
        }
        return true;
    }

    public P11MechanismFilter getP11MechanismFilter() {
        return this.mechanismFilter;
    }

    public P11NewObjectConf getP11NewObjectConf() {
        return this.newObjectConf;
    }

    private static Set<P11SlotIdFilter> getSlotIdFilters(List<Pkcs11conf.Slot> slotTypes) throws InvalidConfException {
        if (CollectionUtil.isEmpty(slotTypes)) {
            return null;
        }
        HashSet<P11SlotIdFilter> filters = new HashSet<P11SlotIdFilter>();
        for (Pkcs11conf.Slot slotType : slotTypes) {
            Long slotId = null;
            if (slotType.getId() != null) {
                String str = slotType.getId().trim();
                try {
                    slotId = StringUtil.startsWithIgnoreCase((String)str, (String)"0X") ? Long.parseLong(str.substring(2), 16) : Long.parseLong(str);
                }
                catch (NumberFormatException ex) {
                    String message = "invalid slotId '" + str + "'";
                    LOG.error(message);
                    throw new InvalidConfException(message);
                }
            }
            filters.add(new P11SlotIdFilter(slotType.getIndex(), slotId));
        }
        return filters;
    }

    private static Long toKeyType(String str) {
        if (str.startsWith("CKK_")) {
            return PKCS11Constants.nameToCode((PKCS11Constants.Category)PKCS11Constants.Category.CKK, (String)str);
        }
        int radix = 10;
        if (str.startsWith("0X")) {
            radix = 16;
            str = str.substring(2);
        }
        if (str.endsWith("UL")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("L")) {
            str = str.substring(0, str.length() - 1);
        }
        try {
            return Long.parseLong(str, radix);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static class P11NewObjectConf {
        private boolean ignoreLabel;
        private int idLength = 8;

        public P11NewObjectConf(Pkcs11conf.NewObjectConf conf) {
            Boolean bb = conf.getIgnoreLabel();
            this.ignoreLabel = bb != null && bb != false;
            Integer ii = conf.getIdLength();
            this.idLength = ii == null ? 8 : ii;
        }

        public P11NewObjectConf() {
        }

        public boolean isIgnoreLabel() {
            return this.ignoreLabel;
        }

        public void setIgnoreLabel(boolean ignoreLabel) {
            this.ignoreLabel = ignoreLabel;
        }

        public int getIdLength() {
            return this.idLength;
        }

        public void setIdLength(int idLength) {
            this.idLength = idLength;
        }
    }

    public static class P11PasswordsRetriever {
        private final List<P11SinglePasswordRetriever> singleRetrievers = new LinkedList<P11SinglePasswordRetriever>();

        P11PasswordsRetriever() {
        }

        void addPasswordEntry(Set<P11SlotIdFilter> slots, List<String> passwords) {
            this.singleRetrievers.add(new P11SinglePasswordRetriever(slots, passwords));
        }

        public List<char[]> getPassword(P11SlotId slotId) throws PasswordResolverException {
            Args.notNull((Object)slotId, (String)"slotId");
            if (CollectionUtil.isEmpty(this.singleRetrievers)) {
                return null;
            }
            for (P11SinglePasswordRetriever sr : this.singleRetrievers) {
                if (!sr.match(slotId)) continue;
                return sr.getPasswords();
            }
            return null;
        }

        private static final class P11SinglePasswordRetriever {
            private final Set<P11SlotIdFilter> slots;
            private final List<String> passwords;

            private P11SinglePasswordRetriever(Set<P11SlotIdFilter> slots, List<String> passwords) {
                this.slots = slots;
                this.passwords = CollectionUtil.isEmpty(passwords) ? null : passwords;
            }

            public boolean match(P11SlotId slot) {
                if (this.slots == null) {
                    return true;
                }
                for (P11SlotIdFilter m : this.slots) {
                    if (!m.match(slot)) continue;
                    return true;
                }
                return false;
            }

            public List<char[]> getPasswords() throws PasswordResolverException {
                if (this.passwords == null) {
                    return null;
                }
                ArrayList<char[]> ret = new ArrayList<char[]>(this.passwords.size());
                for (String password : this.passwords) {
                    ret.add(Passwords.resolvePassword((String)password));
                }
                return ret;
            }
        }
    }

    public static class P11MechanismFilter {
        private final List<P11SingleMechanismFilter> singleFilters = new LinkedList<P11SingleMechanismFilter>();

        P11MechanismFilter() {
        }

        void addEntry(Set<P11SlotIdFilter> slots, Collection<String> includeMechanisms, Collection<String> excludeMechanisms) {
            this.singleFilters.add(new P11SingleMechanismFilter(slots, includeMechanisms, excludeMechanisms));
        }

        public boolean isMechanismPermitted(P11SlotId slotId, long mechanism, PKCS11Module module) {
            Args.notNull((Object)slotId, (String)"slotId");
            if (CollectionUtil.isEmpty(this.singleFilters)) {
                return true;
            }
            for (P11SingleMechanismFilter sr : this.singleFilters) {
                if (!sr.match(slotId)) continue;
                return sr.isMechanismSupported(mechanism, module);
            }
            return true;
        }
    }

    private static final class P11SingleMechanismFilter {
        private static final Object NULL_MODULE = new Object();
        private final Set<P11SlotIdFilter> slots;
        private final Collection<String> includeMechanisms;
        private final Collection<String> excludeMechanisms;
        private Object module;
        private final Set<Long> includeMechanismCodes = new HashSet<Long>();
        private final Set<Long> excludeMechanismCodes = new HashSet<Long>();

        private P11SingleMechanismFilter(Set<P11SlotIdFilter> slots, Collection<String> includeMechanisms, Collection<String> excludeMechanisms) {
            this.slots = slots;
            this.includeMechanisms = CollectionUtil.isEmpty(includeMechanisms) ? null : includeMechanisms;
            this.excludeMechanisms = CollectionUtil.isEmpty(excludeMechanisms) ? null : excludeMechanisms;
        }

        public boolean match(P11SlotId slot) {
            if (this.slots == null) {
                return true;
            }
            for (P11SlotIdFilter m : this.slots) {
                if (!m.match(slot)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMechanismSupported(long mechanism, PKCS11Module module) {
            if (this.includeMechanisms == null && this.excludeMechanisms == null) {
                return true;
            }
            P11SingleMechanismFilter p11SingleMechanismFilter = this;
            synchronized (p11SingleMechanismFilter) {
                boolean computeCodes;
                boolean bl = module != null ? this.module != module : (computeCodes = this.module != NULL_MODULE);
                if (computeCodes) {
                    Long mechCode;
                    this.includeMechanismCodes.clear();
                    this.excludeMechanismCodes.clear();
                    if (this.includeMechanisms != null) {
                        for (String mechName : this.includeMechanisms) {
                            mechCode = module != null ? module.nameToCode(PKCS11Constants.Category.CKM, mechName) : PKCS11Constants.nameToCode((PKCS11Constants.Category)PKCS11Constants.Category.CKM, (String)mechName);
                            if (mechCode == null) continue;
                            this.includeMechanismCodes.add(mechCode);
                        }
                    }
                    if (this.excludeMechanisms != null) {
                        for (String mechName : this.excludeMechanisms) {
                            mechCode = module != null ? module.nameToCode(PKCS11Constants.Category.CKM, mechName) : PKCS11Constants.nameToCode((PKCS11Constants.Category)PKCS11Constants.Category.CKM, (String)mechName);
                            if (mechCode == null) continue;
                            this.excludeMechanismCodes.add(mechCode);
                        }
                    }
                    this.module = module != null ? module : NULL_MODULE;
                }
            }
            if (this.excludeMechanismCodes.contains(mechanism)) {
                return false;
            }
            return this.includeMechanisms == null || this.includeMechanismCodes.contains(mechanism);
        }
    }

    private static final class MechanismSet {
        private Set<String> includeMechanisms;
        private Set<String> excludeMechanisms;

        private MechanismSet() {
        }
    }

    private static class P11SlotIdFilter {
        private final Integer index;
        private final Long id;

        P11SlotIdFilter(Integer index, Long id) {
            if (index == null && id == null) {
                throw new IllegalArgumentException("at least one of index and id may not be null");
            }
            this.index = index;
            this.id = id;
        }

        boolean match(P11SlotId slotId) {
            if (this.index != null && this.index.intValue() != slotId.getIndex()) {
                return false;
            }
            if (this.id != null) {
                return this.id.longValue() == slotId.getId();
            }
            return true;
        }
    }
}

