/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.params.ByteArrayParams;
import org.xipki.pkcs11.wrapper.params.CkParams;
import org.xipki.pkcs11.wrapper.params.CkParamsWithExtra;
import org.xipki.pkcs11.wrapper.params.ExtraParams;
import org.xipki.pkcs11.wrapper.params.RSA_PKCS_PSS_PARAMS;
import org.xipki.security.HashAlgo;

public interface P11Params {
    default public Mechanism toMechanism(long mechanism, ExtraParams extraParams) throws TokenException {
        ByteArrayParams paramObj;
        if (this instanceof P11RSAPkcsPssParams) {
            P11RSAPkcsPssParams param = (P11RSAPkcsPssParams)this;
            paramObj = new RSA_PKCS_PSS_PARAMS(param.getHashAlgorithm(), param.getMaskGenerationFunction(), param.getSaltLength());
        } else if (this instanceof P11ByteArrayParams) {
            paramObj = new ByteArrayParams(((P11ByteArrayParams)this).getBytes());
        } else {
            throw new TokenException("unknown P11Parameters " + this.getClass().getName());
        }
        if (extraParams != null) {
            paramObj = new CkParamsWithExtra((CkParams)paramObj, extraParams);
        }
        return new Mechanism(mechanism, (CkParams)paramObj);
    }

    public static class P11RSAPkcsPssParams
    implements P11Params {
        private final long hashAlgorithm;
        private final long maskGenerationFunction;
        private final int saltLength;

        public P11RSAPkcsPssParams(long hashAlgorithm, long maskGenerationFunction, int saltLength) {
            this.hashAlgorithm = hashAlgorithm;
            this.maskGenerationFunction = maskGenerationFunction;
            this.saltLength = saltLength;
        }

        public P11RSAPkcsPssParams(HashAlgo hashAlgo) {
            this.saltLength = hashAlgo.getLength();
            switch (hashAlgo) {
                case SHA1: {
                    this.hashAlgorithm = 544L;
                    this.maskGenerationFunction = 1L;
                    break;
                }
                case SHA224: {
                    this.hashAlgorithm = 597L;
                    this.maskGenerationFunction = 5L;
                    break;
                }
                case SHA256: {
                    this.hashAlgorithm = 592L;
                    this.maskGenerationFunction = 2L;
                    break;
                }
                case SHA384: {
                    this.hashAlgorithm = 608L;
                    this.maskGenerationFunction = 3L;
                    break;
                }
                case SHA512: {
                    this.hashAlgorithm = 624L;
                    this.maskGenerationFunction = 4L;
                    break;
                }
                case SHA3_224: {
                    this.hashAlgorithm = 693L;
                    this.maskGenerationFunction = 6L;
                    break;
                }
                case SHA3_256: {
                    this.hashAlgorithm = 688L;
                    this.maskGenerationFunction = 7L;
                    break;
                }
                case SHA3_384: {
                    this.hashAlgorithm = 704L;
                    this.maskGenerationFunction = 8L;
                    break;
                }
                case SHA3_512: {
                    this.hashAlgorithm = 720L;
                    this.maskGenerationFunction = 9L;
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported Hash algorithm " + hashAlgo);
                }
            }
        }

        public long getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        public long getMaskGenerationFunction() {
            return this.maskGenerationFunction;
        }

        public int getSaltLength() {
            return this.saltLength;
        }
    }

    public static class P11ByteArrayParams
    implements P11Params {
        private final byte[] bytes;

        public P11ByteArrayParams(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

