/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolverException;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.pkcs11.emulator.EmulatorKeyCryptor;
import org.xipki.security.pkcs11.emulator.EmulatorP11Slot;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

class EmulatorP11Module
extends P11Module {
    public static final String TYPE = "emulator";
    public static final String DFLT_BASEDIR = System.getProperty("java.io.tmpdir") + File.separator + "pkcs11-emulator";
    private static final Logger LOG = LoggerFactory.getLogger(EmulatorP11Module.class);
    private final String description;

    private EmulatorP11Module(P11ModuleConf moduleConf) throws TokenException {
        super(moduleConf);
        File baseDir;
        int idx;
        if (CollectionUtil.isNotEmpty(moduleConf.getNativeLibraryProperties())) {
            throw new TokenException("nativeLibraries[i].properties is present but not allowed.");
        }
        String modulePath = moduleConf.getNativeLibrary().trim();
        String parametersStr = "";
        if (!modulePath.isEmpty() && (idx = modulePath.indexOf(63)) != -1) {
            parametersStr = modulePath.substring(idx);
            modulePath = modulePath.substring(0, idx);
        }
        if (modulePath.isEmpty()) {
            baseDir = new File(DFLT_BASEDIR);
            LOG.info("Use existing default base directory: " + DFLT_BASEDIR);
        } else {
            baseDir = new File(IoUtil.expandFilepath((String)modulePath));
            LOG.info("Use explicit base directory: " + baseDir.getPath());
        }
        if (!baseDir.exists()) {
            try {
                this.createExampleRepository(baseDir);
            }
            catch (IOException ex) {
                throw new TokenException("could not initialize the base directory: " + baseDir.getPath(), (Exception)ex);
            }
            LOG.info("create and initialize the base directory: " + baseDir.getPath());
        }
        this.description = StringUtil.concat((String)"PKCS#11 emulator", (String[])new String[]{"\nPath: ", baseDir.getAbsolutePath() + parametersStr});
        LOG.info("PKCS#11 module\n{}", (Object)this.description);
        File[] children = baseDir.listFiles();
        if (children == null || children.length == 0) {
            LOG.error("found no slots");
            this.setSlots(Collections.emptySet());
            return;
        }
        HashSet<Integer> allSlotIndexes = new HashSet<Integer>();
        HashSet<Long> allSlotIdentifiers = new HashSet<Long>();
        LinkedList<P11SlotId> slotIds = new LinkedList<P11SlotId>();
        for (File child : children) {
            long slotId;
            int slotIndex;
            if (child.isDirectory() && child.canRead() && !child.exists()) {
                LOG.warn("ignore path {}, it does not point to a readable existing directory", (Object)child.getPath());
                continue;
            }
            String filename = child.getName();
            String[] tokens = filename.split("-");
            if (tokens.length != 2) {
                LOG.warn("ignore dir {}, invalid filename syntax", (Object)child.getPath());
                continue;
            }
            try {
                slotIndex = Integer.parseInt(tokens[0]);
                slotId = Long.parseLong(tokens[1]);
            }
            catch (NumberFormatException ex) {
                LOG.warn("ignore dir {}, invalid filename syntax", (Object)child.getPath());
                continue;
            }
            if (allSlotIndexes.contains(slotIndex)) {
                LOG.error("ignore slot dir {}, the same slot index has been assigned", (Object)filename);
                continue;
            }
            if (allSlotIdentifiers.contains(slotId)) {
                LOG.error("ignore slot dir {}, the same slot identifier has been assigned", (Object)filename);
                continue;
            }
            allSlotIndexes.add(slotIndex);
            allSlotIdentifiers.add(slotId);
            P11SlotId slotIdentifier = new P11SlotId(slotIndex, slotId);
            if (!moduleConf.isSlotIncluded(slotIdentifier)) {
                LOG.info("skipped slot {}", (Object)slotId);
                continue;
            }
            slotIds.add(slotIdentifier);
        }
        HashSet<P11Slot> slots = new HashSet<P11Slot>();
        for (P11SlotId slotId : slotIds) {
            List<char[]> pwd;
            try {
                pwd = moduleConf.getPasswordRetriever().getPassword(slotId);
            }
            catch (PasswordResolverException ex) {
                throw new TokenException("PasswordResolverException: " + ex.getMessage(), (Exception)((Object)ex));
            }
            File slotDir = new File(baseDir, slotId.getIndex() + "-" + slotId.getId());
            if (pwd == null) {
                throw new TokenException("no password is configured");
            }
            if (pwd.size() != 1) {
                throw new TokenException(pwd.size() + " passwords are configured, but 1 is permitted");
            }
            char[] firstPwd = pwd.get(0);
            slots.add(new EmulatorP11Slot(moduleConf.getName(), slotDir, slotId, moduleConf.isReadOnly(), new EmulatorKeyCryptor(firstPwd), moduleConf.getP11MechanismFilter(), moduleConf.getP11NewObjectConf(), moduleConf.getNumSessions(), moduleConf.getSecretKeyTypes(), moduleConf.getKeyPairTypes()));
        }
        this.setSlots(slots);
    }

    public static P11Module getInstance(P11ModuleConf moduleConf) throws TokenException {
        return new EmulatorP11Module((P11ModuleConf)Args.notNull((Object)moduleConf, (String)"moduleConf"));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void close() {
        LOG.info("close PKCS#11 module: {}", (Object)this.getName());
    }

    private void createExampleRepository(File dir) throws IOException {
        for (int i = 0; i < 2; ++i) {
            File slotDir = new File(dir, i + "-" + (800000 + i));
            IoUtil.mkdirs((File)slotDir);
            File slotInfoFile = new File(slotDir, "slot.info");
            IoUtil.save((File)slotInfoFile, (byte[])StringUtil.toUtf8Bytes((String)"namedCurveSupported=true\n"));
        }
    }
}

