/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.params.ExtraParams;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.pkcs11.emulator.EmulatorKeyCryptor;
import org.xipki.security.pkcs11.emulator.EmulatorP11Key;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

class EmulatorP11Slot
extends P11Slot {
    private static final Logger LOG;
    private static final long HANDLE_SUFFIX_SECRET_KEY = 1L;
    private static final long HANDLE_SUFFIX_PRIVATE_KEY = 2L;
    private static final long HANDLE_SUFFIX_PUBLIC_KEY = 3L;
    private static final String FILE_SLOTINFO = "slot.info";
    private static final String PROP_NAMED_CURVE_SUPPORTED = "namedCurveSupported";
    private static final String DIR_PRIV_KEY = "privkey";
    private static final String DIR_PUB_KEY = "pubkey";
    private static final String DIR_SEC_KEY = "seckey";
    private static final String INFO_FILE_SUFFIX = ".info";
    private static final String VALUE_FILE_SUFFIX = ".value";
    private static final String PROP_LABEL = "label";
    private static final String PROP_SHA1SUM = "sha1";
    private static final String PROP_ALGO = "algo";
    private static final String PROP_KEYTYPE = "keytype";
    private static final String PROP_ALGORITHM = "algorithm";
    private static final String PROP_KEYSPEC = "keyspec";
    private static final String PROP_RSA_MODUS = "modus";
    private static final String PROP_RSA_PUBLIC_EXPONENT = "publicExponent";
    private static final String PROP_DSA_PRIME = "prime";
    private static final String PROP_DSA_SUBPRIME = "subprime";
    private static final String PROP_DSA_BASE = "base";
    private static final String PROP_DSA_VALUE = "value";
    private static final String PROP_EC_PARAMS = "ecParams";
    private static final String PROP_EC_POINT = "ecPoint";
    private static final Map<Long, MechanismInfo> supportedMechs;
    private static final FilenameFilter INFO_FILENAME_FILTER;
    private final boolean namedCurveSupported;
    private final File privKeyDir;
    private final File pubKeyDir;
    private final File secKeyDir;
    private final EmulatorKeyCryptor keyCryptor;
    private final SecureRandom random = new SecureRandom();
    private final int maxSessions;

    EmulatorP11Slot(String moduleName, File slotDir, P11SlotId slotId, boolean readOnly, EmulatorKeyCryptor keyCryptor, P11ModuleConf.P11MechanismFilter mechanismFilter, P11ModuleConf.P11NewObjectConf newObjectConf, Integer numSessions, List<Long> secretKeyTypes, List<Long> keypairTypes) throws TokenException {
        super(moduleName, slotId, readOnly, secretKeyTypes, keypairTypes, newObjectConf);
        this.keyCryptor = (EmulatorKeyCryptor)Args.notNull((Object)keyCryptor, (String)"keyCryptor");
        this.maxSessions = numSessions == null ? 20 : Args.positive((int)numSessions, (String)"numSessions");
        this.privKeyDir = new File((File)Args.notNull((Object)slotDir, (String)"slotDir"), DIR_PRIV_KEY);
        this.pubKeyDir = new File(slotDir, DIR_PUB_KEY);
        this.secKeyDir = new File(slotDir, DIR_SEC_KEY);
        try {
            IoUtil.mkdirs((File)this.privKeyDir);
            IoUtil.mkdirs((File)this.pubKeyDir);
            IoUtil.mkdirs((File)this.secKeyDir);
        }
        catch (IOException ex) {
            throw new TokenException((Exception)ex);
        }
        File slotInfoFile = new File(slotDir, FILE_SLOTINFO);
        if (slotInfoFile.exists()) {
            Properties props = this.loadProperties(slotInfoFile);
            this.namedCurveSupported = Boolean.parseBoolean(props.getProperty(PROP_NAMED_CURVE_SUPPORTED, "true"));
        } else {
            this.namedCurveSupported = true;
        }
        this.initMechanisms(supportedMechs, mechanismFilter);
    }

    private List<File> getFilesForLabel(File dir, String label) throws TokenException {
        LinkedList<File> ret = new LinkedList<File>();
        File[] infoFiles = dir.listFiles(INFO_FILENAME_FILTER);
        if (infoFiles != null) {
            for (File infoFile : infoFiles) {
                Properties props;
                if (!infoFile.isFile() || !label.equals((props = this.loadProperties(infoFile)).getProperty(PROP_LABEL))) continue;
                ret.add(infoFile);
            }
        }
        return ret;
    }

    PublicKey readPublicKey(byte[] keyId) throws TokenException {
        File pubKeyFile = EmulatorP11Slot.getInfoFile(this.pubKeyDir, EmulatorP11Slot.hex(keyId));
        Properties props = this.loadProperties(pubKeyFile);
        String algorithm = props.getProperty(PROP_ALGORITHM);
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(algorithm)) {
            BigInteger exp = new BigInteger(props.getProperty(PROP_RSA_PUBLIC_EXPONENT), 16);
            BigInteger mod = new BigInteger(props.getProperty(PROP_RSA_MODUS), 16);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
            try {
                return KeyUtil.generateRSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        if (X9ObjectIdentifiers.id_dsa.getId().equals(algorithm)) {
            BigInteger prime = new BigInteger(props.getProperty(PROP_DSA_PRIME), 16);
            BigInteger subPrime = new BigInteger(props.getProperty(PROP_DSA_SUBPRIME), 16);
            BigInteger base = new BigInteger(props.getProperty(PROP_DSA_BASE), 16);
            BigInteger value = new BigInteger(props.getProperty(PROP_DSA_VALUE), 16);
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(value, prime, subPrime, base);
            try {
                return KeyUtil.generateDSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(algorithm)) {
            byte[] ecParams = EmulatorP11Slot.decodeHex(props.getProperty(PROP_EC_PARAMS));
            byte[] asn1EncodedPoint = EmulatorP11Slot.decodeHex(props.getProperty(PROP_EC_POINT));
            byte[] ecPoint = DEROctetString.getInstance((Object)asn1EncodedPoint).getOctets();
            try {
                return KeyUtil.createECPublicKey(ecParams, ecPoint);
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        if (EdECConstants.id_X25519.getId().equals(algorithm) || EdECConstants.id_ED25519.getId().equals(algorithm) || EdECConstants.id_X448.getId().equals(algorithm) || EdECConstants.id_ED448.getId().equals(algorithm)) {
            byte[] encodedPoint = EmulatorP11Slot.decodeHex(props.getProperty(PROP_EC_POINT));
            SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier(algorithm)), encodedPoint);
            try {
                return KeyUtil.generatePublicKey(pkInfo);
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException("error  key algorithm " + algorithm);
            }
        }
        throw new TokenException("unknown key algorithm " + algorithm);
    }

    private Properties loadProperties(File file) throws TokenException {
        Properties properties;
        block8: {
            InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                Properties props = new Properties();
                props.load(stream);
                properties = props;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new TokenException("could not load properties from the file " + file.getPath(), (Exception)ex);
                }
            }
            stream.close();
        }
        return properties;
    }

    private static byte[] getKeyIdFromInfoFilename(String fileName) {
        return EmulatorP11Slot.decodeHex(fileName.substring(0, fileName.length() - INFO_FILE_SUFFIX.length()));
    }

    private static File getInfoFile(File dir, String hexId) {
        return new File(dir, hexId + INFO_FILE_SUFFIX);
    }

    private static File getValueFile(File dir, String hexId) {
        return new File(dir, hexId + VALUE_FILE_SUFFIX);
    }

    @Override
    public void close() {
        LOG.info("close slot " + this.slotId);
    }

    private static boolean deletePkcs11Entry(File dir, byte[] objectId) {
        String hexId = EmulatorP11Slot.hex(objectId);
        File infoFile = EmulatorP11Slot.getInfoFile(dir, hexId);
        boolean b1 = !infoFile.exists() || infoFile.delete();
        File valueFile = EmulatorP11Slot.getValueFile(dir, hexId);
        boolean b2 = !valueFile.exists() || valueFile.delete();
        return b1 || b2;
    }

    private int deletePkcs11Entry(File dir, byte[] id, String label) throws TokenException {
        if (StringUtil.isBlank((String)label)) {
            return EmulatorP11Slot.deletePkcs11Entry(dir, id) ? 1 : 0;
        }
        if (id != null && id.length > 0) {
            String hexId = EmulatorP11Slot.hex(id);
            File infoFile = EmulatorP11Slot.getInfoFile(dir, hexId);
            if (!infoFile.exists()) {
                return 0;
            }
            Properties props = this.loadProperties(infoFile);
            if (!label.equals(props.get(PROP_LABEL))) {
                return 0;
            }
            return EmulatorP11Slot.deletePkcs11Entry(dir, id) ? 1 : 0;
        }
        File[] infoFiles = dir.listFiles(INFO_FILENAME_FILTER);
        if (infoFiles == null || infoFiles.length == 0) {
            return 0;
        }
        LinkedList<byte[]> ids = new LinkedList<byte[]>();
        for (File infoFile : infoFiles) {
            Properties props = this.loadProperties(infoFile);
            if (!label.equals(props.getProperty(PROP_LABEL))) continue;
            ids.add(EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName()));
        }
        if (ids.isEmpty()) {
            return 0;
        }
        for (byte[] m : ids) {
            EmulatorP11Slot.deletePkcs11Entry(dir, m);
        }
        return ids.size();
    }

    private PKCS11KeyId savePkcs11SecretKey(byte[] id, String label, long keyType, SecretKey secretKey) throws TokenException {
        byte[] encryptedValue = this.keyCryptor.encrypt(secretKey);
        return this.savePkcs11Entry(4L, id, label, keyType, secretKey.getAlgorithm(), encryptedValue, Integer.toString(secretKey.getEncoded().length * 8));
    }

    private PKCS11KeyId savePkcs11PrivateKey(byte[] id, String label, long keyType, PrivateKey privateKey, String keyspec) throws TokenException {
        byte[] encryptedPrivKeyInfo = this.keyCryptor.encrypt(privateKey);
        return this.savePkcs11Entry(3L, id, label, keyType, privateKey.getAlgorithm(), encryptedPrivKeyInfo, keyspec);
    }

    private long savePkcs11PublicKey(byte[] id, String label, long keyType, PublicKey publicKey, String keyspec) throws TokenException {
        String hexId = EmulatorP11Slot.hex(id);
        StringBuilder sb = new StringBuilder(100).append(EmulatorP11Slot.propertyToString(PROP_LABEL, label)).append(EmulatorP11Slot.propertyToString(PROP_KEYTYPE, Long.toString(keyType)));
        if (keyspec != null) {
            sb.append(EmulatorP11Slot.propertyToString(PROP_KEYSPEC, keyspec));
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)publicKey;
            sb.append(EmulatorP11Slot.propertyToString(PROP_ALGORITHM, PKCSObjectIdentifiers.rsaEncryption.getId())).append(EmulatorP11Slot.propertyToString(PROP_RSA_MODUS, rsaKey.getModulus())).append(EmulatorP11Slot.propertyToString(PROP_RSA_PUBLIC_EXPONENT, rsaKey.getPublicExponent()));
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaKey = (DSAPublicKey)publicKey;
            sb.append(EmulatorP11Slot.propertyToString(PROP_ALGORITHM, X9ObjectIdentifiers.id_dsa.getId())).append(EmulatorP11Slot.propertyToString(PROP_DSA_PRIME, dsaKey.getParams().getP())).append(EmulatorP11Slot.propertyToString(PROP_DSA_SUBPRIME, dsaKey.getParams().getQ())).append(EmulatorP11Slot.propertyToString(PROP_DSA_BASE, dsaKey.getParams().getG())).append(EmulatorP11Slot.propertyToString(PROP_DSA_VALUE, dsaKey.getY()));
        } else if (publicKey instanceof ECPublicKey) {
            byte[] encodedEcPoint;
            byte[] encodedParams;
            sb.append(PROP_ALGORITHM).append('=').append(X9ObjectIdentifiers.id_ecPublicKey.getId()).append('\n');
            ECPublicKey ecKey = (ECPublicKey)publicKey;
            ECParameterSpec paramSpec = ecKey.getParams();
            org.bouncycastle.jce.spec.ECParameterSpec bcParamSpec = EC5Util.convertSpec((ECParameterSpec)paramSpec);
            ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid((org.bouncycastle.jce.spec.ECParameterSpec)bcParamSpec);
            if (curveOid == null) {
                throw new TokenException("EC public key is not of namedCurve");
            }
            try {
                encodedParams = this.namedCurveSupported ? curveOid.getEncoded() : ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveOid).getEncoded();
            }
            catch (IOException | NullPointerException ex) {
                throw new TokenException(ex.getMessage(), ex);
            }
            sb.append(EmulatorP11Slot.propertyToString(PROP_EC_PARAMS, encodedParams));
            ECPoint pointW = ecKey.getW();
            int keysize = (paramSpec.getCurve().getField().getFieldSize() + 7) / 8;
            byte[] ecPoint = new byte[1 + keysize * 2];
            ecPoint[0] = 4;
            EmulatorP11Slot.bigIntToBytes("Wx", pointW.getAffineX(), ecPoint, 1, keysize);
            EmulatorP11Slot.bigIntToBytes("Wy", pointW.getAffineY(), ecPoint, 1 + keysize, keysize);
            try {
                encodedEcPoint = new DEROctetString(ecPoint).getEncoded();
            }
            catch (IOException ex) {
                throw new TokenException("could not ASN.1 encode the ECPoint");
            }
            sb.append(EmulatorP11Slot.propertyToString(PROP_EC_POINT, encodedEcPoint));
        } else if (publicKey instanceof EdDSAKey || publicKey instanceof XDHKey) {
            byte[] encodedParams;
            String algorithm = publicKey.getAlgorithm();
            ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid(algorithm);
            if (curveOid == null) {
                throw new TokenException("Invalid EdDSA key algorithm " + algorithm);
            }
            sb.append(EmulatorP11Slot.propertyToString(PROP_ALGORITHM, curveOid.getId()));
            try {
                encodedParams = curveOid.getEncoded();
            }
            catch (IOException | NullPointerException ex) {
                throw new TokenException(ex.getMessage(), ex);
            }
            sb.append(EmulatorP11Slot.propertyToString(PROP_EC_PARAMS, encodedParams));
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            byte[] encodedEcPoint = spki.getPublicKeyData().getOctets();
            sb.append(EmulatorP11Slot.propertyToString(PROP_EC_POINT, encodedEcPoint));
        } else {
            throw new IllegalArgumentException("unsupported public key " + publicKey.getClass().getName());
        }
        try {
            IoUtil.save((File)EmulatorP11Slot.getInfoFile(this.pubKeyDir, hexId), (byte[])StringUtil.toUtf8Bytes((String)sb.toString()));
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        return EmulatorP11Slot.deriveKeyHandle(2L, id);
    }

    private static String propertyToString(String propKey, byte[] propValue) {
        return propKey + "=" + Hex.encode((byte[])propValue) + "\n";
    }

    private static String propertyToString(String propKey, String propValue) {
        return propKey + "=" + propValue + "\n";
    }

    private static String propertyToString(String propKey, BigInteger propValue) {
        return propKey + "=" + EmulatorP11Slot.hex(propValue.toByteArray()) + "\n";
    }

    private static void bigIntToBytes(String numName, BigInteger num, byte[] dest, int destPos, int length) throws TokenException {
        if (num.signum() != 1) {
            throw new TokenException(numName + " is not positive");
        }
        byte[] bytes = num.toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, dest, destPos, length);
        } else if (bytes.length < length) {
            System.arraycopy(bytes, 0, dest, destPos + length - bytes.length, bytes.length);
        } else if (bytes.length == length + 1 && bytes[0] == 0) {
            System.arraycopy(bytes, 1, dest, destPos, length);
        } else {
            throw new TokenException("num is too large");
        }
    }

    private PKCS11KeyId savePkcs11Entry(long objectClass, byte[] id, String label, long keyType, String algo, byte[] value, String keyspec) throws TokenException {
        Args.notNull((Object)value, (String)PROP_DSA_VALUE);
        String hexId = EmulatorP11Slot.hex((byte[])Args.notNull((Object)id, (String)"id"));
        StringBuilder str = new StringBuilder().append(EmulatorP11Slot.propertyToString(PROP_LABEL, Args.notBlank((String)label, (String)PROP_LABEL))).append(EmulatorP11Slot.propertyToString(PROP_KEYTYPE, Long.toString(keyType)));
        if (algo != null) {
            str.append(EmulatorP11Slot.propertyToString(PROP_ALGO, algo));
        }
        if (keyspec != null) {
            str.append(EmulatorP11Slot.propertyToString(PROP_KEYSPEC, keyspec));
        }
        str.append(EmulatorP11Slot.propertyToString(PROP_SHA1SUM, HashAlgo.SHA1.hexHash(new byte[][]{value})));
        File dir = objectClass == 4L ? this.secKeyDir : this.privKeyDir;
        try {
            IoUtil.save((File)EmulatorP11Slot.getInfoFile(dir, hexId), (byte[])StringUtil.toUtf8Bytes((String)str.toString()));
            IoUtil.save((File)EmulatorP11Slot.getValueFile(dir, hexId), (byte[])value);
        }
        catch (IOException ex) {
            throw new TokenException("could not save " + PKCS11Constants.ckoCodeToName((long)objectClass).substring(4));
        }
        return new PKCS11KeyId(EmulatorP11Slot.deriveKeyHandle(objectClass, id), objectClass, keyType, id, label);
    }

    @Override
    public int destroyAllObjects() {
        File[] dirs = new File[]{this.privKeyDir, this.secKeyDir, this.pubKeyDir};
        int pubKeyFileNum = 0;
        int secretOrPrivKeyFilenum = 0;
        for (File dir : dirs) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (!file.isFile()) continue;
                try {
                    IoUtil.deleteFile0((File)file);
                    if (file == this.pubKeyDir) {
                        ++pubKeyFileNum;
                    } else {
                        ++secretOrPrivKeyFilenum;
                    }
                    LOG.info("Deleted file " + file.getPath());
                }
                catch (IOException ex) {
                    LOG.warn("IO error deleting file " + file.getPath());
                }
            }
        }
        return pubKeyFileNum + secretOrPrivKeyFilenum / 2;
    }

    @Override
    public long[] destroyObjectsByHandle(long[] handles) {
        ArrayList<Long> failedHandles = new ArrayList<Long>(handles.length);
        HashMap<Long, List> keyHandles = new HashMap<Long, List>();
        for (long handle : handles) {
            Long objClass = EmulatorP11Slot.getObjectClassForHandle(handle);
            if (objClass == null) {
                failedHandles.add(handle);
                continue;
            }
            List list = keyHandles.computeIfAbsent(objClass, s -> new ArrayList());
            list.add(handle);
        }
        Object object = keyHandles.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            long objClass = (Long)entry.getKey();
            File dir = this.getDirForObjectClass(objClass);
            List thisHandles = (List)entry.getValue();
            File[] infoFiles = dir.listFiles(INFO_FILENAME_FILTER);
            if (infoFiles == null) continue;
            for (File infoFile : infoFiles) {
                if (!infoFile.isFile()) continue;
                try {
                    byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName());
                    long thisHandle = EmulatorP11Slot.deriveKeyHandle(objClass, id);
                    if (!thisHandles.contains(thisHandle)) continue;
                    IoUtil.deleteFile0((File)infoFile);
                    String hexId = EmulatorP11Slot.hex(id);
                    IoUtil.deleteFile0((File)EmulatorP11Slot.getValueFile(dir, hexId));
                    thisHandles.remove(thisHandle);
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("destroyed {} with id {} and handle {}", new Object[]{PKCS11Constants.ckoCodeToName((long)objClass), hexId, thisHandle});
                }
                catch (Exception ex) {
                    LOG.warn("error deleting key file");
                }
            }
        }
        for (Map.Entry entry : keyHandles.entrySet()) {
            failedHandles.addAll((Collection)entry.getValue());
        }
        if (failedHandles.isEmpty()) {
            return new long[0];
        }
        long[] ret = new long[failedHandles.size()];
        boolean bl = false;
        for (Long l : failedHandles) {
            ret[++var5_9] = l;
        }
        return ret;
    }

    @Override
    public int destroyObjectsByIdLabel(byte[] id, String label) throws TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            throw new IllegalArgumentException("at least one of id and label may not be null");
        }
        return this.deletePkcs11Entry(this.privKeyDir, id, label) + this.deletePkcs11Entry(this.pubKeyDir, id, label) + this.deletePkcs11Entry(this.secKeyDir, id, label);
    }

    @Override
    public byte[] digestSecretKey(long mechanism, long objectHandle) throws TokenException {
        byte[] encodedValue;
        HashAlgo hashAlgo = EmulatorP11Key.mechHashMap.get(mechanism);
        if (hashAlgo == null) {
            throw new PKCS11Exception(112L, "unknown mechanism " + PKCS11Constants.ckmCodeToName((long)mechanism));
        }
        File[] infoFiles = this.secKeyDir.listFiles(INFO_FILENAME_FILTER);
        byte[] keyId = null;
        if (infoFiles != null) {
            for (File infoFile : infoFiles) {
                byte[] id;
                long thisHandle;
                if (!infoFile.isFile() || (thisHandle = EmulatorP11Slot.deriveKeyHandle(4L, id = EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName()))) != objectHandle) continue;
                keyId = id;
                break;
            }
        }
        if (keyId == null) {
            throw new PKCS11Exception(96L, "unknown handle " + objectHandle);
        }
        try {
            encodedValue = IoUtil.read((File)EmulatorP11Slot.getValueFile(this.secKeyDir, EmulatorP11Slot.hex(keyId)));
        }
        catch (IOException e) {
            throw new PKCS11Exception(96L, "error reading secret key of handle " + objectHandle);
        }
        byte[] keyValue = this.keyCryptor.decrypt(encodedValue);
        return hashAlgo.hash(new byte[][]{keyValue});
    }

    @Override
    public P11Key getKey(byte[] keyId, String keyLabel) throws TokenException {
        PKCS11KeyId p11KeyId = this.getKeyId(keyId, keyLabel);
        return p11KeyId == null ? null : this.getKey(p11KeyId);
    }

    @Override
    public P11Key getKey(PKCS11KeyId keyId) throws TokenException {
        String hexId = EmulatorP11Slot.hex(keyId.getId());
        long keyType = keyId.getKeyType();
        try {
            EmulatorP11Key ret;
            if (keyId.getObjectCLass() == 4L) {
                File infoFile = EmulatorP11Slot.getInfoFile(this.secKeyDir, hexId);
                if (!infoFile.exists()) {
                    return null;
                }
                Properties props = this.loadProperties(infoFile);
                String keyAlgo = props.getProperty(PROP_ALGO);
                byte[] encodedValue = IoUtil.read((File)EmulatorP11Slot.getValueFile(this.secKeyDir, hexId));
                byte[] keyValue = this.keyCryptor.decrypt(encodedValue);
                SecretKeySpec key = new SecretKeySpec(keyValue, keyAlgo);
                ret = new EmulatorP11Key(this, keyId, key, this.maxSessions, this.random);
            } else {
                byte[] encodedValue = IoUtil.read((File)EmulatorP11Slot.getValueFile(this.privKeyDir, hexId));
                PrivateKey privateKey = this.keyCryptor.decryptPrivateKey(encodedValue);
                Properties props = this.loadProperties(EmulatorP11Slot.getInfoFile(this.pubKeyDir, hexId));
                if (keyType == 0L) {
                    BigInteger mod = new BigInteger(props.getProperty(PROP_RSA_MODUS), 16);
                    BigInteger e = new BigInteger(props.getProperty(PROP_RSA_PUBLIC_EXPONENT), 16);
                    ret = new EmulatorP11Key(this, keyId, privateKey, this.maxSessions, this.random);
                    ret.setRsaMParameters(mod, e);
                } else if (keyType == 1L) {
                    BigInteger p = new BigInteger(props.getProperty(PROP_DSA_PRIME), 16);
                    BigInteger q = new BigInteger(props.getProperty(PROP_DSA_SUBPRIME), 16);
                    BigInteger g = new BigInteger(props.getProperty(PROP_DSA_BASE), 16);
                    ret = new EmulatorP11Key(this, keyId, privateKey, this.maxSessions, this.random);
                    ret.setDsaParameters(p, q, g);
                } else if (keyType == 3L || keyType == 0xFFFFF001L || keyType == 64L || keyType == 65L) {
                    byte[] ecParams = EmulatorP11Slot.decodeHex(props.getProperty(PROP_EC_PARAMS));
                    ASN1ObjectIdentifier curveId = ASN1ObjectIdentifier.getInstance((Object)ecParams);
                    ret = new EmulatorP11Key(this, keyId, privateKey, this.maxSessions, this.random);
                    ret.setEcParams(curveId);
                } else {
                    throw new TokenException("unknown key type " + PKCS11Constants.ckkCodeToName((long)keyType));
                }
            }
            ret.sign(true);
            return ret;
        }
        catch (Exception e) {
            throw new TokenException(e);
        }
    }

    @Override
    public PublicKey getPublicKey(long objectHandle) throws TokenException {
        File[] infoFiles = this.pubKeyDir.listFiles(INFO_FILENAME_FILTER);
        byte[] keyId = null;
        if (infoFiles != null) {
            for (File infoFile : infoFiles) {
                byte[] id;
                long thisHandle;
                if (!infoFile.isFile() || (thisHandle = EmulatorP11Slot.deriveKeyHandle(2L, id = EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName()))) != objectHandle) continue;
                keyId = id;
                break;
            }
        }
        if (keyId == null) {
            throw new PKCS11Exception(96L, "unknown handle " + objectHandle);
        }
        return this.readPublicKey(keyId);
    }

    @Override
    public boolean objectExistsByIdLabel(byte[] id, String label) throws TokenException {
        if (id == null) {
            List<File> files = this.getFilesForLabel(this.privKeyDir, label);
            if (files.isEmpty()) {
                files = this.getFilesForLabel(this.secKeyDir, label);
            }
            if (files.isEmpty()) {
                files = this.getFilesForLabel(this.pubKeyDir, label);
            }
            return !files.isEmpty();
        }
        String hexId = EmulatorP11Slot.hex(id);
        File file = EmulatorP11Slot.getInfoFile(this.privKeyDir, hexId);
        if (!file.exists()) {
            file = EmulatorP11Slot.getInfoFile(this.secKeyDir, hexId);
        }
        if (!file.exists()) {
            file = EmulatorP11Slot.getInfoFile(this.pubKeyDir, hexId);
        }
        if (!file.exists()) {
            return false;
        }
        if (label != null) {
            Properties props = this.loadProperties(file);
            String label2 = props.getProperty(PROP_LABEL);
            return label.equals(label2);
        }
        return true;
    }

    @Override
    public PKCS11KeyId getKeyId(byte[] keyId, String keyLabel) throws TokenException {
        if ((keyId == null || keyId.length == 0) && StringUtil.isBlank((String)keyLabel)) {
            return null;
        }
        if (keyId == null) {
            long objClass = 3L;
            List<File> infoFiles = this.getFilesForLabel(this.privKeyDir, keyLabel);
            if (infoFiles.isEmpty()) {
                objClass = 4L;
                infoFiles = this.getFilesForLabel(this.secKeyDir, keyLabel);
            }
            if (infoFiles.isEmpty()) {
                objClass = 2L;
                infoFiles = this.getFilesForLabel(this.pubKeyDir, keyLabel);
            }
            if (infoFiles.isEmpty()) {
                return null;
            }
            if (infoFiles.size() > 1) {
                throw new TokenException("found more than 1 " + PKCS11Constants.ckoCodeToName((long)objClass) + " with label=" + keyLabel);
            }
            File infoFile = infoFiles.get(0);
            keyId = EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName());
            Properties props = this.loadProperties(infoFile);
            long keyHandle = EmulatorP11Slot.deriveKeyHandle(objClass, keyId);
            long keyType = Long.parseLong(props.getProperty(PROP_KEYTYPE));
            String label = props.getProperty(PROP_LABEL);
            PKCS11KeyId keyObjectId = new PKCS11KeyId(keyHandle, objClass, keyType, keyId, label);
            if (objClass == 3L) {
                keyObjectId.setPublicKeyHandle(Long.valueOf(EmulatorP11Slot.deriveKeyHandle(2L, keyId)));
            }
            return keyObjectId;
        }
        String hexId = EmulatorP11Slot.hex(keyId);
        long objClass = 3L;
        File keyInfoFile = EmulatorP11Slot.getInfoFile(this.privKeyDir, hexId);
        if (!keyInfoFile.exists()) {
            objClass = 4L;
            keyInfoFile = EmulatorP11Slot.getInfoFile(this.secKeyDir, hexId);
        }
        if (!keyInfoFile.exists()) {
            objClass = 2L;
            keyInfoFile = EmulatorP11Slot.getInfoFile(this.pubKeyDir, hexId);
        }
        if (!keyInfoFile.exists()) {
            return null;
        }
        Properties props = this.loadProperties(keyInfoFile);
        String label = props.getProperty(PROP_LABEL);
        if (keyLabel != null && !keyLabel.equals(label)) {
            return null;
        }
        keyLabel = label;
        long keyHandle = EmulatorP11Slot.deriveKeyHandle(objClass, keyId);
        long keyType = Long.parseLong(props.getProperty(PROP_KEYTYPE));
        PKCS11KeyId objectId = new PKCS11KeyId(keyHandle, objClass, keyType, keyId, keyLabel);
        if (objClass == 2L) {
            objectId.setPublicKeyHandle(Long.valueOf(EmulatorP11Slot.deriveKeyHandle(2L, keyId)));
        }
        return objectId;
    }

    private PKCS11KeyId getKeyIdByHandle(long handle) throws TokenException {
        Long objClass = EmulatorP11Slot.getObjectClassForHandle(handle);
        if (objClass == null) {
            return null;
        }
        File dir = this.getDirForObjectClass(objClass);
        File[] infoFiles = dir.listFiles(INFO_FILENAME_FILTER);
        if (infoFiles != null) {
            for (File infoFile : infoFiles) {
                if (!infoFile.isFile()) continue;
                byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName());
                long thisHandle = EmulatorP11Slot.deriveKeyHandle(objClass, id);
                if (thisHandle != handle) continue;
                Properties props = this.loadProperties(infoFile);
                long keyType = Long.parseLong(props.getProperty(PROP_KEYTYPE));
                String label = props.getProperty(PROP_LABEL);
                PKCS11KeyId objectId = new PKCS11KeyId(handle, objClass.longValue(), keyType, id, label);
                if (3L == objClass && EmulatorP11Slot.getInfoFile(this.pubKeyDir, EmulatorP11Slot.hex(id)).exists()) {
                    objectId.setPublicKeyHandle(Long.valueOf(EmulatorP11Slot.deriveKeyHandle(2L, id)));
                }
                return objectId;
            }
        }
        throw new PKCS11Exception(96L, "unknown handle " + handle);
    }

    @Override
    public byte[] sign(long mechanism, P11Params params, ExtraParams extraParams, long keyHandle, byte[] content) throws TokenException {
        PKCS11KeyId keyId = this.getKeyIdByHandle(keyHandle);
        return this.getKey(keyId).sign(mechanism, params, content);
    }

    @Override
    protected PKCS11KeyId doGenerateSecretKey(long keyType, Integer keysize, P11Slot.P11NewKeyControl control) throws TokenException {
        long mech;
        if (keysize != null && keysize % 8 != 0) {
            throw new IllegalArgumentException("keysize is not multiple of 8: " + keysize);
        }
        if (31L == keyType) {
            mech = 4224L;
        } else if (21L == keyType) {
            mech = 305L;
            keysize = 192;
        } else if (16L == keyType) {
            mech = 848L;
        } else if (40L == keyType || 46L == keyType || 43L == keyType || 44L == keyType || 45L == keyType || 54L == keyType || 55L == keyType || 56L == keyType || 57L == keyType) {
            mech = 848L;
        } else {
            throw new IllegalArgumentException("unsupported key type " + PKCS11Constants.codeToName((PKCS11Constants.Category)PKCS11Constants.Category.CKK, (long)keyType));
        }
        this.assertMechanismSupported(mech, 65536L);
        byte[] keyBytes = new byte[(Integer)Args.notNull((Object)keysize, (String)"keysize") / 8];
        this.random.nextBytes(keyBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, EmulatorP11Slot.getSecretKeyAlgorithm(keyType));
        return this.saveSecretP11Entity(keyType, key, control);
    }

    @Override
    protected PKCS11KeyId doImportSecretKey(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl control) throws TokenException {
        SecretKeySpec key = new SecretKeySpec(keyValue, EmulatorP11Slot.getSecretKeyAlgorithm(keyType));
        return this.saveSecretP11Entity(keyType, key, control);
    }

    private static String getSecretKeyAlgorithm(long keyType) {
        String algorithm;
        String string = 16L == keyType ? "generic" : (31L == keyType ? "AES" : (40L == keyType ? "HMACSHA1" : (46L == keyType ? "HMACSHA224" : (43L == keyType ? "HMACSHA256" : (44L == keyType ? "HMACSHA384" : (45L == keyType ? "HMACSHA512" : (54L == keyType ? "HMACSHA3-224" : (55L == keyType ? "HMACSHA3-256" : (56L == keyType ? "HMACSHA3-384" : (algorithm = 57L == keyType ? "HMACSHA3-512" : null))))))))));
        if (algorithm == null) {
            throw new IllegalArgumentException("unsupported keyType " + keyType);
        }
        return algorithm;
    }

    @Override
    protected PKCS11KeyId doGenerateRSAKeypair(int keysize, BigInteger publicExponent, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPair keypair;
        try {
            keypair = KeyUtil.generateRSAKeypair(keysize, publicExponent, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        return this.saveKeyPairP11Entity(0L, keypair, control, Integer.toString(keysize));
    }

    @Override
    protected PrivateKeyInfo doGenerateRSAKeypairOtf(int keysize, BigInteger publicExponent) throws TokenException {
        try {
            KeyPair kp = KeyUtil.generateRSAKeypair(keysize, publicExponent, this.random);
            return KeyUtil.toPrivateKeyInfo((RSAPrivateCrtKey)kp.getPrivate());
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), ex);
        }
    }

    @Override
    protected PKCS11KeyId doGenerateDSAKeypair(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPair keypair;
        DSAParameters dsaParams = new DSAParameters(p, q, g);
        try {
            keypair = KeyUtil.generateDSAKeypair(dsaParams, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        return this.saveKeyPairP11Entity(1L, keypair, control, Integer.toString(p.bitLength()));
    }

    @Override
    protected PrivateKeyInfo generateDSAKeypairOtf0(BigInteger p, BigInteger q, BigInteger g) throws TokenException {
        DSAParameters spec = new DSAParameters(p, q, g);
        try {
            KeyPair kp = KeyUtil.generateDSAKeypair(spec, this.random);
            DSAParameter parameter = new DSAParameter(spec.getP(), spec.getQ(), spec.getG());
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)parameter);
            byte[] publicKey = new ASN1Integer(((DSAPublicKey)kp.getPublic()).getY()).getEncoded();
            DSAPrivateKey priv = (DSAPrivateKey)kp.getPrivate();
            return new PrivateKeyInfo(algId, (ASN1Encodable)new ASN1Integer(priv.getX()), null, publicKey);
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), ex);
        }
    }

    @Override
    protected PKCS11KeyId doGenerateSM2Keypair(P11Slot.P11NewKeyControl control) throws TokenException {
        return this.doGenerateECKeypair(GMObjectIdentifiers.sm2p256v1, control);
    }

    @Override
    protected PrivateKeyInfo doGenerateSM2KeypairOtf() throws TokenException {
        return this.doGenerateECKeypairOtf(GMObjectIdentifiers.sm2p256v1);
    }

    @Override
    protected PKCS11KeyId doGenerateECEdwardsKeypair(ASN1ObjectIdentifier curveOid, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPair keypair;
        try {
            if (!EdECConstants.isEdwardsCurve(curveOid)) {
                throw new TokenException("unknown curve  " + curveOid.getId());
            }
            keypair = KeyUtil.generateEdECKeypair(curveOid, this.random);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        return this.saveKeyPairP11Entity(64L, keypair, control, EdECConstants.getName(curveOid));
    }

    @Override
    protected PrivateKeyInfo doGenerateECEdwardsKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        try {
            KeyPair kp = KeyUtil.generateEdECKeypair(curveId, this.random);
            return PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
    }

    @Override
    protected PKCS11KeyId doGenerateECMontgomeryKeypair(ASN1ObjectIdentifier curveOid, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPair keypair;
        try {
            if (!EdECConstants.isMontgomeryCurve(curveOid)) {
                throw new TokenException("unknown curve  " + curveOid.getId());
            }
            keypair = KeyUtil.generateEdECKeypair(curveOid, this.random);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        return this.saveKeyPairP11Entity(65L, keypair, control, EdECConstants.getName(curveOid));
    }

    @Override
    protected PrivateKeyInfo doGenerateECMontgomeryKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        try {
            KeyPair kp = KeyUtil.generateEdECKeypair(curveId, this.random);
            return PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
    }

    @Override
    protected PKCS11KeyId doGenerateECKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPair keypair;
        try {
            keypair = KeyUtil.generateECKeypair(curveId, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        String curveName = AlgorithmUtil.getCurveName(curveId);
        if (curveName == null) {
            curveName = curveId.getId();
        }
        long keyType = 3L;
        if (GMObjectIdentifiers.sm2p256v1.equals((ASN1Primitive)curveId)) {
            keyType = 0xFFFFF001L;
        }
        return this.saveKeyPairP11Entity(keyType, keypair, control, curveName);
    }

    @Override
    protected PrivateKeyInfo doGenerateECKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        try {
            AlgorithmIdentifier keyAlgId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveId);
            KeyPair kp = KeyUtil.generateECKeypair(curveId, this.random);
            ECPublicKey pub = (ECPublicKey)kp.getPublic();
            int fieldBitSize = pub.getParams().getCurve().getField().getFieldSize();
            byte[] publicKey = KeyUtil.getUncompressedEncodedECPoint(pub.getW(), fieldBitSize);
            int orderBitLength = pub.getParams().getOrder().bitLength();
            java.security.interfaces.ECPrivateKey priv = (java.security.interfaces.ECPrivateKey)kp.getPrivate();
            return new PrivateKeyInfo(keyAlgId, (ASN1Encodable)new ECPrivateKey(orderBitLength, priv.getS(), (ASN1BitString)new DERBitString(publicKey), null));
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new TokenException(ex.getMessage(), ex);
        }
    }

    private PKCS11KeyId saveKeyPairP11Entity(long keyType, KeyPair keypair, P11Slot.P11NewObjectControl control, String keySpec) throws TokenException {
        byte[] id = control.getId();
        if (id == null) {
            id = this.generateId();
        }
        String label = control.getLabel();
        long publicKeyHandle = this.savePkcs11PublicKey(id, label, keyType, keypair.getPublic(), keySpec);
        PKCS11KeyId privateKeyId = this.savePkcs11PrivateKey(id, label, keyType, keypair.getPrivate(), keySpec);
        privateKeyId.setPublicKeyHandle(Long.valueOf(publicKeyHandle));
        return privateKeyId;
    }

    private PKCS11KeyId saveSecretP11Entity(long keyType, SecretKey key, P11Slot.P11NewObjectControl control) throws TokenException {
        byte[] id = control.getId();
        if (id == null) {
            id = this.generateId();
        }
        String label = control.getLabel();
        return this.savePkcs11SecretKey(id, label, keyType, key);
    }

    @Override
    public void showDetails(OutputStream stream, Long objectHandle, boolean verbose) throws IOException {
        stream.write("\nToken information: \n  Manufacturer ID: Emulator".getBytes(StandardCharsets.UTF_8));
        stream.write("\n\nSlot information:\n  Manufacturer ID: Emulator".getBytes(StandardCharsets.UTF_8));
        stream.write(10);
        if (verbose) {
            this.printSupportedMechanism(stream);
        }
        if (objectHandle != null) {
            stream.write(("\nDetails of object with handle " + objectHandle + "\n").getBytes(StandardCharsets.UTF_8));
            int handleHashCode = (int)(objectHandle >> 2);
            Long keyClass = EmulatorP11Slot.getObjectClassForHandle(objectHandle);
            if (keyClass == null) {
                stream.write("  error: CKR_OBJECT_HANDLE_INVALID\n".getBytes(StandardCharsets.UTF_8));
                return;
            }
            File infoFile = EmulatorP11Slot.getInfoFileForHashCode(this.getDirForObjectClass(keyClass), handleHashCode);
            if (infoFile == null) {
                stream.write("  error: CKR_OBJECT_HANDLE_INVALID\n".getBytes(StandardCharsets.UTF_8));
                return;
            }
            Properties properties = new Properties();
            properties.load(Files.newBufferedReader(infoFile.toPath()));
            properties.put("CLASS", PKCS11Constants.ckoCodeToName((long)keyClass));
            Set<String> names = properties.stringPropertyNames();
            int nameLen = 0;
            for (String name : names) {
                nameLen = Math.max(nameLen, name.length());
            }
            Object text = "";
            for (String name : properties.stringPropertyNames()) {
                Object valueText;
                if (name.equals(PROP_SHA1SUM) || name.equals("handle")) continue;
                String nameText = name + ": ";
                if (name.length() < nameLen) {
                    char[] padding = new char[nameLen - name.length()];
                    Arrays.fill(padding, ' ');
                    nameText = nameText + new String(padding);
                }
                String value = properties.getProperty(name);
                switch (name) {
                    case "keytype": {
                        valueText = PKCS11Constants.ckkCodeToName((long)Long.parseLong(value));
                        break;
                    }
                    case "base": 
                    case "prime": 
                    case "subprime": 
                    case "value": 
                    case "modus": 
                    case "publicExponent": 
                    case "ecParams": 
                    case "ecPoint": {
                        byte[] bytes = name.equals(PROP_EC_POINT) ? ASN1OctetString.getInstance((Object)Hex.decode((String)value)).getOctets() : Hex.decode((String)value);
                        valueText = "byte[" + bytes.length + "]\n" + Functions.toString((String)"    ", (byte[])bytes);
                        break;
                    }
                    default: {
                        valueText = value;
                    }
                }
                text = (String)text + "  " + nameText + (String)valueText + "\n";
            }
            stream.write(((String)text).getBytes(StandardCharsets.UTF_8));
        } else {
            String text;
            stream.write("\nList of objects:\n".getBytes(StandardCharsets.UTF_8));
            File[] keyInfoFiles = this.secKeyDir.listFiles(INFO_FILENAME_FILTER);
            int no = 0;
            if (keyInfoFiles != null) {
                for (File keyInfoFile : keyInfoFiles) {
                    text = StringUtil.formatAccount((long)(++no), (int)3) + ". " + this.objectToString(4L, keyInfoFile) + "\n";
                    stream.write(("  " + text).getBytes(StandardCharsets.UTF_8));
                }
            }
            if ((keyInfoFiles = this.privKeyDir.listFiles(INFO_FILENAME_FILTER)) != null) {
                for (File keyInfoFile : keyInfoFiles) {
                    text = StringUtil.formatAccount((long)(++no), (int)3) + ". " + this.objectToString(3L, keyInfoFile) + "\n";
                    stream.write(("  " + text).getBytes(StandardCharsets.UTF_8));
                }
            }
            if ((keyInfoFiles = this.pubKeyDir.listFiles(INFO_FILENAME_FILTER)) != null) {
                for (File keyInfoFile : keyInfoFiles) {
                    text = StringUtil.formatAccount((long)(++no), (int)3) + ". " + this.objectToString(2L, keyInfoFile) + "\n";
                    stream.write(("  " + text).getBytes(StandardCharsets.UTF_8));
                }
            }
        }
    }

    private static File getInfoFileForHashCode(File dir, int hashCode) {
        File[] files = dir.listFiles(INFO_FILENAME_FILTER);
        if (files != null) {
            for (File file : files) {
                byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(file.getName());
                if (hashCode != Arrays.hashCode(id)) continue;
                return file;
            }
        }
        return null;
    }

    private String objectToString(long objClass, File infoFile) {
        byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName());
        try {
            Properties props = this.loadProperties(infoFile);
            long handle = EmulatorP11Slot.deriveKeyHandle(objClass, id);
            long keyType = Long.parseLong(props.getProperty(PROP_KEYTYPE));
            String label = props.getProperty(PROP_LABEL);
            String keyspec = props.getProperty(PROP_KEYSPEC, "");
            return "handle=" + handle + ", id=" + EmulatorP11Slot.hex(id) + ", label=" + (label == null ? "<N/A>" : label) + ", " + PKCS11Constants.ckoCodeToName((long)objClass).substring(4) + ": " + PKCS11Constants.ckkCodeToName((long)keyType).substring(4) + "/" + keyspec;
        }
        catch (Exception e) {
            String message = "Error reading object saved in file " + infoFile.getParentFile().getName() + "/" + infoFile.getName();
            LogUtil.warn((Logger)LOG, (Throwable)e, (String)message);
            return message;
        }
    }

    private byte[] generateId() throws TokenException {
        byte[] id;
        do {
            id = new byte[this.newObjectConf.getIdLength()];
            this.random.nextBytes(id);
        } while (this.objectExistsByIdLabel(id, null));
        return id;
    }

    private static long deriveKeyHandle(long objClass, byte[] keyId) {
        long basesHandle = ((long)Arrays.hashCode(keyId) & 0xFFFFFFFFL) << 2;
        if (objClass == 4L) {
            return basesHandle + 1L;
        }
        if (objClass == 3L) {
            return basesHandle + 2L;
        }
        return basesHandle + 3L;
    }

    private static Long getObjectClassForHandle(long handle) {
        long suffix = handle & 3L;
        if (suffix == 2L) {
            return 3L;
        }
        if (suffix == 1L) {
            return 4L;
        }
        if (suffix == 3L) {
            return 2L;
        }
        return null;
    }

    private File getDirForObjectClass(long objectClass) {
        if (objectClass == 3L) {
            return this.privKeyDir;
        }
        if (objectClass == 4L) {
            return this.secKeyDir;
        }
        if (objectClass == 2L) {
            return this.pubKeyDir;
        }
        return null;
    }

    static {
        long[] mechs;
        LOG = LoggerFactory.getLogger(EmulatorP11Slot.class);
        supportedMechs = new HashMap<Long, MechanismInfo>();
        INFO_FILENAME_FILTER = new InfoFilenameFilter();
        for (long mech : mechs = new long[]{16L, 10L, 0L, 4160L, 4181L, 4182L, 0xFFFFF001L}) {
            supportedMechs.put(mech, new MechanismInfo(0L, Integer.MAX_VALUE, 65536L));
        }
        for (long mech : mechs = new long[]{848L, 4224L, 305L, 848L}) {
            supportedMechs.put(mech, new MechanismInfo(0L, Integer.MAX_VALUE, 32768L));
        }
        for (long mech : mechs = new long[]{544L, 597L, 592L, 608L, 624L, 693L, 688L, 704L, 720L}) {
            supportedMechs.put(mech, new MechanismInfo(0L, Integer.MAX_VALUE, 1024L));
        }
        for (long mech : mechs = new long[]{545L, 598L, 593L, 609L, 625L, 694L, 689L, 705L, 721L}) {
            supportedMechs.put(mech, new MechanismInfo(0L, Integer.MAX_VALUE, 10240L));
        }
        supportedMechs.put(3L, new MechanismInfo(0L, Integer.MAX_VALUE, 11008L));
        for (long mech : mechs = new long[]{1L, 6L, 70L, 64L, 65L, 66L, 102L, 96L, 97L, 98L, 13L, 14L, 71L, 67L, 68L, 69L, 103L, 99L, 100L, 101L}) {
            supportedMechs.put(mech, new MechanismInfo(0L, Integer.MAX_VALUE, 10240L));
        }
        for (long mech : mechs = new long[]{17L, 18L, 19L, 20L, 21L, 22L, 24L, 25L, 26L, 27L, 4161L, 4162L, 4163L, 4164L, 4165L, 4166L, 4167L, 4168L, 4169L, 4170L}) {
            supportedMechs.put(mech, new MechanismInfo(0L, Integer.MAX_VALUE, 10240L));
        }
        supportedMechs.put(4183L, new MechanismInfo(0L, Integer.MAX_VALUE, 10240L));
        for (long mech : mechs = new long[]{0xFFFFF003L, 0xFFFFF002L}) {
            supportedMechs.put(mech, new MechanismInfo(0L, Integer.MAX_VALUE, 10240L));
        }
    }

    private static class InfoFilenameFilter
    implements FilenameFilter {
        private InfoFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(EmulatorP11Slot.INFO_FILE_SUFFIX);
        }
    }
}

