/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.hsmproxy;

import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.params.ExtraParams;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.hsmproxy.HsmProxyP11Slot;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;

class HsmProxyP11Key
extends P11Key {
    public HsmProxyP11Key(HsmProxyP11Slot slot, PKCS11KeyId keyId) {
        super(slot, keyId);
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws TokenException {
        return this.slot.digestSecretKey(mechanism, this.keyId.getHandle());
    }

    @Override
    protected PublicKey getPublicKey0() throws TokenException {
        long keyType = this.keyId.getKeyType();
        if (keyType == 0L) {
            try {
                return KeyUtil.generateRSAPublicKey(new RSAPublicKeySpec(this.rsaModulus, this.rsaPublicExponent));
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        Long publicKeyHandle = this.keyId.getPublicKeyHandle();
        return publicKeyHandle == null ? null : this.slot.getPublicKey(publicKeyHandle);
    }

    @Override
    public void destroy() throws TokenException {
        long[] failedHandles = this.keyId.getPublicKeyHandle() == null ? this.slot.destroyObjectsByHandle(this.keyId.getHandle()) : this.slot.destroyObjectsByHandle(this.keyId.getHandle(), this.keyId.getPublicKeyHandle());
        if (failedHandles != null && failedHandles.length > 0) {
            throw new TokenException("error destroying key " + this.keyId);
        }
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws TokenException {
        Args.notNull((Object)content, (String)"content");
        ExtraParams extraParams = null;
        if (this.ecOrderBitSize != null) {
            extraParams = new ExtraParams();
            extraParams.ecOrderBitSize(this.ecOrderBitSize.intValue());
        }
        return this.slot.sign(mechanism, parameters, extraParams, this.keyId.getHandle(), content);
    }
}

