/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.hsmproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.pkcs11.hsmproxy.HsmProxyP11Slot;
import org.xipki.security.pkcs11.hsmproxy.ProxyAction;
import org.xipki.security.pkcs11.hsmproxy.ProxyMessage;
import org.xipki.util.Args;
import org.xipki.util.FileOrBinary;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborType;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.HostnameVerifiers;
import org.xipki.util.http.SslConf;
import org.xipki.util.http.SslContextConf;

class HsmProxyP11Module
extends P11Module {
    public static final String TYPE = "hsmproxy";
    private static final String PROP_SSL_STORETYPE = "ssl.storeType";
    private static final String PROP_SSL_KEYSTORE = "ssl.keystore";
    private static final String PROP_SSL_KEYSTOREPASSWORD = "ssl.keystorePassword";
    private static final String PROP_SSL_TRUSTCERTS = "ssl.trustcerts";
    private static final String PROP_SSL_HOStNAMEVERIFIER = "ssl.hostnameVerifier";
    private static final Logger LOG = LoggerFactory.getLogger(HsmProxyP11Module.class);
    private static final String REQUEST_MIMETYPE = "application/x-xipki-pkcs11";
    private static final String RESPONSE_MIMETYPE = "application/x-xipki-pkcs11";
    private static final byte[] SLOT_ID_NULL_CONTENT_NULL_REQUEST = new byte[]{-126, -10, -10};
    private final String description;
    private final String serverUrl;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;

    private HsmProxyP11Module(P11ModuleConf moduleConf) throws TokenException {
        super(moduleConf);
        String sslHostnameVerifier;
        String modulePath = moduleConf.getNativeLibrary();
        Map<String, String> properties = moduleConf.getNativeLibraryProperties();
        if (properties == null) {
            throw new TokenException("The properties field is not present");
        }
        this.description = StringUtil.concat((String)"PKCS#11 proxy", (String[])new String[]{"\nPath: ", modulePath});
        this.serverUrl = modulePath.endsWith("/") ? modulePath.substring(0, modulePath.length() - 1) : modulePath;
        SslConf sslConf = new SslConf();
        String sslStoreType = properties.get(PROP_SSL_STORETYPE);
        sslConf.setStoreType(sslStoreType);
        String sslKeystore = properties.get(PROP_SSL_KEYSTORE);
        sslConf.setKeystore(FileOrBinary.ofFile((String)sslKeystore));
        String sslKeystorePassword = properties.get(PROP_SSL_KEYSTOREPASSWORD);
        sslConf.setKeystorePassword(sslKeystorePassword);
        String sslTrustCerts = properties.get(PROP_SSL_TRUSTCERTS);
        if (sslTrustCerts != null) {
            StringTokenizer tokens = new StringTokenizer(sslTrustCerts, ",;:");
            ArrayList<FileOrBinary> files = new ArrayList<FileOrBinary>(tokens.countTokens());
            while (tokens.hasMoreTokens()) {
                String file = tokens.nextToken().trim();
                files.add(FileOrBinary.ofFile((String)file));
            }
            sslConf.setTrustanchors(files.toArray(new FileOrBinary[0]));
        }
        if ((sslHostnameVerifier = properties.get(PROP_SSL_HOStNAMEVERIFIER)) != null) {
            sslConf.setHostnameVerifier(sslHostnameVerifier);
        }
        SslContextConf sslContextConf = SslContextConf.ofSslConf((SslConf)sslConf);
        try {
            this.sslSocketFactory = sslContextConf.getSslSocketFactory();
        }
        catch (ObjectCreationException ex) {
            throw new TokenException("could not build SSLSocketFactroy", (Exception)((Object)ex));
        }
        try {
            this.hostnameVerifier = HostnameVerifiers.createHostnameVerifier((String)sslHostnameVerifier);
        }
        catch (ObjectCreationException ex) {
            throw new TokenException("could not create HostnameVerifier", (Exception)((Object)ex));
        }
        ProxyMessage.ModuleCapsResponse moduleCaps = (ProxyMessage.ModuleCapsResponse)this.sendModuleAction(ProxyAction.moduleCaps);
        if (!moduleConf.isReadOnly()) {
            moduleConf.setReadOnly(moduleCaps.isReadOnly());
        }
        if (moduleConf.getMaxMessageSize() > moduleCaps.getMaxMessageSize()) {
            moduleConf.setMaxMessageSize(moduleCaps.getMaxMessageSize());
        }
        if (moduleCaps.getNewObjectConf() != null) {
            moduleConf.setNewObjectConf(moduleCaps.getNewObjectConf());
        }
        if (moduleCaps.getSecretKeyTypes() != null) {
            moduleConf.setSecretKeyTypes(HsmProxyP11Module.intersect(moduleConf.getSecretKeyTypes(), moduleCaps.getSecretKeyTypes()));
        }
        if (moduleCaps.getKeyPairTypes() != null) {
            moduleConf.setKeyPairTypes(HsmProxyP11Module.intersect(moduleConf.getKeyPairTypes(), moduleCaps.getKeyPairTypes()));
        }
        ProxyMessage.SlotIdsResponse resp = (ProxyMessage.SlotIdsResponse)this.sendModuleAction(ProxyAction.slotIds);
        HashSet<P11Slot> slots = new HashSet<P11Slot>();
        for (P11SlotId slotId : resp.getSlotIds()) {
            if (!this.conf.isSlotIncluded(slotId)) continue;
            if (!this.conf.isSlotIncluded(slotId)) {
                LOG.info("skipped slot {}", (Object)slotId);
                continue;
            }
            HsmProxyP11Slot slot = new HsmProxyP11Slot(slotId, moduleConf.isReadOnly(), this, this.conf.getP11MechanismFilter(), moduleCaps.getNewObjectConf(), moduleCaps.getSecretKeyTypes(), moduleCaps.getKeyPairTypes());
            slots.add(slot);
        }
        this.setSlots(slots);
    }

    private static <T> List<T> intersect(List<T> a, List<T> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (new HashSet<T>(a).containsAll(b) && a.size() == b.size()) {
            return a;
        }
        ArrayList<T> r = new ArrayList<T>(Math.min(a.size(), b.size()));
        for (T ta : a) {
            if (!b.contains(ta)) continue;
            r.add(ta);
        }
        return r;
    }

    public static P11Module getInstance(P11ModuleConf moduleConf) throws TokenException {
        Args.notNull((Object)moduleConf, (String)"moduleConf");
        if (moduleConf.getUserName() != null) {
            throw new TokenException("userName is present but shall be null");
        }
        return new HsmProxyP11Module(moduleConf);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void close() {
        for (P11SlotId slotId : this.getSlotIds()) {
            try {
                this.getSlot(slotId).close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not close PKCS#11 slot " + slotId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doSend(ProxyAction action, byte[] request) throws IOException {
        InputStream inputstream;
        Args.notNull((Object)request, (String)"request");
        String thisUrl = this.serverUrl + "/" + action.getAlias();
        HttpURLConnection httpUrlConnection = IoUtil.openHttpConn((URL)new URL(thisUrl));
        if (httpUrlConnection instanceof HttpsURLConnection) {
            if (this.sslSocketFactory != null) {
                ((HttpsURLConnection)httpUrlConnection).setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                ((HttpsURLConnection)httpUrlConnection).setHostnameVerifier(this.hostnameVerifier);
            }
        }
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setUseCaches(false);
        int size = request.length;
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Content-Type", "application/x-xipki-pkcs11");
        httpUrlConnection.setRequestProperty("Content-Length", Integer.toString(size));
        OutputStream outputstream = httpUrlConnection.getOutputStream();
        outputstream.write(request);
        outputstream.flush();
        if (httpUrlConnection.getResponseCode() != 200) {
            try {
                try {
                    InputStream is = httpUrlConnection.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    InputStream errStream = httpUrlConnection.getErrorStream();
                    if (errStream != null) {
                        errStream.close();
                    }
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
            throw new IOException("bad response: code=" + httpUrlConnection.getResponseCode() + ", message=" + httpUrlConnection.getResponseMessage());
        }
        try {
            inputstream = httpUrlConnection.getInputStream();
        }
        catch (IOException ex) {
            InputStream errStream = httpUrlConnection.getErrorStream();
            if (errStream != null) {
                errStream.close();
            }
            throw ex;
        }
        try {
            int readedByte;
            String responseContentType = httpUrlConnection.getContentType();
            boolean isValidContentType = false;
            if (responseContentType != null && responseContentType.equalsIgnoreCase("application/x-xipki-pkcs11")) {
                isValidContentType = true;
            }
            if (!isValidContentType) {
                throw new IOException("bad response: mime type " + responseContentType + " is not supported!");
            }
            byte[] buf = new byte[4096];
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            while ((readedByte = inputstream.read(buf)) != -1) {
                bytearrayoutputstream.write(buf, 0, readedByte);
            }
            byte[] byArray = bytearrayoutputstream.toByteArray();
            return byArray;
        }
        finally {
            inputstream.close();
        }
    }

    public ProxyMessage sendModuleAction(ProxyAction action) throws TokenException {
        return this.send(action, (byte[])SLOT_ID_NULL_CONTENT_NULL_REQUEST.clone());
    }

    public ProxyMessage send(ProxyAction action, byte[] request) throws TokenException {
        byte[] respBytes;
        Args.notNull((Object)request, (String)"request");
        try {
            respBytes = this.doSend(action, request);
        }
        catch (IOException ex) {
            LOG.error("IO error", (Object)request);
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(respBytes);
        ProxyMessage.ErrorResponse errorResp = null;
        try {
            CborType type = decoder.peekType();
            if (CborDecoder.isNull((CborType)type)) {
                decoder.readNull();
                return null;
            }
            if (type.getMajorType() == 6) {
                long tag = decoder.readTag();
                if (524288L != tag) {
                    throw new TokenException("response is tagged but not with tag CBOR_TAG_ERROR_RESPONSE");
                }
                errorResp = ProxyMessage.ErrorResponse.decode((CborDecoder)decoder);
            }
        }
        catch (IOException ex) {
            throw new TokenException("IO error decoding response", (Exception)ex);
        }
        catch (DecodeException ex) {
            throw new TokenException("DecodeException decoding response", (Exception)((Object)ex));
        }
        if (errorResp != null) {
            ProxyMessage.ProxyErrorCode errorCode = errorResp.getErrorCode();
            String detail = errorResp.getDetail();
            switch (errorCode) {
                case badRequest: 
                case internalError: {
                    throw new TokenException(errorCode + ": " + detail);
                }
                case pkcs11Exception: {
                    long ckrCode;
                    try {
                        ckrCode = detail.startsWith("CKR_") || detail.startsWith("ckr_") ? PKCS11Constants.ckrNameToCode((String)detail) : Long.parseLong(detail);
                    }
                    catch (Exception ex) {
                        LOG.warn("could not parse CKR code '" + detail + "'");
                        ckrCode = 5L;
                    }
                    throw new PKCS11Exception(ckrCode);
                }
                case tokenException: {
                    throw new TokenException(detail);
                }
            }
        }
        try {
            switch (action) {
                case moduleCaps: {
                    return ProxyMessage.ModuleCapsResponse.decode((CborDecoder)decoder);
                }
                case slotIds: {
                    return ProxyMessage.SlotIdsResponse.decode((CborDecoder)decoder);
                }
                case mechInfos: {
                    return ProxyMessage.GetMechanismInfosResponse.decode((CborDecoder)decoder);
                }
                case keyByKeyId: 
                case keyByIdLabel: {
                    return ProxyMessage.P11KeyResponse.decode((CborDecoder)decoder);
                }
                case objectExistsByIdLabel: {
                    return ProxyMessage.BooleanMessage.decode((CborDecoder)decoder);
                }
                case destroyAllObjects: 
                case destroyObjectsByIdLabel: {
                    return ProxyMessage.IntMessage.decode((CborDecoder)decoder);
                }
                case destroyObjectsByHandle: {
                    return ProxyMessage.LongArrayMessage.decode((CborDecoder)decoder);
                }
                case keyIdByIdLabel: 
                case genSecretKey: 
                case importSecretKey: 
                case genRSAKeypair: 
                case genDSAKeypair2: 
                case genDSAKeypair: 
                case genECKeypair: 
                case genSM2Keypair: {
                    return ProxyMessage.KeyIdMessage.decode((CborDecoder)decoder);
                }
                case genRSAKeypairOtf: 
                case genDSAKeypairOtf: 
                case genECKeypairOtf: 
                case genSM2KeypairOtf: 
                case publicKeyByHandle: 
                case showDetails: 
                case sign: 
                case digestSecretKey: {
                    return ProxyMessage.ByteArrayMessage.decode((CborDecoder)decoder);
                }
            }
            throw new IllegalStateException("should not reach here, unknown action " + action);
        }
        catch (DecodeException ex) {
            throw new TokenException("DecodingException while decoding response.", (Exception)((Object)ex));
        }
    }
}

