/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.hsmproxy;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.params.ExtraParams;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.pkcs11.hsmproxy.HsmProxyP11Module;
import org.xipki.security.pkcs11.hsmproxy.ProxyAction;
import org.xipki.security.pkcs11.hsmproxy.ProxyMessage;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.cbor.ByteArrayCborEncoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.EncodeException;

class HsmProxyP11Slot
extends P11Slot {
    private static final Logger LOG = LoggerFactory.getLogger(HsmProxyP11Slot.class);
    private final HsmProxyP11Module module;

    HsmProxyP11Slot(P11SlotId slotId, boolean readOnly, HsmProxyP11Module module, P11ModuleConf.P11MechanismFilter mechanismFilter, P11ModuleConf.P11NewObjectConf newObjectConf, List<Long> secretKeyTypes, List<Long> keyPairTypes) throws TokenException {
        super(module.getName(), slotId, readOnly, secretKeyTypes, keyPairTypes, newObjectConf);
        this.module = module;
        ProxyMessage.GetMechanismInfosResponse resp = (ProxyMessage.GetMechanismInfosResponse)this.send(ProxyAction.mechInfos, null);
        Map<Long, MechanismInfo> mechanismInfoMap = resp == null ? Collections.emptyMap() : resp.getMechamismInfoMap();
        this.initMechanisms(mechanismInfoMap, mechanismFilter);
    }

    @Override
    public final void close() {
    }

    @Override
    public P11Key getKey(PKCS11KeyId keyId) throws TokenException {
        return this.toP11Key(this.send(ProxyAction.keyByKeyId, new ProxyMessage.KeyIdMessage(keyId)));
    }

    @Override
    public P11Key getKey(byte[] keyId, String keyLabel) throws TokenException {
        return this.toP11Key(this.send(ProxyAction.keyByIdLabel, new ProxyMessage.IdLabelMessage(keyId, keyLabel)));
    }

    @Override
    public PKCS11KeyId getKeyId(byte[] keyId, String keyLabel) throws TokenException {
        return HsmProxyP11Slot.toPKCS11KeyId(this.send(ProxyAction.keyIdByIdLabel, new ProxyMessage.IdLabelMessage(keyId, keyLabel)));
    }

    @Override
    public byte[] sign(long mechanism, P11Params params, ExtraParams extraParams, long keyHandle, byte[] content) throws TokenException {
        ProxyMessage.SignRequest req = new ProxyMessage.SignRequest(keyHandle, mechanism, params, extraParams, content);
        return HsmProxyP11Slot.toByteArray(this.send(ProxyAction.sign, req));
    }

    @Override
    public PublicKey getPublicKey(long handle) throws TokenException {
        byte[] bytes = HsmProxyP11Slot.toByteArray(this.send(ProxyAction.publicKeyByHandle, new ProxyMessage.LongMessage(handle)));
        try {
            return bytes == null ? null : KeyUtil.generatePublicKey(SubjectPublicKeyInfo.getInstance((Object)bytes));
        }
        catch (InvalidKeySpecException ex) {
            throw new TokenException("error parsing SubjectPublicKeyInfo", (Exception)ex);
        }
    }

    @Override
    public byte[] digestSecretKey(long mechanism, long handle) throws TokenException {
        ProxyMessage.DigestSecretKeyRequest req = new ProxyMessage.DigestSecretKeyRequest(mechanism, handle);
        return HsmProxyP11Slot.toByteArray(this.send(ProxyAction.digestSecretKey, req));
    }

    @Override
    public boolean objectExistsByIdLabel(byte[] id, String label) throws TokenException {
        return ((ProxyMessage.BooleanMessage)this.send(ProxyAction.objectExistsByIdLabel, new ProxyMessage.IdLabelMessage(id, label))).getValue();
    }

    @Override
    public int destroyAllObjects() {
        try {
            return ((ProxyMessage.IntMessage)this.send(ProxyAction.destroyAllObjects, null)).getValue();
        }
        catch (TokenException e) {
            LogUtil.warn((Logger)LOG, (Throwable)e, (String)"error destroyAllObjects()");
            return 0;
        }
    }

    @Override
    public long[] destroyObjectsByHandle(long[] handles) {
        try {
            ProxyMessage.LongArrayMessage resp = (ProxyMessage.LongArrayMessage)this.send(ProxyAction.destroyObjectsByHandle, new ProxyMessage.LongArrayMessage(handles));
            return resp == null ? null : resp.getValue();
        }
        catch (Exception e) {
            LogUtil.warn((Logger)LOG, (Throwable)e, (String)"error destroyObjectsByHandle()");
            return (long[])handles.clone();
        }
    }

    @Override
    public int destroyObjectsByIdLabel(byte[] id, String label) throws TokenException {
        try {
            return ((ProxyMessage.IntMessage)this.send(ProxyAction.destroyObjectsByIdLabel, new ProxyMessage.IdLabelMessage(id, label))).getValue();
        }
        catch (TokenException e) {
            LogUtil.warn((Logger)LOG, (Throwable)e, (String)"error destroyAllObjects()");
            return 0;
        }
    }

    @Override
    public PKCS11KeyId generateSecretKey(long keyType, Integer keysize, P11Slot.P11NewKeyControl control) throws TokenException {
        return HsmProxyP11Slot.toPKCS11KeyId(this.send(ProxyAction.genSecretKey, new ProxyMessage.GenerateSecretKeyRequest(keyType, keysize, control)));
    }

    @Override
    public PKCS11KeyId importSecretKey(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl control) throws TokenException {
        return HsmProxyP11Slot.toPKCS11KeyId(this.send(ProxyAction.importSecretKey, new ProxyMessage.ImportSecretKeyRequest(keyType, keyValue, control)));
    }

    @Override
    public PKCS11KeyId generateRSAKeypair(int keysize, BigInteger publicExponent, P11Slot.P11NewKeyControl control) throws TokenException {
        return HsmProxyP11Slot.toPKCS11KeyId(this.send(ProxyAction.genRSAKeypair, new ProxyMessage.GenerateRSAKeyPairRequest(keysize, publicExponent, control)));
    }

    @Override
    public PrivateKeyInfo generateRSAKeypairOtf(int keysize, BigInteger publicExponent) throws TokenException {
        return HsmProxyP11Slot.toPrivateKeyInfo(this.send(ProxyAction.genRSAKeypairOtf, new ProxyMessage.GenerateRSAKeyPairOtfRequest(keysize, publicExponent)));
    }

    @Override
    public PKCS11KeyId generateDSAKeypair(int plength, int qlength, P11Slot.P11NewKeyControl control) throws TokenException {
        return HsmProxyP11Slot.toPKCS11KeyId(this.send(ProxyAction.genDSAKeypair2, new ProxyMessage.GenerateDSAKeyPairByKeysizeRequest(plength, qlength, control)));
    }

    @Override
    public PKCS11KeyId generateDSAKeypair(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl control) throws TokenException {
        return HsmProxyP11Slot.toPKCS11KeyId(this.send(ProxyAction.genDSAKeypair, new ProxyMessage.GenerateDSAKeyPairRequest(p, q, g, control)));
    }

    @Override
    public PrivateKeyInfo generateDSAKeypairOtf(BigInteger p, BigInteger q, BigInteger g) throws TokenException {
        return HsmProxyP11Slot.toPrivateKeyInfo(this.send(ProxyAction.genDSAKeypairOtf, new ProxyMessage.GenerateDSAKeyPairOtfRequest(p, q, g)));
    }

    @Override
    public PKCS11KeyId generateECKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws TokenException {
        return HsmProxyP11Slot.toPKCS11KeyId(this.send(ProxyAction.genECKeypair, new ProxyMessage.GenerateECKeyPairRequest(curveId, control)));
    }

    @Override
    public PrivateKeyInfo generateECKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        return HsmProxyP11Slot.toPrivateKeyInfo(this.send(ProxyAction.genECKeypair, new ProxyMessage.GenerateECKeyPairOtfRequest(curveId)));
    }

    @Override
    public PKCS11KeyId generateSM2Keypair(P11Slot.P11NewKeyControl control) throws TokenException {
        return HsmProxyP11Slot.toPKCS11KeyId(this.send(ProxyAction.genSM2Keypair, new ProxyMessage.GenerateSM2KeyPairRequest(control)));
    }

    @Override
    public PrivateKeyInfo generateSM2KeypairOtf() throws TokenException {
        return HsmProxyP11Slot.toPrivateKeyInfo(this.send(ProxyAction.genSM2KeypairOtf, null));
    }

    private P11Key toP11Key(ProxyMessage response) throws TokenException {
        if (response == null) {
            return null;
        }
        if (!(response instanceof ProxyMessage.P11KeyResponse)) {
            throw new TokenException("response is not a P11KeyResponse");
        }
        return ((ProxyMessage.P11KeyResponse)response).getP11Key(this);
    }

    private static byte[] toByteArray(ProxyMessage response) throws TokenException {
        if (response == null) {
            return null;
        }
        if (!(response instanceof ProxyMessage.ByteArrayMessage)) {
            throw new TokenException("response is not a ByteArrayMessage");
        }
        return ((ProxyMessage.ByteArrayMessage)response).getValue();
    }

    private static PKCS11KeyId toPKCS11KeyId(ProxyMessage response) throws TokenException {
        if (response == null) {
            return null;
        }
        if (!(response instanceof ProxyMessage.KeyIdMessage)) {
            throw new TokenException("response is not a KeyIdMessage");
        }
        return ((ProxyMessage.KeyIdMessage)response).getKeyId();
    }

    private static PrivateKeyInfo toPrivateKeyInfo(ProxyMessage response) throws TokenException {
        byte[] bytes = HsmProxyP11Slot.toByteArray(response);
        if (bytes == null) {
            return null;
        }
        try {
            return PrivateKeyInfo.getInstance((Object)bytes);
        }
        catch (IllegalArgumentException ex) {
            throw new TokenException("invalid PrivateKeyInfo", (Exception)ex);
        }
    }

    @Override
    public void showDetails(OutputStream stream, Long objectHandle, boolean verbose) throws IOException {
        byte[] details;
        ProxyMessage.ShowDetailsRequest req = new ProxyMessage.ShowDetailsRequest(objectHandle, verbose);
        try {
            details = ((ProxyMessage.ByteArrayMessage)this.send(ProxyAction.showDetails, req)).getValue();
        }
        catch (TokenException e) {
            details = ("ERROR: " + e.getMessage()).getBytes(StandardCharsets.UTF_8);
        }
        stream.write(details);
    }

    private ProxyMessage send(ProxyAction action, ProxyMessage request) throws TokenException {
        ByteArrayCborEncoder encoder = new ByteArrayCborEncoder();
        try {
            encoder.writeArrayStart(2);
            encoder.writeInt(this.slotId.getId());
            if (request == null) {
                encoder.writeNull();
            } else {
                request.encode((CborEncoder)encoder);
            }
        }
        catch (EncodeException ex) {
            throw new TokenException("Encode error while building request", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new TokenException("IO error while building request", (Exception)ex);
        }
        return this.module.send(action, encoder.toByteArray());
    }

    @Override
    protected PKCS11KeyId doGenerateSecretKey(long keyType, Integer keysize, P11Slot.P11NewKeyControl control) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PKCS11KeyId doImportSecretKey(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl control) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PKCS11KeyId doGenerateDSAKeypair(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl control) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PKCS11KeyId doGenerateECEdwardsKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PrivateKeyInfo doGenerateECEdwardsKeypairOtf(ASN1ObjectIdentifier curveId) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PKCS11KeyId doGenerateECMontgomeryKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PrivateKeyInfo doGenerateECMontgomeryKeypairOtf(ASN1ObjectIdentifier curveId) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PKCS11KeyId doGenerateECKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PrivateKeyInfo doGenerateECKeypairOtf(ASN1ObjectIdentifier curveId) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PKCS11KeyId doGenerateSM2Keypair(P11Slot.P11NewKeyControl control) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PrivateKeyInfo doGenerateSM2KeypairOtf() {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PKCS11KeyId doGenerateRSAKeypair(int keysize, BigInteger publicExponent, P11Slot.P11NewKeyControl control) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PrivateKeyInfo doGenerateRSAKeypairOtf(int keysize, BigInteger publicExponent) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }

    @Override
    protected PrivateKeyInfo generateDSAKeypairOtf0(BigInteger p, BigInteger q, BigInteger g) {
        throw new UnsupportedOperationException("doGenerateSecretKey() unsupported");
    }
}

