/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.hsmproxy;

import java.util.HashMap;
import java.util.Map;

public enum ProxyAction {
    moduleCaps("mcaps"),
    slotIds("sids"),
    mechInfos("mis"),
    publicKeyByHandle("pkbh"),
    keyByKeyId("kbi"),
    keyByIdLabel("kbil"),
    keyIdByIdLabel("kibil"),
    objectExistsByIdLabel("ebil"),
    destroyAllObjects("dao"),
    destroyObjectsByHandle("dobh"),
    destroyObjectsByIdLabel("dobil"),
    genSecretKey("gsk"),
    importSecretKey("isk"),
    genRSAKeypair("grsa"),
    genRSAKeypairOtf("grsao"),
    genDSAKeypair2("gdsa2"),
    genDSAKeypair("gdsa"),
    genDSAKeypairOtf("gdsao"),
    genECKeypair("gec"),
    genECKeypairOtf("geco"),
    genSM2Keypair("gsm2"),
    genSM2KeypairOtf("gsm2o"),
    showDetails("d"),
    sign("s"),
    digestSecretKey("dsk");

    private final String alias;
    private static final Map<String, ProxyAction> namealiasActionMap;

    private ProxyAction(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public static ProxyAction ofNameIgnoreCase(String name) {
        return namealiasActionMap.get(name.toLowerCase());
    }

    static {
        namealiasActionMap = new HashMap<String, ProxyAction>();
        for (ProxyAction p : ProxyAction.values()) {
            namealiasActionMap.put(p.name().toLowerCase(), p);
        }
        for (ProxyAction p : ProxyAction.values()) {
            String lc = p.alias.toLowerCase();
            if (namealiasActionMap.containsKey(lc)) {
                throw new IllegalStateException("invalid alias " + p.alias);
            }
            namealiasActionMap.put(lc, p);
        }
    }
}

