/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.hsmproxy;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.params.ExtraParams;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.pkcs11.hsmproxy.HsmProxyP11Key;
import org.xipki.security.pkcs11.hsmproxy.HsmProxyP11Slot;
import org.xipki.util.Args;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public abstract class ProxyMessage
implements CborEncodable {
    protected abstract void encode0(CborEncoder var1) throws EncodeException, IOException;

    public final void encode(CborEncoder encoder) throws EncodeException {
        try {
            this.encode0(encoder);
        }
        catch (IOException ex) {
            throw new EncodeException("IO error", (Throwable)ex);
        }
    }

    private static boolean isNotNullOrElseWriteNull(CborEncoder encoder, Object obj) throws IOException {
        if (obj == null) {
            encoder.writeNull();
            return false;
        }
        return true;
    }

    private static void writeBigInt(CborEncoder encoder, BigInteger value) throws IOException {
        if (ProxyMessage.isNotNullOrElseWriteNull(encoder, value)) {
            encoder.writeByteString(value.toByteArray());
        }
    }

    private static void writeOid(CborEncoder encoder, ASN1ObjectIdentifier value) throws IOException {
        if (ProxyMessage.isNotNullOrElseWriteNull(encoder, value)) {
            encoder.writeTextString(value.getId());
        }
    }

    private static ASN1ObjectIdentifier readOid(CborDecoder decoder) throws IOException, DecodeException {
        String text = decoder.readTextString();
        if (text == null) {
            return null;
        }
        try {
            return new ASN1ObjectIdentifier(text);
        }
        catch (IllegalArgumentException ex) {
            throw new DecodeException(text + " is not a valid ObjectIdentifier");
        }
    }

    private static void writeNewKeyControl(CborEncoder encoder, P11Slot.P11NewKeyControl control) throws IOException {
        if (control == null) {
            encoder.writeNull();
            return;
        }
        encoder.writeArrayStart(5);
        encoder.writeByteString(control.getId());
        encoder.writeTextString(control.getLabel());
        encoder.writeBooleanObj(control.getSensitive());
        encoder.writeBooleanObj(control.getExtractable());
        Set<P11Slot.P11KeyUsage> usages = control.getUsages();
        if (usages == null) {
            encoder.writeNull();
        } else {
            encoder.writeArrayStart(usages.size());
            for (P11Slot.P11KeyUsage usage : usages) {
                encoder.writeTextString(usage.name());
            }
        }
    }

    private static P11Slot.P11NewKeyControl decodeNewKeyControl(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(5)) {
                return null;
            }
            byte[] id = decoder.readByteString();
            String label = decoder.readTextString();
            P11Slot.P11NewKeyControl control = new P11Slot.P11NewKeyControl(id, label);
            control.setSensitive(decoder.readBooleanObj());
            control.setExtractable(decoder.readBooleanObj());
            Integer usagesLen = decoder.readNullOrArrayLength();
            if (usagesLen != null) {
                HashSet<P11Slot.P11KeyUsage> usages = new HashSet<P11Slot.P11KeyUsage>(usagesLen * 5 / 4);
                for (int i = 0; i < usagesLen; ++i) {
                    P11Slot.P11KeyUsage usage;
                    String usageText = decoder.readTextString();
                    try {
                        usage = P11Slot.P11KeyUsage.valueOf(usageText);
                    }
                    catch (IllegalArgumentException e) {
                        throw new DecodeException("unknown P11KeyUsage " + usageText);
                    }
                    usages.add(usage);
                }
                control.setUsages(usages);
            }
            return control;
        }
        catch (IOException ex) {
            throw new DecodeException("IO error", (Throwable)ex);
        }
    }

    private static void writeKeyId(CborEncoder encoder, PKCS11KeyId keyId) throws IOException {
        encoder.writeArrayStart(6);
        encoder.writeInt(keyId.getHandle());
        encoder.writeInt(keyId.getObjectCLass());
        encoder.writeInt(keyId.getKeyType());
        encoder.writeByteString(keyId.getId());
        encoder.writeTextString(keyId.getLabel());
        encoder.writeIntObj(keyId.getPublicKeyHandle());
    }

    private static PKCS11KeyId decodeKeyId(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(6)) {
                return null;
            }
            long handle = decoder.readLong();
            long objectCLass = decoder.readLong();
            long keyType = decoder.readLong();
            byte[] id = decoder.readByteString();
            String label = decoder.readTextString();
            Long publicKeyHandle = decoder.readLongObj();
            PKCS11KeyId keyId = new PKCS11KeyId(handle, objectCLass, keyType, id, label);
            keyId.setPublicKeyHandle(publicKeyHandle);
            return keyId;
        }
        catch (IOException ex) {
            throw new DecodeException("IO error decoding PKCS11KeyId", (Throwable)ex);
        }
    }

    private static void assertArraySize(CborDecoder decoder, int arraySize, String name) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(arraySize)) {
                throw new DecodeException(name + " shall not be null");
            }
        }
        catch (IOException ex) {
            throw new DecodeException("IO error reading arrayLength of " + name);
        }
    }

    public static class SlotIdsResponse
    extends ProxyMessage {
        private final List<P11SlotId> slotIds;

        public SlotIdsResponse(List<P11SlotId> slotIds) {
            this.slotIds = (List)Args.notNull(slotIds, (String)"slotIds");
        }

        public List<P11SlotId> getSlotIds() {
            return this.slotIds;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(this.slotIds.size());
            for (P11SlotId slotId : this.slotIds) {
                encoder.writeArrayStart(2);
                encoder.writeInt((long)slotId.getIndex());
                encoder.writeInt(slotId.getId());
            }
        }

        public static SlotIdsResponse decode(CborDecoder decoder) throws DecodeException {
            try {
                int arrayLen = Optional.ofNullable(decoder.readNullOrArrayLength()).orElseThrow(() -> new DecodeException("SlotIdsResponse shall not be null"));
                ArrayList<P11SlotId> list = new ArrayList<P11SlotId>(arrayLen);
                for (int i = 0; i < arrayLen; ++i) {
                    ProxyMessage.assertArraySize(decoder, 2, "P11SlotId");
                    int index = decoder.readInt();
                    long id = decoder.readLong();
                    list.add(new P11SlotId(index, id));
                }
                return new SlotIdsResponse(list);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding SlotIdsResponse", (Throwable)ex);
            }
        }
    }

    public static class SignRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 5;
        private static final int TAG_P11ByteArrayParams = 80000;
        private static final int TAG_P11RSAPkcsPssParams = 80001;
        private final long keyHandle;
        private final long mechanism;
        private final P11Params p11params;
        private final ExtraParams extraParams;
        private final byte[] content;

        public SignRequest(long keyHandle, long mechanism, P11Params p11params, ExtraParams extraParams, byte[] content) {
            this.keyHandle = keyHandle;
            this.mechanism = mechanism;
            this.p11params = p11params;
            this.extraParams = extraParams;
            this.content = content;
        }

        public long getKeyHandle() {
            return this.keyHandle;
        }

        public byte[] getContent() {
            return this.content;
        }

        public long getMechanism() {
            return this.mechanism;
        }

        public P11Params getP11params() {
            return this.p11params;
        }

        public ExtraParams getExtraParams() {
            return this.extraParams;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(5);
            encoder.writeInt(this.keyHandle);
            encoder.writeInt(this.mechanism);
            SignRequest.writeP11Params(encoder, this.p11params);
            SignRequest.writeExtraParams(encoder, this.extraParams);
            encoder.writeByteString(this.content);
        }

        public static SignRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 5, "SignRequest");
            try {
                long handle = decoder.readLong();
                long mechanism = decoder.readLong();
                P11Params params = SignRequest.decodeP11Params(decoder);
                ExtraParams extraParams = SignRequest.decodeExtraParams(decoder);
                byte[] content = decoder.readByteString();
                return new SignRequest(handle, mechanism, params, extraParams, content);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding SignRequest", (Throwable)ex);
            }
        }

        private static void writeExtraParams(CborEncoder encoder, ExtraParams params) throws IOException {
            if (params == null) {
                encoder.writeNull();
                return;
            }
            encoder.writeArrayStart(1);
            encoder.writeInt((long)params.ecOrderBitSize());
        }

        private static ExtraParams decodeExtraParams(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(1)) {
                    return null;
                }
                return new ExtraParams().ecOrderBitSize(decoder.readInt());
            }
            catch (IOException ex) {
                throw new DecodeException("IO error", (Throwable)ex);
            }
        }

        protected static void writeP11Params(CborEncoder encoder, P11Params params) throws IOException {
            if (params == null) {
                encoder.writeNull();
                return;
            }
            if (params instanceof P11Params.P11ByteArrayParams) {
                P11Params.P11ByteArrayParams tParams = (P11Params.P11ByteArrayParams)params;
                encoder.writeTag(80000L);
                encoder.writeArrayStart(1);
                encoder.writeByteString(tParams.getBytes());
            } else if (params instanceof P11Params.P11RSAPkcsPssParams) {
                P11Params.P11RSAPkcsPssParams tParams = (P11Params.P11RSAPkcsPssParams)params;
                encoder.writeTag(80001L);
                encoder.writeArrayStart(3);
                encoder.writeInt(tParams.getHashAlgorithm());
                encoder.writeInt(tParams.getMaskGenerationFunction());
                encoder.writeInt((long)tParams.getSaltLength());
            } else {
                throw new IllegalStateException("unknown params " + params.getClass().getName());
            }
        }

        public static P11Params decodeP11Params(CborDecoder decoder) throws DecodeException {
            try {
                Long tag = decoder.readTagObj();
                if (tag == null) {
                    return null;
                }
                if (80000L == tag) {
                    ProxyMessage.assertArraySize(decoder, 1, "P11ByteArrayParams");
                    return new P11Params.P11ByteArrayParams(decoder.readByteString());
                }
                if (80001L == tag) {
                    ProxyMessage.assertArraySize(decoder, 3, "P11RSAPkcsPssParams");
                    long hashAlgorithm = decoder.readLong();
                    long maskGenerationFunction = decoder.readLong();
                    int saltLength = decoder.readInt();
                    return new P11Params.P11RSAPkcsPssParams(hashAlgorithm, maskGenerationFunction, saltLength);
                }
                throw new DecodeException("unknown tag " + tag);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error", (Throwable)ex);
            }
        }
    }

    public static class ShowDetailsRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 2;
        private final Long objectHandle;
        private final boolean verbose;

        public ShowDetailsRequest(Long objectHandle, boolean verbose) {
            this.objectHandle = objectHandle;
            this.verbose = verbose;
        }

        public Long getObjectHandle() {
            return this.objectHandle;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(2);
            encoder.writeIntObj(this.objectHandle);
            encoder.writeBoolean(this.verbose);
        }

        public static ShowDetailsRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 2, "ShowDetailsRequest");
            try {
                Long objectHandle = decoder.readLongObj();
                boolean verbose = decoder.readBoolean();
                return new ShowDetailsRequest(objectHandle, verbose);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding P11KeyResponse", (Throwable)ex);
            }
        }
    }

    public static class P11KeyResponse
    extends ProxyMessage {
        private static final int NUM_FIELDS = 9;
        private final PKCS11KeyId keyId;
        private boolean sign;
        private ASN1ObjectIdentifier ecParams;
        private Integer ecOrderBitSize;
        private BigInteger rsaModulus;
        private BigInteger rsaPublicExponent;
        private BigInteger dsaP;
        private BigInteger dsaQ;
        private BigInteger dsaG;

        public P11KeyResponse(P11Key key) {
            Args.notNull((Object)key, (String)"key");
            this.keyId = key.getKeyId();
            this.ecParams = key.getEcParams();
            this.ecOrderBitSize = key.getEcOrderBitSize();
            this.dsaP = key.getDsaP();
            this.dsaQ = key.getDsaQ();
            this.dsaG = key.getDsaG();
            this.rsaModulus = key.getRsaModulus();
            this.rsaPublicExponent = key.getRsaPublicExponent();
            this.sign = key.isSign();
        }

        public P11KeyResponse(PKCS11KeyId keyId) {
            this.keyId = (PKCS11KeyId)Args.notNull((Object)keyId, (String)"keyId");
        }

        public P11Key getP11Key(HsmProxyP11Slot slot) {
            HsmProxyP11Key key = new HsmProxyP11Key(slot, this.keyId);
            key.setEcParams(this.ecParams);
            key.setDsaParameters(this.dsaP, this.dsaQ, this.dsaG);
            key.setRsaMParameters(this.rsaModulus, this.rsaPublicExponent);
            key.sign(this.sign);
            return key;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(9);
            ProxyMessage.writeKeyId(encoder, this.keyId);
            encoder.writeBoolean(this.sign);
            ProxyMessage.writeOid(encoder, this.ecParams);
            encoder.writeIntObj(this.ecOrderBitSize);
            ProxyMessage.writeBigInt(encoder, this.rsaModulus);
            ProxyMessage.writeBigInt(encoder, this.rsaPublicExponent);
            ProxyMessage.writeBigInt(encoder, this.dsaP);
            ProxyMessage.writeBigInt(encoder, this.dsaQ);
            ProxyMessage.writeBigInt(encoder, this.dsaG);
        }

        public static P11KeyResponse decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 9, "ModuleCapsResponse");
            try {
                PKCS11KeyId keyId = ProxyMessage.decodeKeyId(decoder);
                P11KeyResponse ret = new P11KeyResponse(keyId);
                ret.sign = decoder.readBoolean();
                ret.ecParams = ProxyMessage.readOid(decoder);
                ret.ecOrderBitSize = decoder.readIntObj();
                ret.rsaModulus = decoder.readBigInt();
                ret.rsaPublicExponent = decoder.readBigInt();
                ret.dsaP = decoder.readBigInt();
                ret.dsaQ = decoder.readBigInt();
                ret.dsaG = decoder.readBigInt();
                return ret;
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding P11KeyResponse", (Throwable)ex);
            }
        }
    }

    public static class ModuleCapsResponse
    extends ProxyMessage {
        private static final int NUM_FIELDS = 5;
        private final boolean readOnly;
        private final int maxMessageSize;
        private final P11ModuleConf.P11NewObjectConf newObjectConf;
        private final List<Long> secretKeyTypes;
        private final List<Long> keyPairTypes;

        public ModuleCapsResponse(boolean readOnly, int maxMessageSize, P11ModuleConf.P11NewObjectConf newObjectConf, List<Long> secretKeyTypes, List<Long> keyPairTypes) {
            this.readOnly = readOnly;
            this.maxMessageSize = maxMessageSize;
            this.newObjectConf = newObjectConf;
            this.secretKeyTypes = secretKeyTypes;
            this.keyPairTypes = keyPairTypes;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public int getMaxMessageSize() {
            return this.maxMessageSize;
        }

        public P11ModuleConf.P11NewObjectConf getNewObjectConf() {
            return this.newObjectConf;
        }

        public List<Long> getSecretKeyTypes() {
            return this.secretKeyTypes;
        }

        public List<Long> getKeyPairTypes() {
            return this.keyPairTypes;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(5);
            encoder.writeBoolean(this.readOnly);
            encoder.writeInt((long)this.maxMessageSize);
            if (this.newObjectConf == null) {
                encoder.writeNull();
            } else {
                encoder.writeArrayStart(2);
                encoder.writeBoolean(this.newObjectConf.isIgnoreLabel());
                encoder.writeInt((long)this.newObjectConf.getIdLength());
            }
            encoder.writeLongs(this.secretKeyTypes);
            encoder.writeLongs(this.keyPairTypes);
        }

        public static ModuleCapsResponse decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 5, "ModuleCapsResponse");
            try {
                P11ModuleConf.P11NewObjectConf newObjectConf;
                boolean readOnly = decoder.readBoolean();
                int maxMessageSize = decoder.readInt();
                if (decoder.readNullOrArrayLength(2)) {
                    newObjectConf = null;
                } else {
                    newObjectConf = new P11ModuleConf.P11NewObjectConf();
                    newObjectConf.setIgnoreLabel(decoder.readBoolean());
                    newObjectConf.setIdLength(decoder.readInt());
                }
                List secretKeyTypes = decoder.readLongList();
                List keyPairTypes = decoder.readLongList();
                return new ModuleCapsResponse(readOnly, maxMessageSize, newObjectConf, secretKeyTypes, keyPairTypes);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding ModuleCapsResponse", (Throwable)ex);
            }
        }
    }

    public static class LongMessage
    extends ProxyMessage {
        private final long value;

        public LongMessage(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeInt(this.value);
        }

        public static LongMessage decode(CborDecoder decoder) throws DecodeException {
            try {
                long b = Optional.ofNullable(decoder.readLongObj()).orElseThrow(() -> new DecodeException("LongMessage shall not be null"));
                return new LongMessage(b);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding LongMessage", (Throwable)ex);
            }
        }
    }

    public static class LongArrayMessage
    extends ProxyMessage {
        private final long[] value;

        public LongArrayMessage(long[] value) {
            this.value = value;
        }

        public long[] getValue() {
            return this.value;
        }

        @Override
        public void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeLongs(this.value);
        }

        public static LongArrayMessage decode(CborDecoder decoder) throws DecodeException {
            try {
                long[] value = Optional.ofNullable(decoder.readLongs()).orElseThrow(() -> new DecodeException("LongMessage shall not be null"));
                return new LongArrayMessage(value);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding LongArrayMessage", (Throwable)ex);
            }
        }
    }

    public static class KeyIdMessage
    extends ProxyMessage {
        private static final int NUM_FIELDS = 6;
        private final PKCS11KeyId keyId;

        public KeyIdMessage(PKCS11KeyId keyId) {
            this.keyId = keyId;
        }

        public PKCS11KeyId getKeyId() {
            return this.keyId;
        }

        @Override
        public void encode0(CborEncoder encoder) throws IOException, EncodeException {
            if (this.keyId == null) {
                encoder.writeNull();
                return;
            }
            encoder.writeArrayStart(6);
            encoder.writeInt(this.keyId.getHandle());
            encoder.writeInt(this.keyId.getKeyType());
            encoder.writeInt(this.keyId.getObjectCLass());
            encoder.writeByteString(this.keyId.getId());
            encoder.writeTextString(this.keyId.getLabel());
            encoder.writeIntObj(this.keyId.getPublicKeyHandle());
        }

        public static KeyIdMessage decode(CborDecoder decoder) throws DecodeException {
            PKCS11KeyId keyId = Optional.ofNullable(ProxyMessage.decodeKeyId(decoder)).orElseThrow(() -> new DecodeException("KeyIdMessage shall not be null"));
            return new KeyIdMessage(keyId);
        }
    }

    public static class IntMessage
    extends ProxyMessage {
        private final int value;

        public IntMessage(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeInt((long)this.value);
        }

        public static IntMessage decode(CborDecoder decoder) throws DecodeException {
            try {
                int b = Optional.ofNullable(decoder.readIntObj()).orElseThrow(() -> new DecodeException("IntMessage shall not be null"));
                return new IntMessage(b);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding IntMessage", (Throwable)ex);
            }
        }
    }

    public static class ImportSecretKeyRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 3;
        private final long keyType;
        private final byte[] keyValue;
        private final P11Slot.P11NewKeyControl newKeyControl;

        public ImportSecretKeyRequest(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl newKeyControl) {
            this.keyType = keyType;
            this.keyValue = (byte[])Args.notNull((Object)keyValue, (String)"keyValue");
            this.newKeyControl = newKeyControl;
        }

        public long getKeyType() {
            return this.keyType;
        }

        public byte[] getKeyValue() {
            return this.keyValue;
        }

        public P11Slot.P11NewKeyControl getNewKeyControl() {
            return this.newKeyControl;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(3);
            encoder.writeInt(this.keyType);
            encoder.writeByteString(this.keyValue);
            ProxyMessage.writeNewKeyControl(encoder, this.newKeyControl);
        }

        public static ImportSecretKeyRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 3, "ImportSecretKeyRequest");
            try {
                long keyType = decoder.readLong();
                byte[] keyValue = decoder.readByteString();
                P11Slot.P11NewKeyControl control = ProxyMessage.decodeNewKeyControl(decoder);
                return new ImportSecretKeyRequest(keyType, keyValue, control);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding ImportSecretKeyRequest", (Throwable)ex);
            }
        }
    }

    public static class IdLabelMessage
    extends ProxyMessage {
        private static final int NUM_FIELDS = 2;
        private final byte[] id;
        private final String label;

        public IdLabelMessage(byte[] id, String label) {
            this.id = id;
            this.label = label;
        }

        public byte[] getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(2);
            encoder.writeByteString(this.id);
            encoder.writeTextString(this.label);
        }

        public static IdLabelMessage decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 2, "IdLabelMessage");
            try {
                byte[] id = decoder.readByteString();
                String label = decoder.readTextString();
                return new IdLabelMessage(id, label);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding IdLabelMessage", (Throwable)ex);
            }
        }
    }

    public static class GetMechanismInfosResponse
    extends ProxyMessage {
        private final Map<Long, MechanismInfo> mechamismInfoMap;

        public GetMechanismInfosResponse(Map<Long, MechanismInfo> mechamismInfoMap) {
            this.mechamismInfoMap = mechamismInfoMap;
        }

        @Override
        public void encode0(CborEncoder encoder) throws IOException, EncodeException {
            encoder.writeMapStart(this.mechamismInfoMap.size());
            for (Map.Entry<Long, MechanismInfo> entry : this.mechamismInfoMap.entrySet()) {
                encoder.writeInt(entry.getKey().longValue());
                MechanismInfo mi = entry.getValue();
                if (entry.getValue() == null) {
                    encoder.writeNull();
                    continue;
                }
                encoder.writeArrayStart(3);
                encoder.writeInt(mi.getMinKeySize());
                encoder.writeInt(mi.getMaxKeySize());
                encoder.writeInt(mi.getFlags());
            }
        }

        public Map<Long, MechanismInfo> getMechamismInfoMap() {
            return this.mechamismInfoMap;
        }

        public static GetMechanismInfosResponse decode(CborDecoder decoder) throws DecodeException {
            try {
                Integer mapLen = decoder.readNullOrMapLength();
                if (mapLen == null) {
                    throw new DecodeException("GetMechanismInfosResponse shall not be null");
                }
                HashMap<Long, MechanismInfo> map = new HashMap<Long, MechanismInfo>(mapLen * 5 / 4);
                for (int i = 0; i < mapLen; ++i) {
                    long code = decoder.readLong();
                    boolean isNull = decoder.readNullOrArrayLength(3);
                    if (isNull) {
                        map.put(code, null);
                        continue;
                    }
                    long minSize = decoder.readLong();
                    long maxSize = decoder.readLong();
                    long flags = decoder.readLong();
                    map.put(code, new MechanismInfo(minSize, maxSize, flags));
                }
                return new GetMechanismInfosResponse(map);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding GetMechanismInfosResponse", (Throwable)ex);
            }
        }
    }

    public static class GenerateSM2KeyPairRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 1;
        private final P11Slot.P11NewKeyControl newKeyControl;

        public GenerateSM2KeyPairRequest(P11Slot.P11NewKeyControl newKeyControl) {
            this.newKeyControl = newKeyControl;
        }

        public P11Slot.P11NewKeyControl getNewKeyControl() {
            return this.newKeyControl;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(1);
            ProxyMessage.writeNewKeyControl(encoder, this.newKeyControl);
        }

        public static GenerateSM2KeyPairRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 1, "GenerateSM2KeyPairRequest");
            P11Slot.P11NewKeyControl control = ProxyMessage.decodeNewKeyControl(decoder);
            return new GenerateSM2KeyPairRequest(control);
        }
    }

    public static class GenerateSecretKeyRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 3;
        private final long keyType;
        private final Integer keySize;
        private final P11Slot.P11NewKeyControl newKeyControl;

        public GenerateSecretKeyRequest(long keyType, Integer keySize, P11Slot.P11NewKeyControl newKeyControl) {
            this.keyType = keyType;
            this.keySize = keySize;
            this.newKeyControl = newKeyControl;
        }

        public long getKeyType() {
            return this.keyType;
        }

        public Integer getKeySize() {
            return this.keySize;
        }

        public P11Slot.P11NewKeyControl getNewOKeyControl() {
            return this.newKeyControl;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(3);
            encoder.writeInt(this.keyType);
            encoder.writeIntObj(this.keySize);
            ProxyMessage.writeNewKeyControl(encoder, this.newKeyControl);
        }

        public static GenerateSecretKeyRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 3, "GenerateSecretKeyRequest");
            try {
                long keyType = decoder.readLong();
                Integer keySize = decoder.readIntObj();
                P11Slot.P11NewKeyControl control = ProxyMessage.decodeNewKeyControl(decoder);
                return new GenerateSecretKeyRequest(keyType, keySize, control);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding GenerateSecretKeyRequest", (Throwable)ex);
            }
        }
    }

    public static class GenerateRSAKeyPairRequest
    extends GenerateRSAKeyPairOtfRequest {
        private static final int NUM_FIELDS = 2;
        private final P11Slot.P11NewKeyControl newKeyControl;

        public GenerateRSAKeyPairRequest(int keySize, BigInteger publicExponent, P11Slot.P11NewKeyControl newKeyControl) {
            super(keySize, publicExponent);
            this.newKeyControl = newKeyControl;
        }

        public P11Slot.P11NewKeyControl getNewKeyControl() {
            return this.newKeyControl;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(2);
            encoder.writeInt((long)this.keySize);
            ProxyMessage.writeBigInt(encoder, this.publicExponent);
            ProxyMessage.writeNewKeyControl(encoder, this.newKeyControl);
        }

        public static GenerateRSAKeyPairRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 2, "GenerateRSAKeyPairRequest");
            try {
                int keysize = decoder.readInt();
                BigInteger publicExponent = decoder.readBigInt();
                P11Slot.P11NewKeyControl control = ProxyMessage.decodeNewKeyControl(decoder);
                return new GenerateRSAKeyPairRequest(keysize, publicExponent, control);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding GenerateRSAKeyPairRequest", (Throwable)ex);
            }
        }
    }

    public static class GenerateRSAKeyPairOtfRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 2;
        protected final int keySize;
        protected final BigInteger publicExponent;

        public GenerateRSAKeyPairOtfRequest(int keySize, BigInteger publicExponent) {
            this.keySize = keySize;
            this.publicExponent = publicExponent;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(2);
            encoder.writeInt((long)this.keySize);
            encoder.writeByteString(this.publicExponent == null ? null : this.publicExponent.toByteArray());
        }

        public static GenerateRSAKeyPairOtfRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 2, "GenerateRSAKeyPairOtfRequest");
            try {
                int keysize = decoder.readInt();
                BigInteger publicExponent = decoder.readBigInt();
                return new GenerateRSAKeyPairOtfRequest(keysize, publicExponent);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding GenerateRSAKeyPairOtfRequest", (Throwable)ex);
            }
        }
    }

    public static class GenerateECKeyPairRequest
    extends GenerateECKeyPairOtfRequest {
        private static final int NUM_FIELDS = 2;
        private final P11Slot.P11NewKeyControl newKeyControl;

        public GenerateECKeyPairRequest(ASN1ObjectIdentifier curveOid, P11Slot.P11NewKeyControl newKeyControl) {
            super(curveOid);
            this.newKeyControl = newKeyControl;
        }

        public P11Slot.P11NewKeyControl getNewKeyControl() {
            return this.newKeyControl;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(2);
            ProxyMessage.writeOid(encoder, this.curveOid);
            ProxyMessage.writeNewKeyControl(encoder, this.newKeyControl);
        }

        public static GenerateECKeyPairRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 2, "GenerateECKeyPairRequest");
            try {
                ASN1ObjectIdentifier curveOid = ProxyMessage.readOid(decoder);
                P11Slot.P11NewKeyControl control = ProxyMessage.decodeNewKeyControl(decoder);
                return new GenerateECKeyPairRequest(curveOid, control);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding GenerateECKeyPairRequest", (Throwable)ex);
            }
        }
    }

    public static class GenerateECKeyPairOtfRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 1;
        protected final ASN1ObjectIdentifier curveOid;

        public GenerateECKeyPairOtfRequest(ASN1ObjectIdentifier curveOid) {
            this.curveOid = (ASN1ObjectIdentifier)Args.notNull((Object)curveOid, (String)"curveOid");
        }

        public ASN1ObjectIdentifier getCurveOid() {
            return this.curveOid;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(1);
            ProxyMessage.writeOid(encoder, this.curveOid);
        }

        public static GenerateECKeyPairOtfRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 1, "GenerateECKeyPairOtfRequest");
            try {
                ASN1ObjectIdentifier curveOid = ProxyMessage.readOid(decoder);
                return new GenerateECKeyPairOtfRequest(curveOid);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding GenerateECKeyPairOtfRequest", (Throwable)ex);
            }
        }
    }

    public static class GenerateDSAKeyPairRequest
    extends GenerateDSAKeyPairOtfRequest {
        private static final int NUM_FIELDS = 4;
        private final P11Slot.P11NewKeyControl newKeyControl;

        public GenerateDSAKeyPairRequest(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl newKeyControl) {
            super(p, q, g);
            this.newKeyControl = newKeyControl;
        }

        public P11Slot.P11NewKeyControl getNewKeyControl() {
            return this.newKeyControl;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(4);
            encoder.writeByteString(this.p.toByteArray());
            encoder.writeByteString(this.q.toByteArray());
            encoder.writeByteString(this.g.toByteArray());
            ProxyMessage.writeNewKeyControl(encoder, this.newKeyControl);
        }

        public static GenerateDSAKeyPairRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 4, "GenerateDSAKeyPairRequest");
            try {
                BigInteger p = decoder.readBigInt();
                BigInteger q = decoder.readBigInt();
                BigInteger g = decoder.readBigInt();
                P11Slot.P11NewKeyControl control = ProxyMessage.decodeNewKeyControl(decoder);
                return new GenerateDSAKeyPairRequest(p, q, g, control);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding GenerateDSAKeyPairRequest", (Throwable)ex);
            }
        }
    }

    public static class GenerateDSAKeyPairOtfRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 3;
        protected final BigInteger p;
        protected final BigInteger q;
        protected final BigInteger g;

        public GenerateDSAKeyPairOtfRequest(BigInteger p, BigInteger q, BigInteger g) {
            this.p = (BigInteger)Args.notNull((Object)p, (String)"p");
            this.q = (BigInteger)Args.notNull((Object)q, (String)"q");
            this.g = (BigInteger)Args.notNull((Object)g, (String)"g");
        }

        public BigInteger getP() {
            return this.p;
        }

        public BigInteger getQ() {
            return this.q;
        }

        public BigInteger getG() {
            return this.g;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(3);
            encoder.writeByteString(this.p.toByteArray());
            encoder.writeByteString(this.q.toByteArray());
            encoder.writeByteString(this.g.toByteArray());
        }

        public static GenerateDSAKeyPairOtfRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 3, "GenerateDSAKeyPairOtfRequest");
            try {
                BigInteger p = decoder.readBigInt();
                BigInteger q = decoder.readBigInt();
                BigInteger g = decoder.readBigInt();
                return new GenerateDSAKeyPairOtfRequest(p, q, g);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding GenerateDSAKeyPairOtfRequest", (Throwable)ex);
            }
        }
    }

    public static class GenerateDSAKeyPairByKeysizeRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 3;
        private final int plength;
        private final int qlength;
        private final P11Slot.P11NewKeyControl newKeyControl;

        public GenerateDSAKeyPairByKeysizeRequest(int plength, int qlength, P11Slot.P11NewKeyControl newKeyControl) {
            this.plength = plength;
            this.qlength = qlength;
            this.newKeyControl = newKeyControl;
        }

        public int getPlength() {
            return this.plength;
        }

        public int getQlength() {
            return this.qlength;
        }

        public P11Slot.P11NewKeyControl getNewKeyControl() {
            return this.newKeyControl;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(3);
            encoder.writeInt((long)this.plength);
            encoder.writeInt((long)this.qlength);
            ProxyMessage.writeNewKeyControl(encoder, this.newKeyControl);
        }

        public static GenerateDSAKeyPairByKeysizeRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 3, "GenerateDSAKeyPairByKeysizeRequest");
            try {
                int plength = decoder.readInt();
                int qlength = decoder.readInt();
                P11Slot.P11NewKeyControl control = ProxyMessage.decodeNewKeyControl(decoder);
                return new GenerateDSAKeyPairByKeysizeRequest(plength, qlength, control);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding GenerateDSAKeyPairByKeysizeRequest", (Throwable)ex);
            }
        }
    }

    public static class ErrorResponse
    extends ProxyMessage {
        public static final long CBOR_TAG_ERROR_RESPONSE = 524288L;
        private static final int NUM_FIELDS = 2;
        private final ProxyErrorCode errorCode;
        private final String detail;

        public ErrorResponse(ProxyErrorCode errorCode, String detail) {
            this.errorCode = errorCode;
            this.detail = detail;
        }

        public ErrorResponse(Throwable t) {
            if (t instanceof PKCS11Exception) {
                this.errorCode = ProxyErrorCode.pkcs11Exception;
                this.detail = Long.toString(((PKCS11Exception)t).getErrorCode());
            } else if (t instanceof TokenException) {
                this.errorCode = ProxyErrorCode.tokenException;
                this.detail = t.getMessage();
            } else {
                this.errorCode = ProxyErrorCode.tokenException;
                this.detail = t.getMessage();
            }
        }

        public ProxyErrorCode getErrorCode() {
            return this.errorCode;
        }

        public String getDetail() {
            return this.detail;
        }

        @Override
        public void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(2);
            encoder.writeInt((long)this.errorCode.code);
            encoder.writeTextString(this.detail);
        }

        public static ErrorResponse decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 2, "ErrorResponnse");
            try {
                int code = decoder.readInt();
                ProxyErrorCode errorCode = Optional.ofNullable(ProxyErrorCode.ofCode(code)).orElseThrow(() -> new DecodeException("unknown error code " + code));
                String detail = decoder.readTextString();
                return new ErrorResponse(errorCode, detail);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding ErrorResponse", (Throwable)ex);
            }
        }
    }

    public static enum ProxyErrorCode {
        internalError(1),
        badRequest(2),
        tokenException(3),
        pkcs11Exception(4);

        private final int code;

        private ProxyErrorCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ProxyErrorCode ofCode(int code) {
            for (ProxyErrorCode m : ProxyErrorCode.values()) {
                if (m.code != code) continue;
                return m;
            }
            return null;
        }
    }

    public static class DigestSecretKeyRequest
    extends ProxyMessage {
        private static final int NUM_FIELDS = 2;
        private final long mechanism;
        private final long objectHandle;

        public DigestSecretKeyRequest(long mechanism, long objectHandle) {
            this.mechanism = mechanism;
            this.objectHandle = objectHandle;
        }

        public long getMechanism() {
            return this.mechanism;
        }

        public long getObjectHandle() {
            return this.objectHandle;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException {
            encoder.writeArrayStart(2);
            encoder.writeInt(this.mechanism);
            encoder.writeInt(this.objectHandle);
        }

        public static DigestSecretKeyRequest decode(CborDecoder decoder) throws DecodeException {
            ProxyMessage.assertArraySize(decoder, 2, "DigestSecretKeyRequest");
            try {
                long mechanism = decoder.readLong();
                long objectHandle = decoder.readLong();
                return new DigestSecretKeyRequest(mechanism, objectHandle);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding DigestSecretKeyRequest", (Throwable)ex);
            }
        }
    }

    public static class ByteArrayMessage
    extends ProxyMessage {
        private final byte[] value;

        public ByteArrayMessage(byte[] value) {
            this.value = (byte[])Args.notNull((Object)value, (String)"value");
        }

        public byte[] getValue() {
            return this.value;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException {
            encoder.writeByteString(this.value);
        }

        public static ByteArrayMessage decode(CborDecoder decoder) throws DecodeException {
            try {
                byte[] b = Optional.ofNullable(decoder.readByteString()).orElseThrow(() -> new DecodeException("ByteArrayMessage shall not be null"));
                return new ByteArrayMessage(b);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding ByteArrayMessage", (Throwable)ex);
            }
        }
    }

    public static class BooleanMessage
    extends ProxyMessage {
        private final boolean value;

        public BooleanMessage(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeBoolean(this.value);
        }

        public static BooleanMessage decode(CborDecoder decoder) throws DecodeException {
            try {
                boolean b = Optional.ofNullable(decoder.readBooleanObj()).orElseThrow(() -> new DecodeException("BooleanMessage shall not be null"));
                return new BooleanMessage(b);
            }
            catch (IOException ex) {
                throw new DecodeException("IO error decoding BooleanMessage", (Throwable)ex);
            }
        }
    }
}

