/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.qa;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.EdECConstants;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.pkcs12.KeyStoreWrapper;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.BenchmarkExecutor;
import org.xipki.util.ConfPairs;
import org.xipki.util.IoUtil;
import org.xipki.util.RandomUtil;

public abstract class P12SignSpeed
extends BenchmarkExecutor {
    protected static final String PASSWORD = "1234";
    private static final Logger LOG = LoggerFactory.getLogger(P12SignSpeed.class);
    private final ConcurrentContentSigner signer;

    public P12SignSpeed(SecurityFactory securityFactory, String signatureAlgorithm, byte[] keystore, String description, int threads) throws Exception {
        this("PKCS12", securityFactory, signatureAlgorithm, keystore, description, threads);
    }

    public P12SignSpeed(String tokenType, SecurityFactory securityFactory, String signatureAlgorithm, byte[] keystore, String description, int threads) throws Exception {
        super(description);
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        SignerConf signerConf = P12SignSpeed.getKeystoreSignerConf((byte[])Args.notNull((Object)keystore, (String)"keystore"), PASSWORD, Args.notBlank((String)signatureAlgorithm, (String)"signatureAlgorithm"), threads + Math.max(2, threads * 5 / 4));
        this.signer = securityFactory.createSigner(tokenType, signerConf, (X509Cert)null);
    }

    protected Runnable getTester() throws Exception {
        return new Tester();
    }

    protected static byte[] getPrecomputedRSAKeystore(int keysize, BigInteger publicExponent) throws IOException {
        return P12SignSpeed.getPrecomputedKeystore("rsa-" + keysize + "-0x" + publicExponent.toString(16) + ".p12");
    }

    protected static byte[] getPrecomputedDSAKeystore(int plength, int qlength) throws IOException {
        return P12SignSpeed.getPrecomputedKeystore("dsa-" + plength + "-" + qlength + ".p12");
    }

    protected static byte[] getPrecomputedECKeystore(ASN1ObjectIdentifier curveOid) throws IOException {
        return P12SignSpeed.getPrecomputedKeystore("ec-" + curveOid.getId() + ".p12");
    }

    private static byte[] getPrecomputedKeystore(String filename) throws IOException {
        InputStream in = P12SignSpeed.class.getResourceAsStream("/testkeys/" + filename);
        return in == null ? null : IoUtil.readAllBytesAndClose((InputStream)in);
    }

    private static SignerConf getKeystoreSignerConf(byte[] keystoreBytes, String password, String signatureAlgorithm, int parallelism) {
        ConfPairs conf = new ConfPairs("password", password).putPair("algo", signatureAlgorithm).putPair("parallelism", Integer.toString(parallelism)).putPair("keystore", "base64:" + Base64.encodeToString((byte[])keystoreBytes));
        return new SignerConf(conf);
    }

    private class Tester
    implements Runnable {
        private static final int batch = 16;
        private final byte[][] data = new byte[16][16];

        public Tester() {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = RandomUtil.nextBytes((int)this.data[i].length);
            }
        }

        @Override
        public void run() {
            while (!P12SignSpeed.this.stop() && P12SignSpeed.this.getErrorAccount() < 1L) {
                try {
                    P12SignSpeed.this.signer.sign(this.data);
                    P12SignSpeed.this.account(16L, 0L);
                }
                catch (Exception ex) {
                    LOG.error("P12SignSpeed.Tester.run()", (Throwable)ex);
                    P12SignSpeed.this.account(16L, 16L);
                }
            }
        }
    }

    public static class SM2
    extends P12SignSpeed {
        public SM2(SecurityFactory securityFactory, int threads) throws Exception {
            super(securityFactory, "SM3WITHSM2", SM2.generateKeystore(GMObjectIdentifiers.sm2p256v1), "PKCS#12 SM2 signature creation", threads);
        }

        private static byte[] generateKeystore(ASN1ObjectIdentifier curveNOid) throws Exception {
            byte[] keystoreBytes = SM2.getPrecomputedECKeystore(curveNOid);
            if (keystoreBytes == null) {
                KeystoreGenerationParameters params = new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray());
                params.setRandom(new SecureRandom());
                new P12KeyGenerator();
                KeyStoreWrapper identity = P12KeyGenerator.generateECKeypair(curveNOid, params, null);
                keystoreBytes = identity.keystore();
            }
            return keystoreBytes;
        }
    }

    public static class RSA
    extends P12SignSpeed {
        public RSA(SecurityFactory securityFactory, String signatureAlgorithm, int threads, int keysize, BigInteger publicExponent) throws Exception {
            super(securityFactory, signatureAlgorithm, RSA.generateKeystore(keysize, publicExponent), "PKCS#12 RSA signature creation\nkeysize: " + keysize + "\npublic exponent: " + publicExponent, threads);
        }

        private static byte[] generateKeystore(int keysize, BigInteger publicExponent) throws Exception {
            byte[] keystoreBytes = RSA.getPrecomputedRSAKeystore(keysize, publicExponent);
            if (keystoreBytes == null) {
                KeystoreGenerationParameters params = new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray());
                params.setRandom(new SecureRandom());
                new P12KeyGenerator();
                KeyStoreWrapper identity = P12KeyGenerator.generateRSAKeypair(keysize, publicExponent, params, null);
                keystoreBytes = identity.keystore();
            }
            return keystoreBytes;
        }
    }

    public static class HMAC
    extends P12SignSpeed {
        public HMAC(SecurityFactory securityFactory, String signatureAlgorithm, int threads) throws Exception {
            super("JCEKS", securityFactory, signatureAlgorithm, HMAC.generateKeystore(signatureAlgorithm), "JCEKS HMAC signature creation", threads);
        }

        private static byte[] generateKeystore(String signatureAlgorithm) throws Exception {
            int keysize = HMAC.getKeysize(signatureAlgorithm);
            new P12KeyGenerator();
            KeyStoreWrapper identity = P12KeyGenerator.generateSecretKey("GENERIC", keysize, new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray()));
            return identity.keystore();
        }

        private static int getKeysize(String hmacAlgorithm) {
            int keysize;
            switch (hmacAlgorithm = hmacAlgorithm.toUpperCase()) {
                case "HMACSHA1": {
                    keysize = 160;
                    break;
                }
                case "HMACSHA224": 
                case "HMACSHA3-224": {
                    keysize = 224;
                    break;
                }
                case "HMACSHA256": 
                case "HMACSHA3-256": {
                    keysize = 256;
                    break;
                }
                case "HMACSHA384": 
                case "HMACSHA3-384": {
                    keysize = 384;
                    break;
                }
                case "HMACSHA512": 
                case "HMACSHA3-512": {
                    keysize = 512;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown HMAC algorithm " + hmacAlgorithm);
                }
            }
            return keysize;
        }
    }

    public static class EC
    extends P12SignSpeed {
        public EC(SecurityFactory securityFactory, String signatureAlgorithm, int threads, ASN1ObjectIdentifier curveOid) throws Exception {
            super(securityFactory, signatureAlgorithm, EC.generateKeystore(curveOid), "PKCS#12 EC signature creation\ncurve: " + AlgorithmUtil.getCurveName(curveOid), threads);
        }

        private static byte[] generateKeystore(ASN1ObjectIdentifier curveOid) throws Exception {
            byte[] keystoreBytes = EC.getPrecomputedECKeystore(curveOid);
            if (keystoreBytes == null) {
                KeyStoreWrapper keyStoreWrapper;
                KeystoreGenerationParameters params = new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray());
                params.setRandom(new SecureRandom());
                if (EdECConstants.isEdwardsOrMontgomeryCurve(curveOid)) {
                    new P12KeyGenerator();
                    keyStoreWrapper = P12KeyGenerator.generateEdECKeypair(curveOid, params, null);
                } else {
                    new P12KeyGenerator();
                    keyStoreWrapper = P12KeyGenerator.generateECKeypair(curveOid, params, null);
                }
                KeyStoreWrapper identity = keyStoreWrapper;
                keystoreBytes = identity.keystore();
            }
            return keystoreBytes;
        }
    }

    public static class DSA
    extends P12SignSpeed {
        public DSA(SecurityFactory securityFactory, String signatureAlgorithm, int threads, int plength, int qlength) throws Exception {
            super(securityFactory, signatureAlgorithm, DSA.generateKeystore(plength, qlength), "PKCS#12 DSA signature creation\nplength: " + plength + "\nqlength: " + qlength, threads);
        }

        private static byte[] generateKeystore(int plength, int qlength) throws Exception {
            byte[] keystoreBytes = DSA.getPrecomputedDSAKeystore(plength, qlength);
            if (keystoreBytes == null) {
                KeystoreGenerationParameters params = new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray());
                params.setRandom(new SecureRandom());
                new P12KeyGenerator();
                KeyStoreWrapper identity = P12KeyGenerator.generateDSAKeypair(plength, qlength, params, null);
                keystoreBytes = identity.keystore();
            }
            return keystoreBytes;
        }
    }

    public static class AESGmac
    extends P12SignSpeed {
        public AESGmac(SecurityFactory securityFactory, String signatureAlgorithm, int threads) throws Exception {
            super("JCEKS", securityFactory, signatureAlgorithm, AESGmac.generateKeystore(signatureAlgorithm), "JCEKS AES-GMAC signature creation", threads);
        }

        private static byte[] generateKeystore(String signatureAlgorithm) throws Exception {
            int keysize = AESGmac.getKeysize(signatureAlgorithm);
            new P12KeyGenerator();
            KeyStoreWrapper identity = P12KeyGenerator.generateSecretKey("AES", keysize, new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray()));
            return identity.keystore();
        }

        public static int getKeysize(String hmacAlgorithm) {
            int keysize;
            switch (hmacAlgorithm = hmacAlgorithm.toUpperCase()) {
                case "AES128-GMAC": {
                    keysize = 128;
                    break;
                }
                case "AES192-GMAC": {
                    keysize = 192;
                    break;
                }
                case "AES256-GMAC": {
                    keysize = 256;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown GMAC algorithm " + hmacAlgorithm);
                }
            }
            return keysize;
        }
    }
}

