/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.ca.api.mgmt.CaJson;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.MgmtEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

public class CaConf {
    private static final Logger LOG = LoggerFactory.getLogger(CaConf.class);
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, String> dbSchemas = new HashMap<String, String>();
    private final Map<String, SignerEntry> signers = new HashMap<String, SignerEntry>();
    private final Map<String, RequestorEntry> requestors = new HashMap<String, RequestorEntry>();
    private final Map<String, PublisherEntry> publishers = new HashMap<String, PublisherEntry>();
    private final Map<String, CertprofileEntry> certprofiles = new HashMap<String, CertprofileEntry>();
    private final Map<String, KeypairGenEntry> keypairgens = new HashMap<String, KeypairGenEntry>();
    private final Map<String, SingleCa> cas = new HashMap<String, SingleCa>();

    public CaConf(File confFile, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException {
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        confFile = IoUtil.expandFilepath((File)((File)Args.notNull((Object)confFile, (String)"confFile")), (boolean)true);
        this.init(Files.newInputStream(confFile.toPath(), new OpenOption[0]), securityFactory);
    }

    public CaConf(InputStream confFileZipStream, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException {
        Args.notNull((Object)confFileZipStream, (String)"confFileZipStream");
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.init(confFileZipStream, securityFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream zipFileStream, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException {
        ZipInputStream zipStream = new ZipInputStream(zipFileStream);
        try {
            ZipEntry zipEntry;
            HashMap<String, byte[]> zipEntries = new HashMap<String, byte[]>();
            while ((zipEntry = zipStream.getNextEntry()) != null) {
                byte[] zipEntryBytes = CaConf.read(zipStream);
                zipEntries.put(zipEntry.getName(), zipEntryBytes);
            }
            CaConfType.CaSystem root = CaJson.parseObject((byte[])zipEntries.get("caconf.json"), CaConfType.CaSystem.class);
            root.validate();
            this.init0(root, zipEntries, securityFactory);
        }
        finally {
            try {
                zipFileStream.close();
            }
            catch (IOException ex) {
                LOG.info("could not close zipFileStream: {}", (Object)ex.getMessage());
            }
            try {
                zipStream.close();
            }
            catch (IOException ex) {
                LOG.info("could not close zipStream: {}", (Object)ex.getMessage());
            }
        }
    }

    private void init0(CaConfType.CaSystem root, Map<String, byte[]> zipEntries, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException {
        MgmtEntry en;
        if (root.getProperties() != null) {
            this.properties.putAll(root.getProperties());
        }
        if (root.getDbSchemas() != null) {
            this.dbSchemas.putAll(root.getDbSchemas());
        }
        if (root.getSigners() != null) {
            for (CaConfType.Signer signer : root.getSigners()) {
                en = new SignerEntry(signer.getName(), this.expandConf(signer.getType()), this.getValue(signer.getConf(), zipEntries), this.getBase64Binary(signer.getCert(), zipEntries));
                this.addSigner((SignerEntry)en);
            }
        }
        if (root.getRequestors() != null) {
            for (CaConfType.Requestor requestor : root.getRequestors()) {
                String conf;
                if (requestor.getConf() != null) {
                    conf = this.getValue(requestor.getConf(), zipEntries);
                } else if ("cert".equalsIgnoreCase(requestor.getType())) {
                    byte[] binary = this.getBinary(requestor.getBinaryConf(), zipEntries);
                    if (binary == null) {
                        conf = null;
                    } else {
                        binary = X509Util.toDerEncoded((byte[])binary);
                        conf = Base64.encodeToString((byte[])binary);
                    }
                } else {
                    conf = this.getBase64Binary(requestor.getBinaryConf(), zipEntries);
                }
                RequestorEntry en2 = new RequestorEntry(new NameId(null, requestor.getName()), requestor.getType(), conf);
                this.addRequestor(en2);
            }
        }
        if (root.getPublishers() != null) {
            for (CaConfType.NameTypeConf nameTypeConf : root.getPublishers()) {
                en = new PublisherEntry(new NameId(null, nameTypeConf.getName()), this.expandConf(nameTypeConf.getType()), this.getValue(nameTypeConf.getConf(), zipEntries));
                this.addPublisher((PublisherEntry)en);
            }
        }
        if (root.getProfiles() != null) {
            for (CaConfType.NameTypeConf nameTypeConf : root.getProfiles()) {
                en = new CertprofileEntry(new NameId(null, nameTypeConf.getName()), this.expandConf(nameTypeConf.getType()), this.getValue(nameTypeConf.getConf(), zipEntries));
                this.addProfile((CertprofileEntry)en);
            }
        }
        if (root.getKeypairGens() != null) {
            for (CaConfType.NameTypeConf nameTypeConf : root.getKeypairGens()) {
                en = new KeypairGenEntry(nameTypeConf.getName(), nameTypeConf.getType(), this.getValue(nameTypeConf.getConf(), zipEntries));
                this.addKeypairGen((KeypairGenEntry)en);
            }
        }
        if (root.getCas() != null) {
            for (CaConfType.Ca ca : root.getCas()) {
                String name = ca.getName();
                GenSelfIssued genSelfIssued = null;
                CaEntry caEntry = null;
                if (ca.getCaInfo() != null) {
                    CaConfType.CaInfo ci = ca.getCaInfo();
                    Object gsi = ci.getGenSelfIssued();
                    if (gsi != null) {
                        if (ci.getCert() != null) {
                            throw new InvalidConfException("cert.file of CA " + name + " may not be set");
                        }
                        Instant notBefore = gsi.getNotBefore() == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)gsi.getNotBefore());
                        Instant notAfter = gsi.getNotAfter() == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)gsi.getNotAfter());
                        genSelfIssued = new GenSelfIssued(gsi.getProfile(), gsi.getSubject(), gsi.getSerialNumber(), notBefore, notAfter);
                    }
                    caEntry = new CaEntry(new NameId(null, name));
                    ci.copyBaseInfoTo(caEntry);
                    caEntry.setSignerType(this.expandConf(caEntry.getSignerType()));
                    caEntry.setSignerConf(this.getValue(ci.getSignerConf(), zipEntries));
                    if (ci.getGenSelfIssued() == null) {
                        X509Cert caCert;
                        if (ci.getCert() != null) {
                            byte[] bytes = this.getBinary(ci.getCert(), zipEntries);
                            try {
                                caCert = X509Util.parseCert((byte[])bytes);
                            }
                            catch (CertificateException ex) {
                                throw new InvalidConfException("invalid certificate of CA " + name, (Throwable)ex);
                            }
                        }
                        try {
                            List<CaEntry.CaSignerConf> signerConfs = CaEntry.splitCaSignerConfs(this.getValue(ci.getSignerConf(), zipEntries));
                            SignerConf signerConf = new SignerConf(signerConfs.get(0).getConf());
                            try (ConcurrentContentSigner signer = securityFactory.createSigner(this.expandConf(ci.getSignerType()), signerConf, (X509Cert)null);){
                                caCert = signer.getCertificate();
                            }
                        }
                        catch (IOException | XiSecurityException | ObjectCreationException ex) {
                            throw new InvalidConfException("could not create CA signer for CA " + name, ex);
                        }
                        caEntry.setCert(caCert);
                        if (CollectionUtil.isNotEmpty(ci.getCertchain())) {
                            LinkedList<X509Cert> certchain = new LinkedList<X509Cert>();
                            for (FileOrBinary cc : ci.getCertchain()) {
                                byte[] bytes = this.getBinary(cc, zipEntries);
                                try {
                                    certchain.add(X509Util.parseCert((byte[])bytes));
                                }
                                catch (CertificateException ex) {
                                    throw new InvalidConfException("invalid certchain for CA " + name, (Throwable)ex);
                                }
                            }
                            caEntry.setCertchain(certchain);
                        }
                    }
                }
                LinkedList<CaHasRequestorEntry> caHasRequestors = null;
                if (ca.getRequestors() != null) {
                    caHasRequestors = new LinkedList<CaHasRequestorEntry>();
                    for (CaConfType.CaHasRequestor req : ca.getRequestors()) {
                        CaHasRequestorEntry en3 = new CaHasRequestorEntry(new NameId(null, req.getRequestorName()));
                        if (req.getProfiles() != null && !req.getProfiles().isEmpty()) {
                            en3.setProfiles(new HashSet<String>(req.getProfiles()));
                        }
                        en3.setPermissions(req.getPermissions());
                        caHasRequestors.add(en3);
                    }
                }
                List<String> aliases = null;
                if (ca.getAliases() != null && !ca.getAliases().isEmpty()) {
                    aliases = ca.getAliases();
                }
                List<String> profileNames = null;
                if (ca.getProfiles() != null && !ca.getProfiles().isEmpty()) {
                    profileNames = ca.getProfiles();
                }
                List<String> publisherNames = null;
                if (ca.getPublishers() != null && !ca.getPublishers().isEmpty()) {
                    publisherNames = ca.getPublishers();
                }
                SingleCa singleCa = new SingleCa(name, genSelfIssued, caEntry, aliases, profileNames, caHasRequestors, publisherNames);
                this.addSingleCa(singleCa);
            }
        }
    }

    public void addSigner(SignerEntry signer) {
        Args.notNull((Object)((Object)signer), (String)"signer");
        this.signers.put(signer.getName(), signer);
    }

    public Set<String> getSignerNames() {
        return Collections.unmodifiableSet(this.signers.keySet());
    }

    public SignerEntry getSigner(String name) {
        return this.signers.get(Args.notNull((Object)name, (String)"name"));
    }

    public void addRequestor(RequestorEntry requestor) {
        Args.notNull((Object)((Object)requestor), (String)"requestor");
        this.requestors.put(requestor.getIdent().getName(), requestor);
    }

    public Set<String> getRequestorNames() {
        return Collections.unmodifiableSet(this.requestors.keySet());
    }

    public RequestorEntry getRequestor(String name) {
        return this.requestors.get(Args.notNull((Object)name, (String)"name"));
    }

    public void addPublisher(PublisherEntry publisher) {
        Args.notNull((Object)((Object)publisher), (String)"publisher");
        this.publishers.put(publisher.getIdent().getName(), publisher);
    }

    public Set<String> getPublisherNames() {
        return Collections.unmodifiableSet(this.publishers.keySet());
    }

    public PublisherEntry getPublisher(String name) {
        return this.publishers.get(Args.notNull((Object)name, (String)"name"));
    }

    public void addProfile(CertprofileEntry profile) {
        Args.notNull((Object)((Object)profile), (String)"profile");
        this.certprofiles.put(profile.getIdent().getName(), profile);
    }

    public Set<String> getCertprofileNames() {
        return Collections.unmodifiableSet(this.certprofiles.keySet());
    }

    public CertprofileEntry getCertprofile(String name) {
        return this.certprofiles.get(Args.notNull((Object)name, (String)"name"));
    }

    public void addKeypairGen(KeypairGenEntry keypairgen) {
        Args.notNull((Object)((Object)keypairgen), (String)"keypairgen");
        this.keypairgens.put(keypairgen.getName(), keypairgen);
    }

    public Set<String> getKeypairGenNames() {
        return Collections.unmodifiableSet(this.keypairgens.keySet());
    }

    public KeypairGenEntry getKeypairGen(String name) {
        return this.keypairgens.get(Args.notNull((Object)name, (String)"name"));
    }

    public void addSingleCa(SingleCa singleCa) {
        Args.notNull((Object)singleCa, (String)"singleCa");
        this.cas.put(singleCa.getName(), singleCa);
    }

    public Set<String> getDbSchemaNames() {
        return Collections.unmodifiableSet(this.dbSchemas.keySet());
    }

    public String getDbSchema(String name) {
        return this.dbSchemas.get(name);
    }

    public Set<String> getCaNames() {
        return Collections.unmodifiableSet(this.cas.keySet());
    }

    public SingleCa getCa(String name) {
        return this.cas.get(Args.notNull((Object)name, (String)"name"));
    }

    private String getValue(FileOrValue fileOrValue, Map<String, byte[]> zipEntries) throws IOException {
        if (fileOrValue == null) {
            return null;
        }
        if (fileOrValue.getValue() != null) {
            return this.expandConf(fileOrValue.getValue());
        }
        String fileName = fileOrValue.getFile();
        byte[] binary = zipEntries.get(fileName);
        if (binary == null) {
            throw new IOException("could not find ZIP entry " + fileName);
        }
        return this.expandConf(StringUtil.toUtf8String((byte[])binary));
    }

    private String getBase64Binary(FileOrBinary fileOrBinary, Map<String, byte[]> zipEntries) throws IOException {
        byte[] binary = this.getBinary(fileOrBinary, zipEntries);
        return binary == null ? null : Base64.encodeToString((byte[])binary);
    }

    private static byte[] read(InputStream in) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            int readed;
            byte[] buffer = new byte[2048];
            while ((readed = in.read(buffer)) != -1) {
                bout.write(buffer, 0, readed);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
    }

    private byte[] getBinary(FileOrBinary fileOrBinary, Map<String, byte[]> zipEntries) throws IOException {
        if (fileOrBinary == null) {
            return null;
        }
        if (fileOrBinary.getBinary() != null) {
            return fileOrBinary.getBinary();
        }
        String fileName = fileOrBinary.getFile();
        byte[] binary = zipEntries.get(fileName);
        if (binary == null) {
            throw new IOException("could not find ZIP entry " + fileName);
        }
        return binary;
    }

    private String expandConf(String confStr) {
        if (confStr == null || !confStr.contains("${") || confStr.indexOf(125) == -1) {
            return confStr;
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String name = entry.getKey();
            String placeHolder = "${" + name + "}";
            while (confStr.contains(placeHolder)) {
                confStr = confStr.replace(placeHolder, entry.getValue());
            }
        }
        return confStr;
    }

    public static class SingleCa {
        private final String name;
        private final GenSelfIssued genSelfIssued;
        private final CaEntry caEntry;
        private final List<String> aliases;
        private final List<String> profileNames;
        private final List<CaHasRequestorEntry> requestors;
        private final List<String> publisherNames;

        public SingleCa(String name, GenSelfIssued genSelfIssued, CaEntry caEntry, List<String> aliases, List<String> profileNames, List<CaHasRequestorEntry> requestors, List<String> publisherNames) {
            this.name = Args.notBlank((String)name, (String)"name");
            if (genSelfIssued != null) {
                if (caEntry == null) {
                    throw new IllegalArgumentException("caEntry may not be null if genSelfIssued is non-null");
                }
                if (caEntry.getCert() != null) {
                    throw new IllegalArgumentException("caEntry.cert may not be null if genSelfIssued is non-null");
                }
            }
            this.genSelfIssued = genSelfIssued;
            this.caEntry = caEntry;
            this.aliases = aliases;
            this.profileNames = profileNames;
            this.requestors = requestors;
            this.publisherNames = publisherNames;
        }

        public String getName() {
            return this.name;
        }

        public CaEntry getCaEntry() {
            return this.caEntry;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public GenSelfIssued getGenSelfIssued() {
            return this.genSelfIssued;
        }

        public List<String> getProfileNames() {
            return this.profileNames;
        }

        public List<CaHasRequestorEntry> getRequestors() {
            return this.requestors;
        }

        public List<String> getPublisherNames() {
            return this.publisherNames;
        }
    }

    public static class GenSelfIssued {
        private final String profile;
        private final String subject;
        private final String serialNumber;
        private final Instant notBefore;
        private final Instant notAfter;

        public GenSelfIssued(String profile, String subject, String serialNumber, Instant notBefore, Instant notAfter) {
            this.profile = Args.notBlank((String)profile, (String)"profile");
            this.subject = Args.notBlank((String)subject, (String)"subject");
            this.serialNumber = serialNumber;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public Instant getNotBefore() {
            return this.notBefore;
        }

        public Instant getNotAfter() {
            return this.notAfter;
        }
    }
}

