/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xipki.ca.api.mgmt.CaConfs;
import org.xipki.ca.api.mgmt.Permissions;
import org.xipki.ca.api.mgmt.entry.BaseCaInfo;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.StringUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class CaConfType {

    public static class Signer
    extends NameTypeConf {
        private FileOrBinary cert;

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Signer.validate((ValidableConf)this.cert, (ValidableConf[])new ValidableConf[0]);
        }
    }

    public static class Requestor
    extends IdNameConf {
        private String type;
        private FileOrValue conf;
        private FileOrBinary binaryConf;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public FileOrBinary getBinaryConf() {
            return this.binaryConf;
        }

        public void setBinaryConf(FileOrBinary binaryConf) {
            this.binaryConf = binaryConf;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Requestor.notBlank((String)this.type, (String)"type");
            this.exactOne(this.conf, "conf", this.binaryConf, "binaryConf");
            Requestor.validate((ValidableConf)this.conf, (ValidableConf[])new ValidableConf[]{this.binaryConf});
        }
    }

    public static class NameTypeConf
    extends IdNameConf {
        private String type;
        private FileOrValue conf;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            NameTypeConf.notBlank((String)this.type, (String)"type");
            NameTypeConf.validate((ValidableConf)this.conf, (ValidableConf[])new ValidableConf[0]);
        }
    }

    public static class GenSelfIssued
    extends ValidableConf {
        private String subject;
        private String profile;
        private String serialNumber;
        private String notBefore;
        private String notAfter;

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getProfile() {
            return this.profile;
        }

        public void setProfile(String profile) {
            this.profile = profile;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getNotBefore() {
            return this.notBefore;
        }

        public void setNotBefore(String notBefore) {
            this.notBefore = notBefore;
        }

        public String getNotAfter() {
            return this.notAfter;
        }

        public void setNotAfter(String notAfter) {
            this.notAfter = notAfter;
        }

        public void validate() throws InvalidConfException {
            GenSelfIssued.notBlank((String)this.subject, (String)"subject");
        }
    }

    public static class Ca
    extends IdNameConf {
        private CaInfo caInfo;
        private List<String> aliases;
        private List<String> profiles;
        private List<CaHasRequestor> requestors;
        private List<String> publishers;

        public CaInfo getCaInfo() {
            return this.caInfo;
        }

        public void setCaInfo(CaInfo caInfo) {
            this.caInfo = caInfo;
        }

        public List<String> getAliases() {
            if (this.aliases == null) {
                this.aliases = new LinkedList<String>();
            }
            return this.aliases;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = StringUtil.lowercase(aliases);
        }

        public List<String> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<String>();
            }
            return this.profiles;
        }

        public void setProfiles(List<String> profiles) {
            this.profiles = StringUtil.lowercase(profiles);
        }

        public List<CaHasRequestor> getRequestors() {
            if (this.requestors == null) {
                this.requestors = new LinkedList<CaHasRequestor>();
            }
            return this.requestors;
        }

        public void setRequestors(List<CaHasRequestor> requestors) {
            this.requestors = requestors;
        }

        public List<String> getPublishers() {
            if (this.publishers == null) {
                this.publishers = new LinkedList<String>();
            }
            return this.publishers;
        }

        public void setPublishers(List<String> publishers) {
            this.publishers = StringUtil.lowercase(publishers);
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Ca.validate((ValidableConf)this.caInfo, (ValidableConf[])new ValidableConf[0]);
            Ca.validate(this.requestors, (Collection[])new Collection[0]);
            if (this.aliases != null) {
                for (String alias : this.aliases) {
                    CaConfs.checkName(alias, "CA alias");
                }
            }
        }
    }

    public static class IdNameConf
    extends ValidableConf {
        private Integer id;
        private String name;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = StringUtil.lowercase((String)name);
        }

        public void validate() throws InvalidConfException {
            CaConfs.checkName(this.name, "name");
        }
    }

    public static class CaInfo
    extends BaseCaInfo {
        private FileOrBinary cert;
        private List<FileOrBinary> certchain;
        private GenSelfIssued genSelfIssued;
        private FileOrValue signerConf;

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public List<FileOrBinary> getCertchain() {
            return this.certchain;
        }

        public void setCertchain(List<FileOrBinary> certchain) {
            this.certchain = certchain;
        }

        public GenSelfIssued getGenSelfIssued() {
            return this.genSelfIssued;
        }

        public void setGenSelfIssued(GenSelfIssued genSelfIssued) {
            this.genSelfIssued = genSelfIssued;
        }

        public FileOrValue getSignerConf() {
            return this.signerConf;
        }

        public void setSignerConf(FileOrValue signerConf) {
            this.signerConf = signerConf;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            if (this.genSelfIssued != null && this.cert != null) {
                throw new InvalidConfException("cert and genSelfIssued may not be both non-null");
            }
            CaInfo.notNull((Object)this.signerConf, (String)"signerConf");
            CaInfo.validate((ValidableConf)this.genSelfIssued, (ValidableConf[])new ValidableConf[]{this.cert, this.signerConf});
        }
    }

    public static class CaHasRequestor
    extends ValidableConf {
        private String requestorName;
        private Permissions permissions;
        private List<String> profiles;

        public String getRequestorName() {
            return this.requestorName;
        }

        public void setRequestorName(String requestorName) {
            this.requestorName = StringUtil.lowercase((String)requestorName);
        }

        public Permissions getPermissions() {
            return this.permissions;
        }

        public void setPermissions(Permissions permissions) {
            this.permissions = permissions;
        }

        public List<String> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<String>();
            }
            return this.profiles;
        }

        public void setProfiles(List<String> profiles) {
            this.profiles = profiles;
        }

        public void validate() throws InvalidConfException {
            CaHasRequestor.notBlank((String)this.requestorName, (String)"requestorName");
            CaHasRequestor.notNull((Object)this.permissions, (String)"permissions");
        }
    }

    public static class CaSystem
    extends ValidableConf {
        private String basedir;
        private Map<String, String> properties;
        private Map<String, String> dbSchemas;
        private List<Signer> signers;
        private List<Requestor> requestors;
        private List<NameTypeConf> publishers;
        private List<NameTypeConf> profiles;
        private List<NameTypeConf> keypairGens;
        private List<Ca> cas;

        public String getBasedir() {
            return this.basedir;
        }

        public void setBasedir(String basedir) {
            this.basedir = basedir;
        }

        public Map<String, String> getProperties() {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public Map<String, String> getDbSchemas() {
            if (this.dbSchemas == null) {
                this.dbSchemas = new HashMap<String, String>();
            }
            return this.dbSchemas;
        }

        public void setDbSchemas(Map<String, String> dbSchemas) {
            this.dbSchemas = dbSchemas;
        }

        public List<Signer> getSigners() {
            if (this.signers == null) {
                this.signers = new LinkedList<Signer>();
            }
            return this.signers;
        }

        public void setSigners(List<Signer> signers) {
            this.signers = signers;
        }

        public List<Requestor> getRequestors() {
            if (this.requestors == null) {
                this.requestors = new LinkedList<Requestor>();
            }
            return this.requestors;
        }

        public void setRequestors(List<Requestor> requestors) {
            this.requestors = requestors;
        }

        public List<NameTypeConf> getPublishers() {
            if (this.publishers == null) {
                this.publishers = new LinkedList<NameTypeConf>();
            }
            return this.publishers;
        }

        public void setPublishers(List<NameTypeConf> publishers) {
            this.publishers = publishers;
        }

        public List<NameTypeConf> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<NameTypeConf>();
            }
            return this.profiles;
        }

        public void setProfiles(List<NameTypeConf> profiles) {
            this.profiles = profiles;
        }

        public List<NameTypeConf> getKeypairGens() {
            if (this.keypairGens == null) {
                this.keypairGens = new LinkedList<NameTypeConf>();
            }
            return this.keypairGens;
        }

        public void setKeypairGens(List<NameTypeConf> keypairGens) {
            this.keypairGens = keypairGens;
        }

        public List<Ca> getCas() {
            if (this.cas == null) {
                this.cas = new LinkedList<Ca>();
            }
            return this.cas;
        }

        public void setCas(List<Ca> cas) {
            this.cas = cas;
        }

        public void validate() throws InvalidConfException {
            CaSystem.validate(this.signers, (Collection[])new Collection[]{this.requestors, this.publishers, this.profiles, this.cas});
        }
    }
}

