/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.cert.CertificateEncodingException;
import java.util.HashSet;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.Permissions;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.JSON;
import org.xipki.util.exception.InvalidConfException;

public class CaJson {
    private static final ObjectMapper mapper = CaJson.newDefaultObjectMapper();
    private static final ObjectWriter prettyWriter = CaJson.newDefaultObjectMapper().writerWithDefaultPrettyPrinter();

    public static ObjectMapper newDefaultObjectMapper() {
        return JSON.newDefaultObjectMapper().registerModule((Module)XiCaJsonModule.INSTANCE);
    }

    public static <T> T parseObject(String json, Class<T> classOfT) {
        try {
            return (T)mapper.readValue(json, classOfT);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(byte[] json, Class<T> classOfT) {
        try {
            return (T)mapper.readValue(json, classOfT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(Path jsonFilePath, Class<T> classOfT) throws IOException {
        return (T)mapper.readValue(jsonFilePath.toFile(), classOfT);
    }

    public static <T> T parseObject(File jsonFile, Class<T> classOfT) throws IOException {
        return (T)mapper.readValue(jsonFile, classOfT);
    }

    public static <T> T parseObject(InputStream jsonInputStream, Class<T> classOfT) throws IOException {
        InputStreamReader noCloseReader = new InputStreamReader(jsonInputStream){

            @Override
            public void close() {
            }
        };
        return (T)mapper.readValue((Reader)noCloseReader, classOfT);
    }

    public static <T> T parseObjectAndClose(InputStream jsonInputStream, Class<T> classOfT) throws IOException {
        return (T)mapper.readValue((Reader)new InputStreamReader(jsonInputStream), classOfT);
    }

    public static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toJSONBytes(Object obj) {
        try {
            return mapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPrettyJson(Object obj) {
        try {
            return prettyWriter.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJSON(Object object, OutputStream outputStream) throws IOException {
        outputStream.write(CaJson.toJSONBytes(object));
    }

    public static void writeJSONAndClose(Object object, OutputStream outputStream) throws IOException {
        mapper.writeValue(outputStream, object);
    }

    public static void writePrettyJSON(Object object, OutputStream outputStream) throws IOException {
        outputStream.write(CaJson.toPrettyJson(object).getBytes(StandardCharsets.UTF_8));
    }

    public static void writePrettyJSONAndClose(Object object, OutputStream outputStream) throws IOException {
        prettyWriter.writeValue(outputStream, object);
    }

    private static class XiCaJsonModule
    extends SimpleModule {
        public static final XiCaJsonModule INSTANCE = new XiCaJsonModule();

        public XiCaJsonModule() {
            this.addSerializer(X509Cert.class, new X509CertSerializer());
            this.addDeserializer(X509Cert.class, new X509CertDeserializer());
            this.addSerializer(CrlControl.class, new CrlControlSerializer());
            this.addDeserializer(CrlControl.class, new CrlControlDeserializer());
            this.addSerializer(CtlogControl.class, new CtlogControlSerializer());
            this.addDeserializer(CtlogControl.class, new CtlogControlDeserializer());
            this.addSerializer(RevokeSuspendedControl.class, new RevokeSuspendedControlSerializer());
            this.addDeserializer(RevokeSuspendedControl.class, new RevokeSuspendedControlDeserializer());
            this.addSerializer(Permissions.class, new PermissionsSerializer());
            this.addDeserializer(Permissions.class, new PermissionsDeserializer());
        }
    }

    private static class PermissionsDeserializer
    extends JsonDeserializer<Permissions> {
        private PermissionsDeserializer() {
        }

        public Permissions deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            TreeNode o = jsonParser.readValueAsTree();
            if (o instanceof NumericNode) {
                int intValue = ((NumericNode)o).intValue();
                return new Permissions(intValue);
            }
            ArrayNode a = (ArrayNode)o;
            HashSet<String> s = new HashSet<String>();
            for (int i = 0; i < a.size(); ++i) {
                JsonNode n = a.get(i);
                s.add(n.textValue());
            }
            try {
                return new Permissions(s);
            }
            catch (InvalidConfException e) {
                throw new IOException(e);
            }
        }
    }

    private static class PermissionsSerializer
    extends JsonSerializer<Permissions> {
        private PermissionsSerializer() {
        }

        public void serialize(Permissions value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject(PermissionConstants.permissionToStringList(value.getValue()));
        }
    }

    private static class RevokeSuspendedControlDeserializer
    extends JsonDeserializer<RevokeSuspendedControl> {
        private RevokeSuspendedControlDeserializer() {
        }

        public RevokeSuspendedControl deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new RevokeSuspendedControl(JSON.deserializerConfPairs((JsonParser)jsonParser));
        }
    }

    private static class RevokeSuspendedControlSerializer
    extends JsonSerializer<RevokeSuspendedControl> {
        private RevokeSuspendedControlSerializer() {
        }

        public void serialize(RevokeSuspendedControl value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((Object)value.getConfPairs().asMap());
        }
    }

    private static class CtlogControlDeserializer
    extends JsonDeserializer<CtlogControl> {
        private CtlogControlDeserializer() {
        }

        public CtlogControl deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            try {
                return new CtlogControl(JSON.deserializerConfPairs((JsonParser)jsonParser));
            }
            catch (InvalidConfException e) {
                throw new IOException("invalid CrlControl", e);
            }
        }
    }

    private static class CtlogControlSerializer
    extends JsonSerializer<CtlogControl> {
        private CtlogControlSerializer() {
        }

        public void serialize(CtlogControl value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((Object)value.getConfPairs().asMap());
        }
    }

    private static class CrlControlDeserializer
    extends JsonDeserializer<CrlControl> {
        private CrlControlDeserializer() {
        }

        public CrlControl deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            try {
                return new CrlControl(JSON.deserializerConfPairs((JsonParser)jsonParser));
            }
            catch (InvalidConfException e) {
                throw new IOException("invalid CrlControl", e);
            }
        }
    }

    private static class CrlControlSerializer
    extends JsonSerializer<CrlControl> {
        private CrlControlSerializer() {
        }

        public void serialize(CrlControl value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((Object)value.getConfPairs().asMap());
        }
    }

    private static class X509CertDeserializer
    extends JsonDeserializer<X509Cert> {
        private X509CertDeserializer() {
        }

        public X509Cert deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            try {
                return X509Util.parseCert((byte[])Base64.decode((String)jsonParser.getValueAsString()));
            }
            catch (CertificateEncodingException e) {
                throw new IOException("invalid base64 certificate", e);
            }
        }
    }

    private static class X509CertSerializer
    extends JsonSerializer<X509Cert> {
        private X509CertSerializer() {
        }

        public void serialize(X509Cert value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(Base64.encodeToString((byte[])value.getEncoded()));
        }
    }
}

