/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.MgmtMessage;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.util.X509Util;

public abstract class MgmtResponse
extends MgmtMessage {

    public static class StringSet
    extends MgmtResponse {
        private Set<String> result;

        public StringSet() {
        }

        public StringSet(Set<String> result) {
            this.result = result;
        }

        public Set<String> getResult() {
            return this.result;
        }

        public void setResult(Set<String> result) {
            this.result = result;
        }
    }

    public static class StringResponse
    extends MgmtResponse {
        private String result;

        public StringResponse() {
        }

        public StringResponse(String result) {
            this.result = result;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }

    public static class ListCertificates
    extends MgmtResponse {
        private List<CertListInfo> result;

        public ListCertificates() {
        }

        public ListCertificates(List<CertListInfo> result) {
            this.result = result;
        }

        public List<CertListInfo> getResult() {
            return this.result;
        }

        public void setResult(List<CertListInfo> result) {
            this.result = result;
        }
    }

    public static class GetSigner
    extends MgmtResponse {
        private SignerEntry result;

        public GetSigner() {
        }

        public GetSigner(SignerEntry result) {
            this.result = result;
        }

        public SignerEntry getResult() {
            return this.result;
        }

        public void setResult(SignerEntry result) {
            this.result = result;
        }
    }

    public static class GetRequestorsForCa
    extends MgmtResponse {
        private Set<CaHasRequestorEntry> result;

        public GetRequestorsForCa() {
        }

        public GetRequestorsForCa(Set<CaHasRequestorEntry> result) {
            this.result = result;
        }

        public Set<CaHasRequestorEntry> getResult() {
            return this.result;
        }

        public void setResult(Set<CaHasRequestorEntry> result) {
            this.result = result;
        }
    }

    public static class GetRequestor
    extends MgmtResponse {
        private RequestorEntry result;

        public GetRequestor() {
        }

        public GetRequestor(RequestorEntry result) {
            this.result = result;
        }

        public RequestorEntry getResult() {
            return this.result;
        }

        public void setResult(RequestorEntry result) {
            this.result = result;
        }
    }

    public static class GetPublisher
    extends MgmtResponse {
        private PublisherEntry result;

        public GetPublisher() {
        }

        public GetPublisher(PublisherEntry result) {
            this.result = result;
        }

        public PublisherEntry getResult() {
            return this.result;
        }

        public void setResult(PublisherEntry result) {
            this.result = result;
        }
    }

    public static class GetPublischersForCa
    extends MgmtResponse {
        private List<PublisherEntry> result;

        public GetPublischersForCa() {
        }

        public GetPublischersForCa(List<PublisherEntry> result) {
            this.result = result;
        }

        public List<PublisherEntry> getResult() {
            return this.result;
        }

        public void setResult(List<PublisherEntry> result) {
            this.result = result;
        }
    }

    public static class GetKeypairGen
    extends MgmtResponse {
        private KeypairGenEntry result;

        public GetKeypairGen() {
        }

        public GetKeypairGen(KeypairGenEntry result) {
            this.result = result;
        }

        public KeypairGenEntry getResult() {
            return this.result;
        }

        public void setResult(KeypairGenEntry result) {
            this.result = result;
        }
    }

    public static class GetCert
    extends MgmtResponse {
        private CertWithRevocationInfoWrapper result;

        public GetCert() {
        }

        public GetCert(CertWithRevocationInfoWrapper result) {
            this.result = result;
        }

        public CertWithRevocationInfoWrapper getResult() {
            return this.result;
        }

        public void setResult(CertWithRevocationInfoWrapper result) {
            this.result = result;
        }
    }

    public static class GetCertprofile
    extends MgmtResponse {
        private CertprofileEntry result;

        public GetCertprofile() {
        }

        public GetCertprofile(CertprofileEntry result) {
            this.result = result;
        }

        public CertprofileEntry getResult() {
            return this.result;
        }

        public void setResult(CertprofileEntry result) {
            this.result = result;
        }
    }

    public static class GetCaSystemStatus
    extends MgmtResponse {
        private CaSystemStatus result;

        public GetCaSystemStatus() {
        }

        public GetCaSystemStatus(CaSystemStatus result) {
            this.result = result;
        }

        public CaSystemStatus getResult() {
            return this.result;
        }

        public void setResult(CaSystemStatus result) {
            this.result = result;
        }
    }

    public static class GetCa
    extends MgmtResponse {
        private CaEntry result;

        public GetCa() {
        }

        public GetCa(CaEntry result) {
            this.result = result;
        }

        public CaEntry getResult() {
            return this.result;
        }

        public void setResult(CaEntry result) {
            this.result = result;
        }
    }

    public static class Error
    extends MgmtResponse {
        private String message;

        public Error() {
        }

        public Error(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static class ByteArray
    extends MgmtResponse {
        private byte[] result;

        public ByteArray() {
        }

        public ByteArray(byte[] result) {
            this.result = result;
        }

        public byte[] getResult() {
            return this.result;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }
    }

    public static class KeyCertBytes
    extends MgmtResponse {
        private byte[] key;
        private byte[] cert;

        public KeyCertBytes() {
        }

        public KeyCertBytes(byte[] key, byte[] cert) {
            this.key = key;
            this.cert = cert;
        }

        public byte[] getKey() {
            return this.key;
        }

        public void setKey(byte[] key) {
            this.key = key;
        }

        public byte[] getCert() {
            return this.cert;
        }

        public void setCert(byte[] cert) {
            this.cert = cert;
        }
    }

    public static class CertWithRevocationInfoWrapper {
        private CertWithDbIdWrapper cert;
        private CertRevocationInfo revInfo;
        private String certprofile;

        public CertWithRevocationInfoWrapper() {
        }

        public CertWithRevocationInfoWrapper(CertWithRevocationInfo info) {
            this.cert = new CertWithDbIdWrapper(info.getCert());
            this.revInfo = info.getRevInfo();
            this.certprofile = info.getCertprofile();
        }

        public CertWithDbIdWrapper getCert() {
            return this.cert;
        }

        public void setCert(CertWithDbIdWrapper cert) {
            this.cert = cert;
        }

        public CertRevocationInfo getRevInfo() {
            return this.revInfo;
        }

        public void setRevInfo(CertRevocationInfo revInfo) {
            this.revInfo = revInfo;
        }

        public String getCertprofile() {
            return this.certprofile;
        }

        public void setCertprofile(String certprofile) {
            this.certprofile = certprofile;
        }

        public CertWithRevocationInfo toCertWithRevocationInfo() throws CertificateException {
            CertWithRevocationInfo ret = new CertWithRevocationInfo();
            ret.setCert(this.cert.toCertWithDbId());
            ret.setCertprofile(this.certprofile);
            ret.setRevInfo(this.revInfo);
            return ret;
        }
    }

    public static class CertWithDbIdWrapper {
        private byte[] cert;
        private Long certId;

        public CertWithDbIdWrapper() {
        }

        public CertWithDbIdWrapper(CertWithDbId certWithDbId) {
            this.cert = certWithDbId.getCert().getEncoded();
            this.certId = certWithDbId.getCertId();
        }

        public byte[] getCert() {
            return this.cert;
        }

        public void setCert(byte[] cert) {
            this.cert = cert;
        }

        public Long getCertId() {
            return this.certId;
        }

        public void setCertId(Long certId) {
            this.certId = certId;
        }

        public CertWithDbId toCertWithDbId() throws CertificateException {
            CertWithDbId ret = new CertWithDbId(X509Util.parseCert((byte[])this.cert));
            ret.setCertId(this.certId);
            return ret;
        }
    }

    public static class GetDbSchemas
    extends MgmtResponse {
        private Map<String, String> result;

        public GetDbSchemas() {
        }

        public GetDbSchemas(Map<String, String> result) {
            this.result = result;
        }

        public Map<String, String> getResult() {
            return this.result;
        }

        public void setResult(Map<String, String> result) {
            this.result = result;
        }
    }
}

