/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import java.util.List;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.CaJson;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.Permissions;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.mgmt.entry.BaseCaInfo;
import org.xipki.util.ConfPairs;
import org.xipki.util.Validity;

public class CaConfColumn {
    public static final int DEFAULT_numCrls = 30;
    public static final int DEFAULT_expirationPeriod = 365;
    public static final int DEFAULT_keepExpiredCertDays = -1;
    private int version = 1;
    private int snSize;
    private List<String> cacertUris;
    private List<String> ocspUris;
    private List<String> crlUris;
    private List<String> deltaCrlUris;
    private Validity maxValidity;
    private CrlControl crlControl;
    private CtlogControl ctlogControl;
    private RevokeSuspendedControl revokeSuspendedControl;
    private List<String> keypairGenNames;
    private boolean saveCert;
    private boolean saveKeypair;
    private ValidityMode validityMode;
    private Permissions permission;
    private int numCrls = 30;
    private int expirationPeriod = 365;
    private int keepExpiredCertDays = -1;
    private ConfPairs extraControl;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getSnSize() {
        return this.snSize;
    }

    public void setSnSize(int snSize) {
        this.snSize = snSize;
    }

    public List<String> getCacertUris() {
        return this.cacertUris;
    }

    public void setCacertUris(List<String> cacertUris) {
        this.cacertUris = cacertUris;
    }

    public List<String> getOcspUris() {
        return this.ocspUris;
    }

    public void setOcspUris(List<String> ocspUris) {
        this.ocspUris = ocspUris;
    }

    public List<String> getCrlUris() {
        return this.crlUris;
    }

    public void setCrlUris(List<String> crlUris) {
        this.crlUris = crlUris;
    }

    public List<String> getDeltaCrlUris() {
        return this.deltaCrlUris;
    }

    public void setDeltaCrlUris(List<String> deltaCrlUris) {
        this.deltaCrlUris = deltaCrlUris;
    }

    public Validity getMaxValidity() {
        return this.maxValidity;
    }

    public void setMaxValidity(Validity maxValidity) {
        this.maxValidity = maxValidity;
    }

    public List<String> getKeypairGenNames() {
        return this.keypairGenNames;
    }

    public void setKeypairGenNames(List<String> keypairGenNames) {
        this.keypairGenNames = keypairGenNames;
    }

    public boolean isSaveCert() {
        return this.saveCert;
    }

    public void setSaveCert(boolean saveCert) {
        this.saveCert = saveCert;
    }

    public boolean isSaveKeypair() {
        return this.saveKeypair;
    }

    public void setSaveKeypair(boolean saveKeypair) {
        this.saveKeypair = saveKeypair;
    }

    public ValidityMode getValidityMode() {
        return this.validityMode;
    }

    public void setValidityMode(ValidityMode validityMode) {
        this.validityMode = validityMode;
    }

    public Permissions getPermission() {
        return this.permission;
    }

    public void setPermission(Permissions permission) {
        this.permission = permission;
    }

    public int getNumCrls() {
        return this.numCrls;
    }

    public void setNumCrls(int numCrls) {
        this.numCrls = numCrls;
    }

    public int getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public void setExpirationPeriod(int expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
    }

    public int getKeepExpiredCertDays() {
        return this.keepExpiredCertDays;
    }

    public void setKeepExpiredCertDays(int keepExpiredCertDays) {
        this.keepExpiredCertDays = keepExpiredCertDays;
    }

    public CrlControl getCrlControl() {
        return this.crlControl;
    }

    public void setCrlControl(CrlControl crlControl) {
        this.crlControl = crlControl;
    }

    public CtlogControl getCtlogControl() {
        return this.ctlogControl;
    }

    public void setCtlogControl(CtlogControl ctlogControl) {
        this.ctlogControl = ctlogControl;
    }

    public RevokeSuspendedControl getRevokeSuspendedControl() {
        return this.revokeSuspendedControl;
    }

    public void setRevokeSuspendedControl(RevokeSuspendedControl revokeSuspendedControl) {
        this.revokeSuspendedControl = revokeSuspendedControl;
    }

    public ConfPairs getExtraControl() {
        return this.extraControl;
    }

    public void setExtraControl(ConfPairs extraControl) {
        this.extraControl = extraControl;
    }

    public CaConfColumn copy() {
        return CaConfColumn.decode(this.encode());
    }

    public static CaConfColumn decode(String encoded) {
        return CaJson.parseObject(encoded, CaConfColumn.class);
    }

    public void fillBaseCaInfo(BaseCaInfo baseCaInfo) throws CaMgmtException {
        baseCaInfo.setCaUris(this.caUris());
        baseCaInfo.setExpirationPeriod(this.expirationPeriod);
        baseCaInfo.setKeepExpiredCertDays(this.keepExpiredCertDays);
        baseCaInfo.setKeypairGenNames(this.keypairGenNames);
        baseCaInfo.setMaxValidity(this.maxValidity);
        baseCaInfo.setNumCrls(this.numCrls);
        baseCaInfo.setSaveCert(this.saveCert);
        baseCaInfo.setSnSize(this.snSize);
        baseCaInfo.setSaveKeypair(this.saveKeypair);
        baseCaInfo.setValidityMode(this.validityMode());
        baseCaInfo.setPermissions(this.permission);
        baseCaInfo.setCrlControl(this.crlControl);
        baseCaInfo.setCtlogControl(this.ctlogControl);
        baseCaInfo.setExtraControl(this.extraControl);
        baseCaInfo.setRevokeSuspendedControl(this.revokeSuspendedControl);
    }

    public static CaConfColumn fromBaseCaInfo(BaseCaInfo baseCaInfo) {
        CaConfColumn cc = new CaConfColumn();
        CaUris caUris = baseCaInfo.getCaUris();
        if (caUris != null) {
            cc.setCacertUris(caUris.getCacertUris());
            cc.setCrlUris(caUris.getCrlUris());
            cc.setDeltaCrlUris(caUris.getDeltaCrlUris());
            cc.setOcspUris(caUris.getOcspUris());
        }
        cc.setKeypairGenNames(baseCaInfo.getKeypairGenNames());
        cc.setMaxValidity(baseCaInfo.getMaxValidity());
        cc.setNumCrls(baseCaInfo.getNumCrls());
        cc.setSaveCert(baseCaInfo.isSaveCert());
        cc.setSaveKeypair(baseCaInfo.isSaveKeypair());
        cc.setSnSize(baseCaInfo.getSnSize());
        cc.setValidityMode(baseCaInfo.getValidityMode());
        cc.setExpirationPeriod(baseCaInfo.getExpirationPeriod());
        cc.setKeepExpiredCertDays(baseCaInfo.getKeepExpiredCertDays());
        cc.setPermission(baseCaInfo.getPermissions());
        cc.setCtlogControl(baseCaInfo.getCtlogControl());
        cc.setCrlControl(baseCaInfo.getCrlControl());
        cc.setRevokeSuspendedControl(baseCaInfo.getRevokeSuspendedControl());
        cc.setExtraControl(baseCaInfo.getExtraControl());
        return cc;
    }

    public String encode() {
        return CaJson.toPrettyJson(this);
    }

    public CaUris caUris() {
        return new CaUris(this.cacertUris, this.ocspUris, this.crlUris, this.deltaCrlUris);
    }

    private ValidityMode validityMode() {
        return this.validityMode == null ? ValidityMode.strict : this.validityMode;
    }
}

