XiPKI CLI Commands
=====

For the usage of CLI commands, just use the option `--help`. Most XiPKI commands can
auto-complete the options and arguments by the `TAB` key.

Basic Commands
--
   * `xi:base64`

     Base64 encode / decode

   * `xi:confirm`

     confirm an action

   * `xi:copy-dir`

     copy content of the directory to destination

   * `xi:copy-file`

     copy files.

   * `xi:curl`

     transfer a URL

   * `xi:datetime`

     return date and time

   * `xi:file-exists`

     return whether a file or dir exists

   * `xi:exec`

     execute terminal command

   * `xi:mkdir`

     make directories

   * `xi:move-dir`

     move content of the directory to destination

   * `xi:move-file`

     move file

   * `xi:osinfo`

     return OS info

   * `xi:replace`

     replace text in file

   * `xi:rm`

     remove file or directory

Security Commands
-----

   * `xi:cert-info`

     print certificate information

   * `xi:crl-info`

     print CRL information

   * `xi:convert-keystore`

     convert keystore

   * `xi:csr-p11`

     generate CSR with PKCS#11 device

   * `xi:csr-p12`

     generate CSR with PKCS#12 keystore

   * `xi:delete-key-p11`

     delete key and cert in PKCS#11 device

   * `xi:delete-objects-p11`

     delete objects in PKCS#11 device

   * `xi:deobfuscate`

     deobfuscate password

   * `xi:dsa-p11`

     generate DSA keypair in PKCS#11 device

   * `xi:dsa-p12`

     generate RSA keypair in PKCS#12 keystore

   * `xi:ec-p11`

     generate EC keypair in PKCS#11 device

   * `xi:ec-p12`

     generate EC keypair in PKCS#12 keystore

   * `xi:export-cert-p12`

     export certificate from PKCS#12 keystore

   * `xi:export-cert-p7m`

     export (the first) certificate from CMS signed data

   * `xi:export-keycert-est`

     export key and certificate from the response of EST's serverkeygen

   * `xi:import-cert`

     import certificates to a keystore

   * `xi:import-secretkey-p11`

     import secret key with given value in PKCS#11 device

   * `xi:object-exists-p11`

     return whether objects exist in PKCS#11 device

   * `xi:obfuscate`

     obfuscate password

   * `xi:pbe-dec`

     decrypt password with master password

   * `xi:pbe-enc`

     encrypt password with master password

   * `xi:pkcs12`

     export PKCS#12 key store, like the 'openssl pkcs12' command

   * `xi:rsa-p11`

     generate RSA keypair in PKCS#11 device

   * `xi:rsa-p12`

     generate RSA keypair in PKCS#12 keystore

   * `xi:secretkey-p11`

     generate secret key in PKCS#11 device

   * `xi:secretkey-p12`

     generate secret key in JCEKS (not PKCS#12) keystore

   * `xi:sm2-p11`

     generate SM2 keypair in PKCS#11 device

   * `xi:sm2-p12`

     generate SM2 keypair in PKCS#12 keystore

   * `xi:token-info-p11`

     list objects in PKCS#11 device

   * `xi:update-cert-p12`

     update certificate in PKCS#12 keystore

   * `xi:validate-csr`

     validate CSR

CMP Client Commands
-----

   * `xi:cmp-cacert`

     get CA certificate

   * `xi:cmp-cacerts`

     get CA certificate chain

   * `xi:cmp-csr-enroll`

     enroll certificate via CSR

   * `xi:cmp-enroll-serverkeygen`

     enroll certificate (keypair will be generated by the CA)

   * `xi:cmp-enroll-p11`

     enroll certificate (PKCS#11 token)

   * `xi:cmp-enroll-p12`

     enroll certificate (PKCS#12 keystore)

   * `xi:cmp-get-crl`

     download CRL

   * `xi:cmp-revoke`

     revoke certificate

   * `xi:cmp-unsuspend`

     unsuspend certificate

   * `xi:cmp-update-serverkeygen`

     update certificate (keypair will be generated by the CA)

   * `xi:cmp-update-p11`

     update certificate (PKCS#11 token)

   * `xi:cmp-update-p12`

     update certificate (PKCS#12 token)

SCEP Client Commands
-----

   * `xi:scep-cacert`

     get CA certificate


   * `xi:scep-certpoll`

     poll certificate

   * `xi:scep-enroll`

     enroll certificate

   * `xi:scep-get-cert`

     download certificate

   * `xi:scep-get-crl`

     download CRL
