/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.xipki.audit.AuditEventData;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;

public class AuditEvent {
    private String applicationName;
    private String name;
    private AuditLevel level;
    private final Date timestamp;
    private AuditStatus status;
    private long duration = -1L;
    private final List<AuditEventData> eventDatas = new LinkedList<AuditEventData>();

    public AuditEvent(Date timestamp) {
        this.timestamp = timestamp == null ? new Date() : timestamp;
        this.level = AuditLevel.INFO;
    }

    public AuditLevel getLevel() {
        return this.level;
    }

    public void setLevel(AuditLevel level) {
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName must not be null");
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public List<AuditEventData> getEventDatas() {
        return Collections.unmodifiableList(this.eventDatas);
    }

    public AuditEventData addEventType(String type) {
        return this.addEventData("event_type", type);
    }

    public AuditEventData addEventData(String name, Object value) {
        return this.addEventData(new AuditEventData(name, value));
    }

    public AuditEventData addEventData(AuditEventData eventData) {
        Objects.requireNonNull(eventData, "eventData must not be null");
        int idx = -1;
        for (int i = 0; i < this.eventDatas.size(); ++i) {
            AuditEventData ed = this.eventDatas.get(i);
            if (!ed.getName().equals(eventData.getName())) continue;
            idx = i;
            break;
        }
        if (idx != -1) {
            AuditEventData existing = this.eventDatas.get(idx);
            existing.addValue(eventData.getValue());
            return existing;
        }
        this.eventDatas.add(eventData);
        return eventData;
    }

    public boolean removeEventData(String eventDataName) {
        Objects.requireNonNull(eventDataName, "eventDataName must not be null");
        AuditEventData tbr = null;
        for (AuditEventData ed : this.eventDatas) {
            if (!ed.getName().equals(eventDataName)) continue;
            tbr = ed;
        }
        boolean removed = false;
        if (tbr != null) {
            this.eventDatas.remove(tbr);
            removed = true;
        }
        return removed;
    }

    public AuditStatus getStatus() {
        return this.status;
    }

    public void setStatus(AuditStatus status) {
        this.status = Objects.requireNonNull(status, "status must not be null");
    }

    public void finish() {
        this.duration = System.currentTimeMillis() - this.timestamp.getTime();
    }

    public long getDuration() {
        return this.duration;
    }
}

