/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit;

import java.util.Objects;

public class AuditEventData {
    private final String name;
    private String value;

    public AuditEventData(String name, Object value) {
        Objects.requireNonNull(name, "name must not be null");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name must not be empty");
        }
        Objects.requireNonNull(value, "value must not be null");
        this.name = name;
        this.value = value instanceof String ? (String)value : value.toString();
    }

    public void addValue(Object additionalValue) {
        this.value = this.value + ", " + additionalValue;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.name + ": " + this.value;
    }
}

