/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit.internal;

import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditServiceRegister;
import org.xipki.audit.internal.Slf4jAuditService;

public class AuditServiceRegisterImpl
implements AuditServiceRegister {
    private static final Logger LOG = LoggerFactory.getLogger(AuditServiceRegisterImpl.class);
    private ConcurrentLinkedDeque<AuditService> services = new ConcurrentLinkedDeque();
    private AuditService defaultAuditService = new Slf4jAuditService();

    @Override
    public AuditService getAuditService() {
        return this.services.isEmpty() ? this.defaultAuditService : this.services.getLast();
    }

    public void bindService(AuditService service) {
        if (service == null) {
            LOG.info("bindService invoked with null.");
            return;
        }
        boolean replaced = this.services.remove(service);
        this.services.add(service);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} AuditService binding for {}", (Object)action, (Object)service);
    }

    public void unbindService(AuditService service) {
        if (service == null) {
            LOG.debug("unbindService invoked with null.");
            return;
        }
        if (this.services.remove(service)) {
            LOG.info("removed AuditService binding for {}", (Object)service);
        } else {
            LOG.info("no AuditService binding found to remove for '{}'", (Object)service);
        }
    }
}

