/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit;

import java.util.Objects;

public enum AuditLevel {
    ERROR(3, "ERROR"),
    WARN(4, "WARN "),
    INFO(6, "INFO "),
    DEBUG(7, "DEBUG");

    private final int value;
    private String alignedText;

    private AuditLevel(int value, String alignedText) {
        this.value = value;
        this.alignedText = alignedText;
    }

    public int getValue() {
        return this.value;
    }

    public static AuditLevel forName(String name) {
        Objects.requireNonNull("name", "name may not be null");
        for (AuditLevel value : AuditLevel.values()) {
            if (!value.name().equals(name)) continue;
            return value;
        }
        throw new IllegalArgumentException("invalid AuditLevel name " + name);
    }

    public static AuditLevel forValue(int value) {
        for (AuditLevel v : AuditLevel.values()) {
            if (v.getValue() != value) continue;
            return v;
        }
        throw new IllegalArgumentException("invalid AuditLevel code " + value);
    }

    public String getAlignedText() {
        return this.alignedText;
    }
}

