/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditServiceRuntimeException;
import org.xipki.audit.services.EmbedAuditService;
import org.xipki.audit.services.SyslogAuditService;

public class Audits {
    private static final String DFLT_AUDIT_CFG = "xipki/etc/org.xipki.audit.cfg";
    private static final String DFLT_AUDIT_SYSLOG_CFG = "xipki/etc/org.xipki.audit.syslog.cfg";
    private static AuditService auditService;
    private static AuditServiceRuntimeException initializationException;

    private Audits() {
    }

    public static AuditService getAuditService() {
        if (auditService != null) {
            return auditService;
        }
        if (initializationException != null) {
            throw initializationException;
        }
        throw new IllegalStateException("Please call Audits.init() first.");
    }

    public static void init(String auditCfg) {
        try {
            AuditService service;
            Properties auditProps = Audits.loadProperties(auditCfg == null ? DFLT_AUDIT_CFG : auditCfg);
            String auditType = Audits.getString(auditProps, "audit.type", "embed");
            String auditConf = Audits.getString(auditProps, "audit.conf", DFLT_AUDIT_SYSLOG_CFG);
            if ("embed".equalsIgnoreCase(auditType)) {
                service = new EmbedAuditService();
            } else if ("syslog".equalsIgnoreCase(auditType)) {
                service = new SyslogAuditService();
            } else if (auditType.startsWith("java:")) {
                String className = auditType.substring("java:".length());
                try {
                    Class<?> clazz = Class.forName(className);
                    service = (AuditService)clazz.newInstance();
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    throw new AuditServiceRuntimeException("error caught while initializing AuditService " + auditType + ": " + ex.getClass().getName() + ": " + ex.getMessage(), ex);
                }
            } else {
                throw new AuditServiceRuntimeException("invalid Audit.Type '" + auditType + "'. Valid values are 'embed', 'syslog' or java:<name of class that implements " + AuditService.class.getName() + ">");
            }
            service.init(auditConf);
            auditService = service;
        }
        catch (AuditServiceRuntimeException ex) {
            initializationException = ex;
        }
        catch (RuntimeException ex) {
            initializationException = new AuditServiceRuntimeException(ex.getMessage(), ex);
        }
    }

    private static Properties loadProperties(String path) throws AuditServiceRuntimeException {
        Path realPath = Paths.get(path, new String[0]);
        if (Files.exists(realPath, new LinkOption[0])) {
            Properties props = new Properties();
            try (InputStream is = Files.newInputStream(realPath, new OpenOption[0]);){
                props.load(is);
            }
            catch (IOException ex) {
                throw new AuditServiceRuntimeException("could not load properties from file " + path, ex);
            }
            return props;
        }
        throw new AuditServiceRuntimeException("the file " + path + " does not exist");
    }

    private static String getString(Properties props, String key, String dfltValue) {
        if (props == null) {
            return dfltValue;
        }
        String value = props.getProperty(key);
        return value == null ? dfltValue : value;
    }
}

