/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit;

import org.xipki.audit.AuditService;
import org.xipki.audit.AuditServiceRuntimeException;
import org.xipki.audit.services.EmbedAuditService;
import org.xipki.audit.services.SyslogAuditService;

public class Audits {
    private static AuditService auditService;
    private static AuditServiceRuntimeException initializationException;

    private Audits() {
    }

    public static AuditService getAuditService() {
        if (auditService != null) {
            return auditService;
        }
        if (initializationException != null) {
            throw initializationException;
        }
        throw new IllegalStateException("Please call Audits.init() first.");
    }

    public static void init(String auditType, String auditConf) {
        try {
            AuditService service;
            if ("embed".equalsIgnoreCase(auditType)) {
                service = new EmbedAuditService();
            } else if ("syslog".equalsIgnoreCase(auditType)) {
                service = new SyslogAuditService();
            } else if (auditType.startsWith("java:")) {
                String className = auditType.substring("java:".length());
                try {
                    Class<?> clazz = Class.forName(className);
                    service = (AuditService)clazz.newInstance();
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    throw new AuditServiceRuntimeException("error caught while initializing AuditService " + auditType + ": " + ex.getClass().getName() + ": " + ex.getMessage(), ex);
                }
            } else {
                throw new AuditServiceRuntimeException("invalid Audit.Type '" + auditType + "'. Valid values are 'embed', 'syslog' or java:<name of class that implements " + AuditService.class.getName() + ">");
            }
            service.init(auditConf);
            auditService = service;
        }
        catch (AuditServiceRuntimeException ex) {
            initializationException = ex;
        }
        catch (RuntimeException ex) {
            initializationException = new AuditServiceRuntimeException(ex.getMessage(), ex);
        }
    }

    public static class AuditConf {
        private String type;
        private String conf;
        public static AuditConf DEFAULT = new AuditConf();

        public String getType() {
            return this.type == null || this.type.isEmpty() ? "embed" : this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getConf() {
            return this.conf;
        }

        public void setConf(String conf) {
            this.conf = conf;
        }
    }
}

