/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit.services;

import java.io.CharArrayWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditEventData;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.PciAuditEvent;
import org.xipki.util.Args;

public class EmbedAuditService
implements AuditService {
    private static final Logger LOG = LoggerFactory.getLogger((String)"xipki.audit.slf4j");
    private static final Marker MARKER = MarkerFactory.getMarker((String)"xiaudit");

    @Override
    public void init(String conf) {
    }

    @Override
    public void logEvent(AuditEvent event) {
        switch (event.getLevel()) {
            case DEBUG: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(MARKER, "{}", (Object)EmbedAuditService.createMessage(event));
                break;
            }
            default: {
                if (!LOG.isInfoEnabled()) break;
                LOG.info(MARKER, "{}", (Object)EmbedAuditService.createMessage(event));
            }
        }
    }

    @Override
    public void logEvent(PciAuditEvent event) {
        CharArrayWriter msg = event.toCharArrayWriter("");
        AuditLevel al = event.getLevel();
        switch (al) {
            case DEBUG: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(MARKER, "{} | {}", (Object)al.getAlignedText(), (Object)msg);
                break;
            }
            default: {
                if (!LOG.isInfoEnabled()) break;
                LOG.info(MARKER, "{} | {}", (Object)al.getAlignedText(), (Object)msg);
            }
        }
    }

    protected static String createMessage(AuditEvent event) {
        String name;
        Args.notNull((Object)event, (String)"event");
        String applicationName = event.getApplicationName();
        if (applicationName == null) {
            applicationName = "undefined";
        }
        if ((name = event.getName()) == null) {
            name = "undefined";
        }
        StringBuilder sb = new StringBuilder(150);
        sb.append(event.getLevel().getAlignedText()).append(" | ");
        sb.append(applicationName).append(" - ").append(name);
        AuditStatus status = event.getStatus();
        if (status == null) {
            status = AuditStatus.UNDEFINED;
        }
        sb.append(":\tstatus: ").append(status.name());
        List<AuditEventData> eventDataArray = event.getEventDatas();
        long duration = event.getDuration();
        if (duration >= 0L) {
            sb.append("\tduration: ").append(duration);
        }
        if (eventDataArray != null && eventDataArray.size() > 0) {
            for (AuditEventData m : eventDataArray) {
                if (duration >= 0L && "duration".equalsIgnoreCase(m.getName())) continue;
                sb.append("\t").append(m.getName()).append(": ").append(m.getValue());
            }
        }
        return sb.toString();
    }
}

