/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit.services;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.MessageFormat;
import com.cloudbees.syslog.Severity;
import com.cloudbees.syslog.SyslogMessage;
import com.cloudbees.syslog.sender.AbstractSyslogMessageSender;
import com.cloudbees.syslog.sender.TcpSyslogMessageSender;
import com.cloudbees.syslog.sender.UdpSyslogMessageSender;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditEventData;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditServiceRuntimeException;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.PciAuditEvent;
import org.xipki.util.FileOrBinary;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.http.SslContextConf;

public class SyslogAuditService
implements AuditService {
    public static final int DFLT_SYSLOG_PORT = 514;
    public static final String DFLT_SYSLOG_PROTOCOL = "udp";
    public static final String DFLT_SYSLOG_FACILITY = "user";
    public static final String DFLT_SYSLOG_HOST = "localhost";
    public static final String DFLT_MESSAGE_FORMAT = "rfc_5424";
    private static final Logger LOG = LoggerFactory.getLogger(SyslogAuditService.class);
    protected AbstractSyslogMessageSender syslog;
    private String messageFormat = "rfc_5424";
    private int maxMessageLength = 1024;
    private String localname;
    private String prefix;
    private boolean initialized;

    @Override
    public void init(String conf) {
        TcpSyslogMessageSender lcSyslog;
        MessageFormat msgFormat;
        LOG.info("initializing: {}", SyslogAuditService.class);
        Properties props = SyslogAuditService.loadProperties(conf.trim());
        String host = SyslogAuditService.getString(props, "host", DFLT_SYSLOG_HOST);
        String ts = props.getProperty("prefix");
        this.prefix = SyslogAuditService.notEmpty(ts) ? (ts.charAt(ts.length() - 1) != ' ' ? ts + " " : ts) : null;
        this.localname = props.getProperty("localname");
        int ti = SyslogAuditService.getInt(props, "maxMessageLength", 1024);
        this.maxMessageLength = ti <= 0 ? 1023 : ti;
        int port = SyslogAuditService.getInt(props, "port", 514);
        String protocol = SyslogAuditService.getString(props, "protocol", DFLT_SYSLOG_PROTOCOL).toLowerCase();
        this.messageFormat = SyslogAuditService.getString(props, "messageFormat", DFLT_MESSAGE_FORMAT).toLowerCase();
        if ("rfc3164".equals(this.messageFormat) || "rfc_3164".equals(this.messageFormat)) {
            msgFormat = MessageFormat.RFC_3164;
        } else if ("rfc5424".equals(this.messageFormat) || DFLT_MESSAGE_FORMAT.equals(this.messageFormat)) {
            msgFormat = MessageFormat.RFC_5424;
        } else {
            LOG.warn("invalid message format '{}', use the default one '{}'", (Object)this.messageFormat, (Object)DFLT_MESSAGE_FORMAT);
            msgFormat = MessageFormat.RFC_5424;
        }
        if ("tcp".equals(protocol)) {
            lcSyslog = new TcpSyslogMessageSender();
            this.syslog = lcSyslog;
            lcSyslog.setSyslogServerHostname(host);
            lcSyslog.setSyslogServerPort(port);
            int writeRetries = SyslogAuditService.getInt(props, "writeRetries", 2);
            if (writeRetries > 0) {
                lcSyslog.setMaxRetryCount(writeRetries);
            }
            boolean ssl = SyslogAuditService.getBoolean(props, "ssl", false);
            lcSyslog.setSsl(ssl);
            if (ssl) {
                String sslKeystore = props.getProperty("sslKeystore");
                String sslTruststore = props.getProperty("sslTruststore");
                if (sslKeystore != null || sslTruststore != null) {
                    SSLContext sslContext;
                    String sslStoreType = SyslogAuditService.getString(props, "sslStoreType", "PKCS12");
                    String sslKeystorePassword = SyslogAuditService.getString(props, "sslKeystorePassword", "");
                    String sslTruststorePassword = SyslogAuditService.getString(props, "sslTruststorePassword", "");
                    SslContextConf sslConf = new SslContextConf();
                    if (sslStoreType != null) {
                        sslConf.setSslStoreType(sslStoreType);
                    }
                    if (sslKeystore != null) {
                        sslConf.setSslKeystore(FileOrBinary.ofFile((String)sslKeystore));
                        sslConf.setSslKeystorePassword(sslKeystorePassword);
                    }
                    if (sslTruststore != null) {
                        sslConf.setSslTruststore(FileOrBinary.ofFile((String)sslStoreType));
                        sslConf.setSslTruststorePassword(sslTruststorePassword);
                    }
                    try {
                        sslContext = sslConf.getSslContext();
                    }
                    catch (ObjectCreationException ex) {
                        throw new IllegalStateException("error getting SSLContext", ex);
                    }
                    lcSyslog.setSSLContext(sslContext);
                }
            }
        } else {
            if (!DFLT_SYSLOG_PROTOCOL.equals(protocol)) {
                LOG.warn("unknown protocol '{}', use the default one 'udp'", (Object)protocol);
            }
            lcSyslog = new UdpSyslogMessageSender();
            this.syslog = lcSyslog;
            lcSyslog.setSyslogServerPort(port);
            lcSyslog.setSyslogServerHostname(host);
        }
        this.syslog.setMessageFormat(msgFormat);
        String facility = SyslogAuditService.getString(props, "facility", DFLT_SYSLOG_FACILITY);
        Facility sysFacility = Facility.fromLabel((String)facility.toUpperCase(Locale.ENGLISH));
        if (sysFacility == null) {
            LOG.warn("unknown facility, use the default one '{}'", (Object)DFLT_SYSLOG_FACILITY);
            sysFacility = Facility.fromLabel((String)DFLT_SYSLOG_FACILITY.toUpperCase(Locale.ENGLISH));
        }
        if (sysFacility == null) {
            throw new IllegalStateException("should not reach here, sysFacility is null");
        }
        this.syslog.setDefaultFacility(sysFacility);
        this.initialized = true;
        LOG.info("initialized: {}", SyslogAuditService.class);
    }

    @Override
    public void logEvent(AuditEvent event) {
        AuditStatus status;
        if (!this.initialized) {
            LOG.error("syslog audit not initialized");
            return;
        }
        CharArrayWriter sb = new CharArrayWriter(150);
        if (SyslogAuditService.notEmpty(this.prefix)) {
            sb.append(this.prefix);
        }
        if ((status = event.getStatus()) == null) {
            status = AuditStatus.UNDEFINED;
        }
        sb.append("\tstatus: ").append(status.name());
        long duration = event.getDuration();
        if (duration >= 0L) {
            sb.append("\tduration: ").append(Long.toString(duration));
        }
        List<AuditEventData> eventDataArray = event.getEventDatas();
        for (AuditEventData m : eventDataArray) {
            if (duration >= 0L && "duration".equalsIgnoreCase(m.getName())) continue;
            sb.append("\t").append(m.getName()).append(": ").append(m.getValue());
        }
        int n = sb.size();
        if (n > this.maxMessageLength) {
            LOG.warn("syslog message exceeds the maximal allowed length: {} > {}, ignore it", (Object)n, (Object)this.maxMessageLength);
            return;
        }
        SyslogMessage sm = new SyslogMessage();
        sm.setFacility(this.syslog.getDefaultFacility());
        if (SyslogAuditService.notEmpty(this.localname)) {
            sm.setHostname(this.localname);
        }
        sm.setAppName(event.getApplicationName());
        sm.setSeverity(SyslogAuditService.getSeverity(event.getLevel()));
        Date timestamp = event.getTimestamp();
        if (timestamp != null) {
            sm.setTimestamp(timestamp);
        }
        sm.setMsgId(event.getName());
        sm.setMsg(sb);
        try {
            this.syslog.sendMessage(sm);
        }
        catch (Throwable th) {
            LOG.error("could not send syslog message: {}", (Object)th.getMessage());
            LOG.debug("could not send syslog message", th);
        }
    }

    @Override
    public void logEvent(PciAuditEvent event) {
        if (!this.initialized) {
            LOG.error("syslog audit not initialiazed");
            return;
        }
        CharArrayWriter msg = event.toCharArrayWriter(this.prefix);
        int n = msg.size();
        if (n > this.maxMessageLength) {
            LOG.warn("syslog message exceeds the maximal allowed length: {} > {}, ignore it", (Object)n, (Object)this.maxMessageLength);
            return;
        }
        SyslogMessage sm = new SyslogMessage();
        sm.setFacility(this.syslog.getDefaultFacility());
        if (SyslogAuditService.notEmpty(this.localname)) {
            sm.setHostname(this.localname);
        }
        sm.setSeverity(SyslogAuditService.getSeverity(event.getLevel()));
        sm.setMsg(msg);
        try {
            this.syslog.sendMessage(sm);
        }
        catch (Throwable th) {
            LOG.error("could not send syslog message: {}", (Object)th.getMessage());
            LOG.debug("could not send syslog message", th);
        }
    }

    private static boolean notEmpty(String text) {
        return text != null && !text.isEmpty();
    }

    private static Severity getSeverity(AuditLevel auditLevel) {
        Severity res;
        if (auditLevel == null) {
            return Severity.INFORMATIONAL;
        }
        switch (auditLevel) {
            case DEBUG: {
                res = Severity.DEBUG;
                break;
            }
            case INFO: {
                res = Severity.INFORMATIONAL;
                break;
            }
            case WARN: {
                res = Severity.WARNING;
                break;
            }
            case ERROR: {
                res = Severity.ERROR;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("unknown auditLevel '%s'", new Object[]{auditLevel}));
            }
        }
        return res;
    }

    private static Properties loadProperties(String path) throws AuditServiceRuntimeException {
        if (path == null) {
            return null;
        }
        Path realPath = Paths.get(path, new String[0]);
        if (Files.exists(realPath, new LinkOption[0])) {
            Properties props = new Properties();
            try (InputStream is = Files.newInputStream(realPath, new OpenOption[0]);){
                props.load(is);
            }
            catch (IOException ex) {
                throw new AuditServiceRuntimeException("could not load properties from file " + path, ex);
            }
            return props;
        }
        throw new AuditServiceRuntimeException("the file " + path + " does not exist");
    }

    private static String getString(Properties props, String key, String dfltValue) {
        if (props == null) {
            return dfltValue;
        }
        String value = props.getProperty(key);
        return value == null ? dfltValue : value;
    }

    private static int getInt(Properties props, String key, int dfltValue) {
        if (props == null) {
            return dfltValue;
        }
        String value = props.getProperty(key);
        return value == null ? dfltValue : Integer.parseInt(value);
    }

    private static boolean getBoolean(Properties props, String key, boolean dfltValue) {
        if (props == null) {
            return dfltValue;
        }
        String value = props.getProperty(key);
        return value == null ? dfltValue : Boolean.parseBoolean(value);
    }
}

