/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.xipki.audit.AuditEventData;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.util.Args;

public class AuditEvent {
    private String applicationName;
    private AuditLevel level;
    private final Date timestamp;
    private AuditStatus status;
    private long duration;
    private final List<AuditEventData> eventDatas = new LinkedList<AuditEventData>();

    public AuditEvent(Date timestamp) {
        this.timestamp = timestamp == null ? new Date() : timestamp;
        this.level = AuditLevel.INFO;
        this.duration = -1L;
    }

    public AuditLevel getLevel() {
        if (this.status == AuditStatus.FAILED && AuditLevel.INFO == this.level) {
            return AuditLevel.WARN;
        }
        return this.level;
    }

    public void setLevel(AuditLevel level) {
        this.level = level;
    }

    public void update(AuditLevel level, AuditStatus status) {
        this.level = level;
        this.status = status;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = (String)Args.notNull((Object)applicationName, (String)"applicationName");
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public List<AuditEventData> getEventDatas() {
        return Collections.unmodifiableList(this.eventDatas);
    }

    public void setEventType(String type) {
        this.setEventData("event_type", type);
    }

    public AuditEventData addEventType(String type) {
        return this.addEventData("event_type", type);
    }

    public void setEventData(String name, Object value) {
        Args.notNull((Object)name, (String)"name");
        Args.notNull((Object)value, (String)"value");
        int idx = -1;
        for (int i = 0; i < this.eventDatas.size(); ++i) {
            AuditEventData ed = this.eventDatas.get(i);
            if (!ed.getName().equals(name)) continue;
            idx = i;
            break;
        }
        if (idx != -1) {
            this.eventDatas.remove(idx);
        }
        this.eventDatas.add(new AuditEventData(name, value));
    }

    public AuditEventData addEventData(String name, Object value) {
        return this.addEventData(new AuditEventData(name, value));
    }

    public AuditEventData addEventData(AuditEventData eventData) {
        Args.notNull((Object)eventData, (String)"eventData");
        int idx = -1;
        for (int i = 0; i < this.eventDatas.size(); ++i) {
            AuditEventData ed = this.eventDatas.get(i);
            if (!ed.getName().equals(eventData.getName())) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            this.eventDatas.add(eventData);
            return eventData;
        }
        AuditEventData existing = this.eventDatas.get(idx);
        existing.addValue(eventData.getValue());
        return existing;
    }

    public boolean removeEventData(String eventDataName) {
        Args.notNull((Object)eventDataName, (String)"eventDataName");
        boolean removed = false;
        for (AuditEventData ed : this.eventDatas) {
            if (!ed.getName().equals(eventDataName)) continue;
            this.eventDatas.remove(ed);
            removed = true;
            break;
        }
        return removed;
    }

    public AuditStatus getStatus() {
        return this.status;
    }

    public void setStatus(AuditStatus status) {
        Args.notNull((Object)((Object)status), (String)"status");
        if (this.status != status && this.status != AuditStatus.FAILED) {
            this.status = status;
        }
    }

    public void finish() {
        this.duration = System.currentTimeMillis() - this.timestamp.getTime();
    }

    public long getDuration() {
        return this.duration;
    }

    public String toTextMessage() {
        String applicationName = this.getApplicationName();
        if (applicationName == null) {
            applicationName = "undefined";
        }
        StringBuilder sb = new StringBuilder(150);
        sb.append(applicationName);
        AuditStatus status = this.getStatus();
        if (status == null) {
            status = AuditStatus.UNDEFINED;
        }
        sb.append(";\tstatus: ").append(status.name());
        List<AuditEventData> eventDataArray = this.getEventDatas();
        long duration = this.getDuration();
        if (duration >= 0L) {
            sb.append("\tduration: ").append(duration);
        }
        if (eventDataArray != null && eventDataArray.size() > 0) {
            for (AuditEventData m : eventDataArray) {
                if (duration >= 0L && "duration".equalsIgnoreCase(m.getName())) continue;
                sb.append("\t").append(m.getName()).append(": ").append(m.getValue());
            }
        }
        return sb.toString();
    }

    public void log(Logger log) {
        AuditLevel level = this.getLevel();
        if (level == AuditLevel.ERROR) {
            log.error(this.toTextMessage());
        } else if (level == AuditLevel.WARN) {
            log.warn(this.toTextMessage());
        } else {
            log.info(this.toTextMessage());
        }
    }
}

