/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.PciAuditEvent;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class EmbedAuditService
implements AuditService {
    public static final String KEY_FILE = "file";
    public static final String KEY_SIZE = "size";
    private static final String DELIM = " | ";
    private static final Logger LOG = LoggerFactory.getLogger(EmbedAuditService.class);
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy.MM.dd-HH:mm:ss.SSS");
    private final ZoneId timeZone = ZoneId.systemDefault();
    private File logDir;
    private String logFileNamePrefix;
    private String logFileNameSuffix;
    private long lastMsOfToday;
    private int maxFileSize;
    private OutputStreamWriter writer;
    private Path writerPath;
    private String writerFileCoreName;

    @Override
    public void init(String conf) {
        try {
            this.init(conf, null);
        }
        catch (PasswordResolverException | InvalidConfException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void init(String conf, PasswordResolver passwordResolver) throws PasswordResolverException, InvalidConfException {
        ConfPairs confPairs = new ConfPairs(conf);
        String str = confPairs.value(KEY_SIZE);
        int mb = 0x100000;
        if (str == null) {
            this.maxFileSize = 0xA00000;
        } else {
            this.maxFileSize = (str = str.trim().toLowerCase(Locale.ROOT)).endsWith("gb") ? Integer.parseInt(str.substring(0, str.length() - 2).trim()) * 1024 * 0x100000 : (str.endsWith("mb") ? Integer.parseInt(str.substring(0, str.length() - 2).trim()) * 0x100000 : (str.endsWith("kb") ? Integer.parseInt(str.substring(0, str.length() - 2).trim()) * 1024 : Integer.parseInt(str)));
            if (this.maxFileSize < 0x100000) {
                throw new InvalidConfException("invalid size " + str);
            }
        }
        String logFilePath = confPairs.value(KEY_FILE);
        if (StringUtil.isBlank((String)logFilePath)) {
            logFilePath = "logs/audit.log";
        }
        File logFile = new File(logFilePath).getAbsoluteFile();
        this.logDir = logFile.getParentFile();
        this.logDir.mkdirs();
        String fileName = logFile.getName();
        int idx = fileName.lastIndexOf(46);
        this.logFileNameSuffix = idx == -1 ? "" : fileName.substring(idx);
        String prefix = idx == -1 ? fileName : fileName.substring(0, idx);
        this.logFileNamePrefix = prefix + "_";
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        int yyyyMMddNow = DateUtil.getYyyyMMdd((Calendar)now);
        this.lastMsOfToday = DateUtil.getLastMsOfDay((Calendar)now);
        this.writer = this.buildWriter(yyyyMMddNow);
    }

    @Override
    public void logEvent(AuditEvent event) {
        this.storeLog(1, event.getLevel(), event.toTextMessage());
    }

    @Override
    public void logEvent(PciAuditEvent event) {
        this.storeLog(2, event.getLevel(), event.toTextMessage());
    }

    protected void storeLog(int eventType, AuditLevel level, String message) {
        Instant date = Instant.now();
        String payload = DTF.format(date.atZone(this.timeZone)) + DELIM + level.getText() + DELIM + eventType + DELIM + message;
        long ms = date.toEpochMilli();
        try {
            long size = Files.size(this.writerPath);
            if (ms > this.lastMsOfToday || size >= (long)this.maxFileSize) {
                long oldLastOfToday = this.lastMsOfToday;
                Calendar now = Calendar.getInstance(TimeZone.getDefault());
                now.setTimeInMillis(ms);
                int yyyyMMddNow = DateUtil.getYyyyMMdd((Calendar)now);
                this.lastMsOfToday = DateUtil.getLastMsOfDay((Calendar)now);
                this.writer.close();
                if (oldLastOfToday == this.lastMsOfToday) {
                    int i = 1;
                    while (true) {
                        File renameTo;
                        if (!(renameTo = new File(this.logDir, this.writerFileCoreName + "-" + i + this.logFileNameSuffix)).exists()) {
                            this.writerPath.toFile().renameTo(renameTo);
                            break;
                        }
                        ++i;
                    }
                }
                this.writer = this.buildWriter(yyyyMMddNow);
            }
            this.writer.write(payload);
            this.writer.write(10);
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
        }
    }

    private OutputStreamWriter buildWriter(int yyyyMMdd) {
        FileOutputStream fw;
        this.writerFileCoreName = this.buildFileCoreName(yyyyMMdd);
        File currentLogFile = new File(this.logDir, this.writerFileCoreName + this.logFileNameSuffix);
        try {
            fw = new FileOutputStream(currentLogFile, true);
        }
        catch (IOException ex) {
            throw new IllegalStateException("error opening file " + currentLogFile.getPath());
        }
        this.writerPath = currentLogFile.toPath();
        return new OutputStreamWriter(fw);
    }

    private String buildFileCoreName(int yyyyMMdd) {
        int year = yyyyMMdd / 10000;
        int month = yyyyMMdd % 10000 / 100;
        int day = yyyyMMdd % 100;
        String dateStr = year + "." + (month < 10 ? "0" + month : Integer.valueOf(month)) + "." + (day < 10 ? "0" + day : Integer.valueOf(day));
        return this.logFileNamePrefix + dateStr;
    }

    @Override
    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }
}

