/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api;

import java.util.Collections;
import java.util.List;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;

public class CaUris {
    public static final CaUris EMPTY_INSTANCE = new CaUris(null, null, null, null);
    private static final String NAME_CACERT_URIS = "cacert.uris";
    private static final String NAME_OCSP_URIS = "ocsp.uris";
    private static final String NAME_CRL_URIS = "crl.uris";
    private static final String NAME_DELTACRL_URIS = "deltacrl.uris";
    private final List<String> cacertUris;
    private final List<String> ocspUris;
    private final List<String> crlUris;
    private final List<String> deltaCrlUris;

    public CaUris(List<String> cacertUris, List<String> ocspUris, List<String> crlUris, List<String> deltaCrlUris) {
        this.cacertUris = cacertUris == null ? null : Collections.unmodifiableList(cacertUris);
        this.ocspUris = ocspUris == null ? null : Collections.unmodifiableList(ocspUris);
        this.crlUris = crlUris == null ? null : Collections.unmodifiableList(crlUris);
        this.deltaCrlUris = deltaCrlUris == null ? null : Collections.unmodifiableList(deltaCrlUris);
    }

    public List<String> getCacertUris() {
        return this.cacertUris;
    }

    public List<String> getOcspUris() {
        return this.ocspUris;
    }

    public List<String> getCrlUris() {
        return this.crlUris;
    }

    public List<String> getDeltaCrlUris() {
        return this.deltaCrlUris;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CaUris)) {
            return false;
        }
        CaUris other = (CaUris)obj;
        return CompareUtil.equalsObject(this.cacertUris, other.cacertUris) && CompareUtil.equalsObject(this.ocspUris, other.ocspUris) && CompareUtil.equalsObject(this.crlUris, other.crlUris) && CompareUtil.equalsObject(this.deltaCrlUris, other.deltaCrlUris);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CA URIs:");
        sb.append("\n  CACert URIs:").append(CaUris.formatUris(this.cacertUris));
        sb.append("\n  OCSP URIs:").append(CaUris.formatUris(this.ocspUris));
        sb.append("\n  CRL URIs:").append(CaUris.formatUris(this.crlUris));
        sb.append("\n  DeltaCRL URIs:").append(CaUris.formatUris(this.deltaCrlUris));
        return sb.toString();
    }

    private static String formatUris(List<String> uris) {
        if (CollectionUtil.isEmpty(uris)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String uri : uris) {
            sb.append("\n    ").append(uri);
        }
        return sb.toString();
    }

    public static CaUris decode(String encoded) {
        ConfPairs pairs = new ConfPairs(encoded);
        return new CaUris(StringUtil.split((String)pairs.value(NAME_CACERT_URIS), (String)"|"), StringUtil.split((String)pairs.value(NAME_OCSP_URIS), (String)"|"), StringUtil.split((String)pairs.value(NAME_CRL_URIS), (String)"|"), StringUtil.split((String)pairs.value(NAME_DELTACRL_URIS), (String)"|"));
    }

    public String getEncoded() {
        String str;
        ConfPairs pairs = new ConfPairs();
        if (!CollectionUtil.isEmpty(this.cacertUris)) {
            str = StringUtil.collectionAsString(this.cacertUris, (String)"|");
            pairs.putPair(NAME_CACERT_URIS, str);
        }
        if (!CollectionUtil.isEmpty(this.ocspUris)) {
            str = StringUtil.collectionAsString(this.ocspUris, (String)"|");
            pairs.putPair(NAME_OCSP_URIS, str);
        }
        if (!CollectionUtil.isEmpty(this.crlUris)) {
            str = StringUtil.collectionAsString(this.crlUris, (String)"|");
            pairs.putPair(NAME_CRL_URIS, str);
        }
        if (!CollectionUtil.isEmpty(this.deltaCrlUris)) {
            str = StringUtil.collectionAsString(this.deltaCrlUris, (String)"|");
            pairs.putPair(NAME_DELTACRL_URIS, str);
        }
        return pairs.getEncoded();
    }
}

