/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api;

import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.RequestType;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.X509Cert;
import org.xipki.util.ParamUtil;

public class CertificateInfo {
    private final byte[] subjectPublicKey;
    private final CertWithDbId cert;
    private final PrivateKeyInfo privateKey;
    private final NameId issuer;
    private final X509Cert issuerCert;
    private final NameId profile;
    private final NameId requestor;
    private RequestType reqType;
    private byte[] transactionId;
    private Integer user;
    private String warningMessage;
    private CertRevocationInfo revocationInfo;
    private X500Name requestedSubject;
    private boolean alreadyIssued;

    public CertificateInfo(CertWithDbId cert, PrivateKeyInfo privateKey, NameId issuer, X509Cert issuerCert, byte[] subjectPublicKey, NameId profile, NameId requestor) {
        this.profile = (NameId)ParamUtil.requireNonNull((String)"profile", (Object)profile);
        this.cert = (CertWithDbId)((Object)ParamUtil.requireNonNull((String)"cert", (Object)((Object)cert)));
        this.privateKey = privateKey;
        this.subjectPublicKey = (byte[])ParamUtil.requireNonNull((String)"subjectPublicKey", (Object)subjectPublicKey);
        this.issuer = (NameId)ParamUtil.requireNonNull((String)"issuer", (Object)issuer);
        this.issuerCert = (X509Cert)ParamUtil.requireNonNull((String)"issuerCert", (Object)issuerCert);
        this.requestor = (NameId)ParamUtil.requireNonNull((String)"requestor", (Object)requestor);
    }

    public byte[] getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public CertWithDbId getCert() {
        return this.cert;
    }

    public PrivateKeyInfo getPrivateKey() {
        return this.privateKey;
    }

    public NameId getIssuer() {
        return this.issuer;
    }

    public X509Cert getIssuerCert() {
        return this.issuerCert;
    }

    public NameId getProfile() {
        return this.profile;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public NameId getRequestor() {
        return this.requestor;
    }

    public Integer getUser() {
        return this.user;
    }

    public void setUser(Integer user) {
        this.user = user;
    }

    public boolean isRevoked() {
        return this.revocationInfo != null;
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.revocationInfo;
    }

    public void setRevocationInfo(CertRevocationInfo revocationInfo) {
        this.revocationInfo = revocationInfo;
    }

    public boolean isAlreadyIssued() {
        return this.alreadyIssued;
    }

    public void setAlreadyIssued(boolean alreadyIssued) {
        this.alreadyIssued = alreadyIssued;
    }

    public RequestType getReqType() {
        return this.reqType;
    }

    public void setReqType(RequestType reqType) {
        this.reqType = reqType;
    }

    public byte[] getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(byte[] transactionId) {
        this.transactionId = transactionId;
    }

    public X500Name getRequestedSubject() {
        return this.requestedSubject;
    }

    public void setRequestedSubject(X500Name requestedSubject) {
        this.requestedSubject = requestedSubject;
    }
}

