/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.OperationException;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.ConfPairs;
import org.xipki.util.ParamUtil;

public class PublicCaInfo {
    private final X500Principal subject;
    private final X500Name x500Subject;
    private final String c14nSubject;
    private final byte[] subjectKeyIdentifier;
    private final GeneralNames subjectAltName;
    private final BigInteger serialNumber;
    private final X509Cert caCert;
    private X509Certificate crlSignerCert;
    private final CaUris caUris;
    private final ConfPairs extraControl;

    public PublicCaInfo(X509Certificate caCert, CaUris caUris, ConfPairs extraControl) throws OperationException {
        ParamUtil.requireNonNull((String)"caCert", (Object)caCert);
        this.caUris = caUris == null ? CaUris.EMPTY_INSTANCE : caUris;
        this.caCert = new X509Cert(caCert);
        this.serialNumber = caCert.getSerialNumber();
        this.subject = caCert.getSubjectX500Principal();
        this.x500Subject = X500Name.getInstance((Object)this.subject.getEncoded());
        this.c14nSubject = X509Util.canonicalizName((X500Name)this.x500Subject);
        try {
            this.subjectKeyIdentifier = X509Util.extractSki((X509Certificate)caCert);
        }
        catch (CertificateEncodingException ex) {
            throw new OperationException(OperationException.ErrorCode.INVALID_EXTENSION, (Throwable)ex);
        }
        this.extraControl = extraControl;
        byte[] encodedSubjectAltName = caCert.getExtensionValue(Extension.subjectAlternativeName.getId());
        if (encodedSubjectAltName == null) {
            this.subjectAltName = null;
        } else {
            try {
                this.subjectAltName = GeneralNames.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])encodedSubjectAltName));
            }
            catch (IOException ex) {
                throw new OperationException(OperationException.ErrorCode.INVALID_EXTENSION, "invalid SubjectAltName extension in CA certificate");
            }
        }
    }

    public PublicCaInfo(X500Name subject, BigInteger serialNumber, GeneralNames subjectAltName, byte[] subjectKeyIdentifier, CaUris caUris, ConfPairs extraControl) throws OperationException {
        this.x500Subject = (X500Name)ParamUtil.requireNonNull((String)"subject", (Object)subject);
        this.serialNumber = (BigInteger)ParamUtil.requireNonNull((String)"serialNumber", (Object)serialNumber);
        this.caUris = caUris == null ? CaUris.EMPTY_INSTANCE : caUris;
        this.caCert = null;
        this.c14nSubject = X509Util.canonicalizName((X500Name)subject);
        try {
            this.subject = new X500Principal(subject.getEncoded());
        }
        catch (IOException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "invalid SubjectAltName extension in CA certificate");
        }
        this.subjectKeyIdentifier = subjectKeyIdentifier == null ? null : Arrays.copyOf(subjectKeyIdentifier, subjectKeyIdentifier.length);
        this.subjectAltName = subjectAltName;
        this.extraControl = extraControl;
    }

    public CaUris getCaUris() {
        return this.caUris;
    }

    public X509Certificate getCrlSignerCert() {
        return this.crlSignerCert;
    }

    public void setCrlSignerCert(X509Certificate crlSignerCert) {
        this.crlSignerCert = this.caCert.getCert().equals(crlSignerCert) ? null : crlSignerCert;
    }

    public X500Principal getSubject() {
        return this.subject;
    }

    public X500Name getX500Subject() {
        return this.x500Subject;
    }

    public String getC14nSubject() {
        return this.c14nSubject;
    }

    public GeneralNames getSubjectAltName() {
        return this.subjectAltName;
    }

    public byte[] getSubjectKeyIdentifer() {
        if (this.caCert != null) {
            return this.caCert.getSubjectKeyIdentifier();
        }
        return this.subjectKeyIdentifier == null ? null : Arrays.copyOf(this.subjectKeyIdentifier, this.subjectKeyIdentifier.length);
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X509Cert getCaCert() {
        return this.caCert;
    }

    public ConfPairs getExtraControl() {
        return this.extraControl;
    }
}

