/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherFactory;
import org.xipki.ca.api.publisher.CertPublisherFactoryRegister;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.ParamUtil;

public class CertPublisherFactoryRegisterImpl
implements CertPublisherFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(CertPublisherFactoryRegisterImpl.class);
    private ConcurrentLinkedDeque<CertPublisherFactory> services = new ConcurrentLinkedDeque();

    @Override
    public boolean canCreatePublisher(String type) {
        for (CertPublisherFactory service : this.services) {
            if (!service.canCreatePublisher(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CertPublisher newPublisher(String type) throws ObjectCreationException {
        ParamUtil.requireNonBlank((String)"type", (String)type);
        for (CertPublisherFactory service : this.services) {
            if (!service.canCreatePublisher(type)) continue;
            return service.newPublisher(type);
        }
        throw new ObjectCreationException("could not find factory to create Publisher of type " + type);
    }

    @Override
    public Set<String> getSupportedTypes() {
        HashSet<String> types = new HashSet<String>();
        for (CertPublisherFactory service : this.services) {
            types.addAll(service.getSupportedTypes());
        }
        return Collections.unmodifiableSet(types);
    }

    public void bindService(CertPublisherFactory service) {
        if (service == null) {
            LOG.info("bindService invoked with null.");
            return;
        }
        boolean replaced = this.services.remove(service);
        this.services.add(service);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} CertPublisherFactory binding for {}", (Object)action, (Object)service);
    }

    public void unbindService(CertPublisherFactory service) {
        if (service == null) {
            LOG.info("unbindService invoked with null.");
            return;
        }
        if (this.services.remove(service)) {
            LOG.info("removed CertPublisherFactory binding for {}", (Object)service);
        } else {
            LOG.info("no CertPublisherFactory binding found to remove for {}", (Object)service);
        }
    }
}

