/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileFactory;
import org.xipki.ca.api.profile.CertprofileFactoryRegister;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.ParamUtil;

public class CertprofileFactoryRegisterImpl
implements CertprofileFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(CertprofileFactoryRegisterImpl.class);
    private ConcurrentLinkedDeque<CertprofileFactory> services = new ConcurrentLinkedDeque();

    @Override
    public Set<String> getSupportedTypes() {
        HashSet<String> types = new HashSet<String>();
        for (CertprofileFactory service : this.services) {
            types.addAll(service.getSupportedTypes());
        }
        return Collections.unmodifiableSet(types);
    }

    @Override
    public boolean canCreateProfile(String type) {
        for (CertprofileFactory service : this.services) {
            if (!service.canCreateProfile(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Certprofile newCertprofile(String type) throws ObjectCreationException {
        ParamUtil.requireNonBlank((String)"type", (String)type);
        for (CertprofileFactory service : this.services) {
            if (!service.canCreateProfile(type)) continue;
            return service.newCertprofile(type);
        }
        throw new ObjectCreationException("could not find factory to create Certprofile of type '" + type + "'");
    }

    public void bindService(CertprofileFactory service) {
        if (service == null) {
            LOG.info("bindService invoked with null.");
            return;
        }
        boolean replaced = this.services.remove(service);
        this.services.add(service);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} CertprofileFactory binding for {}", (Object)action, (Object)service);
    }

    public void unbindService(CertprofileFactory service) {
        if (service == null) {
            LOG.debug("unbindService invoked with null.");
            return;
        }
        if (this.services.remove(service)) {
            LOG.info("removed CertprofileFactory binding for {}", (Object)service);
        } else {
            LOG.info("no CertprofileFactory binding found to remove for '{}'", (Object)service);
        }
    }
}

