/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.math.ec.ECCurve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.ca.api.profile.Range;
import org.xipki.ca.api.profile.RdnControl;
import org.xipki.ca.api.profile.StringType;
import org.xipki.ca.api.profile.SubjectControl;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.ca.api.profile.SubjectInfo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.LruCache;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public abstract class BaseCertprofile
extends Certprofile {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCertprofile.class);
    private static LruCache<ASN1ObjectIdentifier, Integer> ecCurveFieldSizes = new LruCache(100);

    protected BaseCertprofile() {
    }

    public abstract Map<ASN1ObjectIdentifier, KeyParametersOption> getKeyAlgorithms();

    protected abstract SubjectControl getSubjectControl();

    @Override
    public Date getNotBefore(Date requestedNotBefore) {
        Date now = new Date();
        return requestedNotBefore != null && requestedNotBefore.after(now) ? requestedNotBefore : now;
    }

    @Override
    public SubjectInfo getSubject(X500Name requestedSubject) throws CertprofileException, BadCertTemplateException {
        ParamUtil.requireNonNull((String)"requestedSubject", (Object)requestedSubject);
        this.verifySubjectDnOccurence(requestedSubject);
        RDN[] requstedRdns = requestedSubject.getRDNs();
        SubjectControl scontrol = this.getSubjectControl();
        AbstractList rdns = new LinkedList();
        for (ASN1ObjectIdentifier type : scontrol.getTypes()) {
            int len;
            RDN[] thisRdns;
            RdnControl control = scontrol.getControl(type);
            if (control == null || (thisRdns = BaseCertprofile.getRdns(requstedRdns, type)) == null || (len = thisRdns.length) == 0) continue;
            if (ObjectIdentifiers.DN_EmailAddress.equals((Object)type)) {
                throw new BadCertTemplateException("emailAddress is not allowed");
            }
            if (len == 1) {
                RDN rdn;
                ASN1Encodable rdnValue = thisRdns[0].getFirst().getValue();
                if (ObjectIdentifiers.DN_DATE_OF_BIRTH.equals((Object)type)) {
                    rdn = BaseCertprofile.createDateOfBirthRdn(type, rdnValue);
                } else if (ObjectIdentifiers.DN_POSTAL_ADDRESS.equals((Object)type)) {
                    rdn = BaseCertprofile.createPostalAddressRdn(type, rdnValue, control, 0);
                } else {
                    String[] value = X509Util.rdnValueToString((ASN1Encodable)rdnValue);
                    rdn = this.createSubjectRdn((String)value, type, control, 0);
                }
                if (rdn == null) continue;
                rdns.add(rdn);
                continue;
            }
            if (ObjectIdentifiers.DN_DATE_OF_BIRTH.equals((Object)type)) {
                for (int i = 0; i < len; ++i) {
                    RDN rdn = BaseCertprofile.createDateOfBirthRdn(type, thisRdns[i].getFirst().getValue());
                    rdns.add(rdn);
                }
                continue;
            }
            if (ObjectIdentifiers.DN_POSTAL_ADDRESS.equals((Object)type)) {
                for (int i = 0; i < len; ++i) {
                    RDN rdn = BaseCertprofile.createPostalAddressRdn(type, thisRdns[i].getFirst().getValue(), control, i);
                    rdns.add(rdn);
                }
                continue;
            }
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = X509Util.rdnValueToString((ASN1Encodable)thisRdns[i].getFirst().getValue());
            }
            int idx = 0;
            for (String value : values) {
                rdns.add(this.createSubjectRdn(value, type, control, idx++));
            }
        }
        Set<String> subjectDnGroups = scontrol.getGroups();
        if (CollectionUtil.isNonEmpty(subjectDnGroups)) {
            HashSet<String> consideredGroups = new HashSet<String>();
            int n = rdns.size();
            ArrayList<RDN> newRdns = new ArrayList<RDN>(rdns.size());
            for (int i = 0; i < n; ++i) {
                RDN rdn = (RDN)rdns.get(i);
                ASN1ObjectIdentifier type = rdn.getFirst().getType();
                String group = scontrol.getGroup(type);
                if (group == null) {
                    newRdns.add(rdn);
                    continue;
                }
                if (consideredGroups.contains(group)) continue;
                LinkedList<AttributeTypeAndValue> atvs = new LinkedList<AttributeTypeAndValue>();
                atvs.add(rdn.getFirst());
                for (int j = i + 1; j < n; ++j) {
                    RDN rdn2 = (RDN)rdns.get(j);
                    ASN1ObjectIdentifier type2 = rdn2.getFirst().getType();
                    String group2 = scontrol.getGroup(type2);
                    if (!group.equals(group2)) continue;
                    atvs.add(rdn2.getFirst());
                }
                newRdns.add(new RDN(atvs.toArray(new AttributeTypeAndValue[0])));
                consideredGroups.add(group);
            }
            rdns = newRdns;
        }
        X500Name grantedSubject = new X500Name(rdns.toArray(new RDN[0]));
        return new SubjectInfo(grantedSubject, null);
    }

    @Override
    public boolean incSerialNumberIfSubjectExists() {
        return false;
    }

    @Override
    public SubjectPublicKeyInfo checkPublicKey(SubjectPublicKeyInfo publicKey) throws CertprofileException, BadCertTemplateException {
        ParamUtil.requireNonNull((String)"publicKey", (Object)publicKey);
        Map<ASN1ObjectIdentifier, KeyParametersOption> keyAlgorithms = this.getKeyAlgorithms();
        if (CollectionUtil.isEmpty(keyAlgorithms)) {
            return publicKey;
        }
        ASN1ObjectIdentifier keyType = publicKey.getAlgorithm().getAlgorithm();
        if (!keyAlgorithms.containsKey(keyType)) {
            throw new BadCertTemplateException("key type " + keyType.getId() + " is not permitted");
        }
        KeyParametersOption keyParamsOption = keyAlgorithms.get(keyType);
        if (keyParamsOption instanceof KeyParametersOption.AllowAllParametersOption) {
            return publicKey;
        }
        if (keyParamsOption instanceof KeyParametersOption.ECParamatersOption) {
            byte[] keyData;
            ASN1ObjectIdentifier curveOid;
            KeyParametersOption.ECParamatersOption ecOption = (KeyParametersOption.ECParamatersOption)keyParamsOption;
            ASN1Encodable algParam = publicKey.getAlgorithm().getParameters();
            if (algParam instanceof ASN1ObjectIdentifier) {
                curveOid = (ASN1ObjectIdentifier)algParam;
                if (!ecOption.allowsCurve(curveOid)) {
                    throw new BadCertTemplateException(String.format("EC curve %s (OID: %s) is not allowed", AlgorithmUtil.getCurveName((ASN1ObjectIdentifier)curveOid), curveOid.getId()));
                }
            } else {
                throw new BadCertTemplateException("only namedCurve EC public key is supported");
            }
            if (ecOption.pointEncodings() != null) {
                keyData = publicKey.getPublicKeyData().getBytes();
                if (keyData.length < 1) {
                    throw new BadCertTemplateException("invalid publicKeyData");
                }
                byte pointEncoding = keyData[0];
                if (!ecOption.pointEncodings().contains(pointEncoding)) {
                    throw new BadCertTemplateException(String.format("not accepted EC point encoding '%s'", pointEncoding));
                }
            }
            keyData = publicKey.getPublicKeyData().getBytes();
            try {
                BaseCertprofile.checkEcSubjectPublicKeyInfo(curveOid, keyData);
            }
            catch (BadCertTemplateException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"checkEcSubjectPublicKeyInfo");
                throw new BadCertTemplateException(String.format("invalid public key: %s", ex.getMessage()));
            }
            return publicKey;
        }
        if (keyParamsOption instanceof KeyParametersOption.RSAParametersOption) {
            ASN1Integer modulus;
            KeyParametersOption.RSAParametersOption rsaOption = (KeyParametersOption.RSAParametersOption)keyParamsOption;
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)publicKey.getPublicKeyData().getBytes());
                modulus = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
            }
            catch (IllegalArgumentException ex) {
                throw new BadCertTemplateException("invalid publicKeyData");
            }
            int modulusLength = modulus.getPositiveValue().bitLength();
            if (rsaOption.allowsModulusLength(modulusLength)) {
                return publicKey;
            }
        } else if (keyParamsOption instanceof KeyParametersOption.DSAParametersOption) {
            int qlength;
            int plength;
            KeyParametersOption.DSAParametersOption dsaOption = (KeyParametersOption.DSAParametersOption)keyParamsOption;
            ASN1Encodable params = publicKey.getAlgorithm().getParameters();
            if (params == null) {
                throw new BadCertTemplateException("null Dss-Parms is not permitted");
            }
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)params);
                ASN1Integer rsaP = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
                ASN1Integer rsaQ = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
                plength = rsaP.getPositiveValue().bitLength();
                qlength = rsaQ.getPositiveValue().bitLength();
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
                throw new BadCertTemplateException("illegal Dss-Parms");
            }
            boolean match = dsaOption.allowsPlength(plength);
            if (match) {
                match = dsaOption.allowsQlength(qlength);
            }
            if (match) {
                return publicKey;
            }
        } else {
            throw new RuntimeException(String.format("should not reach here, unknown KeyParametersOption %s", keyParamsOption));
        }
        throw new BadCertTemplateException("the given publicKey is not permitted");
    }

    @Override
    public void initialize(String data) throws CertprofileException {
    }

    protected void verifySubjectDnOccurence(X500Name requestedSubject) throws BadCertTemplateException {
        ParamUtil.requireNonNull((String)"requestedSubject", (Object)requestedSubject);
        SubjectControl occurences = this.getSubjectControl();
        if (occurences == null) {
            return;
        }
        ASN1ObjectIdentifier[] types = requestedSubject.getAttributeTypes();
        for (ASN1ObjectIdentifier type : types) {
            RdnControl occu = occurences.getControl(type);
            if (occu == null) {
                throw new BadCertTemplateException(String.format("subject DN of type %s is not allowed", BaseCertprofile.oidToDisplayName(type)));
            }
            RDN[] rdns = requestedSubject.getRDNs(type);
            if (rdns.length <= occu.getMaxOccurs() && rdns.length >= occu.getMinOccurs()) continue;
            throw new BadCertTemplateException(String.format("occurrence of subject DN of type %s not within the allowed range. %d is not within [%d, %d]", BaseCertprofile.oidToDisplayName(type), rdns.length, occu.getMinOccurs(), occu.getMaxOccurs()));
        }
        for (ASN1ObjectIdentifier m : occurences.getTypes()) {
            RdnControl occurence = occurences.getControl(m);
            if (occurence.getMinOccurs() == 0) continue;
            boolean present = false;
            for (ASN1ObjectIdentifier type : types) {
                if (!occurence.getType().equals((Object)type)) continue;
                present = true;
                break;
            }
            if (present) continue;
            throw new BadCertTemplateException(String.format("required subject DN of type %s is not present", BaseCertprofile.oidToDisplayName(occurence.getType())));
        }
    }

    protected RDN createSubjectRdn(String text, ASN1ObjectIdentifier type, RdnControl option, int index) throws BadCertTemplateException {
        ASN1Encodable rdnValue = BaseCertprofile.createRdnValue(text, type, option, index);
        return rdnValue == null ? null : new RDN(type, rdnValue);
    }

    private static RDN createDateOfBirthRdn(ASN1ObjectIdentifier type, ASN1Encodable rdnValue) throws BadCertTemplateException {
        String text;
        ParamUtil.requireNonNull((String)"type", (Object)type);
        ASN1Encodable newRdnValue = null;
        if (rdnValue instanceof ASN1GeneralizedTime) {
            text = ((ASN1GeneralizedTime)rdnValue).getTimeString();
            newRdnValue = rdnValue;
        } else if (rdnValue instanceof ASN1String && !(rdnValue instanceof DERUniversalString)) {
            text = ((ASN1String)rdnValue).getString();
        } else {
            throw new BadCertTemplateException("Value of RDN dateOfBirth has incorrect syntax");
        }
        if (!SubjectDnSpec.PATTERN_DATE_OF_BIRTH.matcher(text).matches()) {
            throw new BadCertTemplateException("Value of RDN dateOfBirth does not have format YYYMMDD000000Z");
        }
        if (newRdnValue == null) {
            newRdnValue = new DERGeneralizedTime(text);
        }
        return new RDN(type, newRdnValue);
    }

    private static RDN createPostalAddressRdn(ASN1ObjectIdentifier type, ASN1Encodable rdnValue, RdnControl control, int index) throws BadCertTemplateException {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        if (!(rdnValue instanceof ASN1Sequence)) {
            throw new BadCertTemplateException("rdnValue of RDN postalAddress has incorrect syntax");
        }
        ASN1Sequence seq = (ASN1Sequence)rdnValue;
        int size = seq.size();
        if (size < 1 || size > 6) {
            throw new BadCertTemplateException("Sequence size of RDN postalAddress is not within [1, 6]: " + size);
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i < size; ++i) {
            ASN1Encodable line = seq.getObjectAt(i);
            if (!(line instanceof ASN1String) || line instanceof DERUniversalString) {
                throw new BadCertTemplateException(String.format("postalAddress[%d] has incorrect syntax", i));
            }
            String text = ((ASN1String)line).getString();
            ASN1Encodable asn1Line = BaseCertprofile.createRdnValue(text, type, control, index);
            vec.add(asn1Line);
        }
        return new RDN(type, (ASN1Encodable)new DERSequence(vec));
    }

    private static RDN[] getRdns(RDN[] rdns, ASN1ObjectIdentifier type) {
        ParamUtil.requireNonNull((String)"rdns", (Object)rdns);
        ParamUtil.requireNonNull((String)"type", (Object)type);
        ArrayList<RDN> ret = new ArrayList<RDN>(1);
        for (int i = 0; i < rdns.length; ++i) {
            RDN rdn = rdns[i];
            if (!rdn.getFirst().getType().equals((Object)type)) continue;
            ret.add(rdn);
        }
        return CollectionUtil.isEmpty(ret) ? null : ret.toArray(new RDN[0]);
    }

    private static ASN1Encodable createRdnValue(String text, ASN1ObjectIdentifier type, RdnControl option, int index) throws BadCertTemplateException {
        String tmpText = text.trim();
        StringType stringType = null;
        if (option != null) {
            Integer maxLen;
            Integer minLen;
            Pattern pattern;
            stringType = option.getStringType();
            String prefix = option.getPrefix();
            String suffix = option.getSuffix();
            if (prefix != null || suffix != null) {
                String locTmpText = tmpText.toLowerCase();
                if (prefix != null && locTmpText.startsWith(prefix.toLowerCase())) {
                    tmpText = tmpText.substring(prefix.length());
                    locTmpText = tmpText.toLowerCase();
                }
                if (suffix != null && locTmpText.endsWith(suffix.toLowerCase())) {
                    tmpText = tmpText.substring(0, tmpText.length() - suffix.length());
                }
            }
            if ((pattern = option.getPattern()) != null && !pattern.matcher(tmpText).matches()) {
                throw new BadCertTemplateException(String.format("invalid subject %s '%s' against regex '%s'", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type), tmpText, pattern.pattern()));
            }
            tmpText = StringUtil.concat((String)(prefix != null ? prefix : ""), (String[])new String[]{tmpText, suffix != null ? suffix : ""});
            int len = tmpText.length();
            Range range = option.getStringLengthRange();
            Integer n = minLen = range == null ? null : range.getMin();
            if (minLen != null && len < minLen) {
                throw new BadCertTemplateException(String.format("subject %s '%s' is too short (length (%d) < minLen (%d))", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type), tmpText, len, minLen));
            }
            Integer n2 = maxLen = range == null ? null : range.getMax();
            if (maxLen != null && len > maxLen) {
                throw new BadCertTemplateException(String.format("subject %s '%s' is too long (length (%d) > maxLen (%d))", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type), tmpText, len, maxLen));
            }
        }
        if (stringType == null) {
            stringType = StringType.utf8String;
        }
        return stringType.createString(tmpText.trim());
    }

    private static String oidToDisplayName(ASN1ObjectIdentifier type) {
        return ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type);
    }

    private static void checkEcSubjectPublicKeyInfo(ASN1ObjectIdentifier curveOid, byte[] encoded) throws BadCertTemplateException {
        ParamUtil.requireNonNull((String)"curveOid", (Object)curveOid);
        ParamUtil.requireNonNull((String)"encoded", (Object)encoded);
        ParamUtil.requireMin((String)"encoded.length", (int)encoded.length, (int)1);
        Integer expectedLength = (Integer)ecCurveFieldSizes.get((Object)curveOid);
        if (expectedLength == null) {
            X9ECParameters ecP = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)curveOid);
            ECCurve curve = ecP.getCurve();
            expectedLength = (curve.getFieldSize() + 7) / 8;
            ecCurveFieldSizes.put((Object)curveOid, (Object)expectedLength);
        }
        switch (encoded[0]) {
            case 2: 
            case 3: {
                if (encoded.length == expectedLength + 1) break;
                throw new BadCertTemplateException("incorrect length for compressed encoding");
            }
            case 4: 
            case 6: 
            case 7: {
                if (encoded.length == 2 * expectedLength + 1) break;
                throw new BadCertTemplateException("incorrect length for uncompressed/hybrid encoding");
            }
            default: {
                throw new BadCertTemplateException(String.format("invalid point encoding 0x%02x", encoded[0]));
            }
        }
    }
}

