/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.xipki.util.ParamUtil;

public class CertValidity
implements Comparable<CertValidity> {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private final int validity;
    private final Unit unit;

    public CertValidity(int validity, Unit unit) {
        this.validity = ParamUtil.requireMin((String)"validity", (int)validity, (int)1);
        this.unit = (Unit)((Object)ParamUtil.requireNonNull((String)"unit", (Object)((Object)unit)));
    }

    public static CertValidity getInstance(String validityS) {
        int validity;
        String numValdityS;
        Unit unit;
        ParamUtil.requireNonBlank((String)"validityS", (String)validityS);
        int len = validityS.length();
        char suffix = validityS.charAt(len - 1);
        if (suffix == 'y' || suffix == 'Y') {
            unit = Unit.YEAR;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'd' || suffix == 'D') {
            unit = Unit.DAY;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'h' || suffix == 'H') {
            unit = Unit.HOUR;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'm' || suffix == 'M') {
            unit = Unit.MINUTE;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix >= '0' && suffix <= '9') {
            unit = Unit.DAY;
            numValdityS = validityS;
        } else {
            throw new IllegalArgumentException(String.format("invalid validityS: %s", validityS));
        }
        try {
            validity = Integer.parseInt(numValdityS);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("invalid validityS: %s", validityS));
        }
        return new CertValidity(validity, unit);
    }

    public int getValidity() {
        return this.validity;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Date add(Date referenceDate) {
        switch (this.unit) {
            case DAY: {
                return new Date(referenceDate.getTime() + 86400000L - 1000L);
            }
            case YEAR: {
                int day;
                Calendar cal = Calendar.getInstance(TIMEZONE_UTC);
                cal.setTime(referenceDate);
                cal.add(1, this.validity);
                cal.add(13, -1);
                int month = cal.get(2);
                if (month == 1 && (day = cal.get(5)) > 28) {
                    int year = cal.get(1);
                    day = CertValidity.isLeapYear(year) ? 29 : 28;
                }
                return cal.getTime();
            }
            case HOUR: {
                return new Date(referenceDate.getTime() + 3600000L - 1000L);
            }
            case MINUTE: {
                return new Date(referenceDate.getTime() + 60000L - 1000L);
            }
        }
        throw new RuntimeException(String.format("should not reach here, unknown CertValidity.Unit %s", new Object[]{this.unit}));
    }

    private int approxMinutes() {
        switch (this.unit) {
            case HOUR: {
                return 60 * this.validity;
            }
            case DAY: {
                return 1440 * this.validity;
            }
            case YEAR: {
                return (8760 * this.validity + 6 * this.validity) * 60;
            }
        }
        throw new RuntimeException(String.format("should not reach here, unknown CertValidity.Unit %s", new Object[]{this.unit}));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(CertValidity obj) {
        int thatMinutes;
        ParamUtil.requireNonNull((String)"obj", (Object)obj);
        if (this.unit == obj.unit) {
            if (this.validity == obj.validity) {
                return 0;
            }
            return this.validity < obj.validity ? -1 : 1;
        }
        int thisMinutes = this.approxMinutes();
        if (thisMinutes == (thatMinutes = obj.approxMinutes())) {
            return 0;
        }
        return thisMinutes < thatMinutes ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertValidity)) {
            return false;
        }
        CertValidity other = (CertValidity)obj;
        return this.unit == other.unit && this.validity == other.validity;
    }

    public String toString() {
        switch (this.unit) {
            case HOUR: {
                return this.validity + "h";
            }
            case DAY: {
                return this.validity + "d";
            }
            case YEAR: {
                return this.validity + "y";
            }
        }
        throw new RuntimeException(String.format("should not reach here, unknown CertValidity.Unit %s", new Object[]{this.unit}));
    }

    private static boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 100 != 0) {
            return true;
        }
        return year % 400 == 0;
    }

    public static enum Unit {
        YEAR("y"),
        DAY("d"),
        HOUR("h"),
        MINUTE("m");

        private String suffix;

        private Unit(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

