/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.BadFormatException;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.profile.AuthorityInfoAccessControl;
import org.xipki.ca.api.profile.CertLevel;
import org.xipki.ca.api.profile.CertValidity;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtKeyUsageControl;
import org.xipki.ca.api.profile.ExtensionControl;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.GeneralNameMode;
import org.xipki.ca.api.profile.KeyUsageControl;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.api.profile.SubjectInfo;
import org.xipki.ca.api.profile.X509CertVersion;

public abstract class Certprofile {
    public boolean isOnlyForRa() {
        return false;
    }

    public void shutdown() {
    }

    public X509CertVersion getVersion() {
        return X509CertVersion.v3;
    }

    public List<String> getSignatureAlgorithms() {
        return null;
    }

    public boolean includesIssuerAndSerialInAki() {
        return false;
    }

    public AuthorityInfoAccessControl getAiaControl() {
        return null;
    }

    public String incSerialNumber(String currentSerialNumber) throws BadFormatException {
        try {
            long currentSn;
            long l = currentSn = currentSerialNumber == null ? 0L : Long.parseLong(currentSerialNumber.trim());
            if (currentSn < 0L) {
                throw new BadFormatException("invalid currentSerialNumber " + currentSerialNumber);
            }
            return Long.toString(currentSn + 1L);
        }
        catch (NumberFormatException ex) {
            throw new BadFormatException(String.format("invalid serialNumber attribute %s", currentSerialNumber));
        }
    }

    public boolean isSerialNumberInReqPermitted() {
        return true;
    }

    public Set<ExtKeyUsageControl> getExtendedKeyUsages() {
        return null;
    }

    public Map<ASN1ObjectIdentifier, Set<GeneralNameMode>> getSubjectInfoAccessModes() {
        return null;
    }

    public abstract Map<ASN1ObjectIdentifier, ExtensionControl> getExtensionControls();

    public abstract void initialize(String var1) throws CertprofileException;

    public abstract CertLevel getCertLevel();

    public KeypairGenControl getKeypairGenControl() {
        return KeypairGenControl.ForbiddenKeypairGenControl.INSTANCE;
    }

    public abstract Set<KeyUsageControl> getKeyUsage();

    public abstract Integer getPathLenBasicConstraint();

    public abstract Date getNotBefore(Date var1);

    public abstract CertValidity getValidity();

    public abstract SubjectPublicKeyInfo checkPublicKey(SubjectPublicKeyInfo var1) throws CertprofileException, BadCertTemplateException;

    public abstract SubjectInfo getSubject(X500Name var1) throws CertprofileException, BadCertTemplateException;

    public abstract ExtensionValues getExtensions(Map<ASN1ObjectIdentifier, ExtensionControl> var1, X500Name var2, X500Name var3, Extensions var4, Date var5, Date var6, PublicCaInfo var7) throws CertprofileException, BadCertTemplateException;

    public abstract boolean incSerialNumberIfSubjectExists();

    public int getMaxCertSize() {
        return 0;
    }
}

