/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.profile.GeneralNameMode;
import org.xipki.util.ParamUtil;

public class CertprofileUtil {
    public static GeneralName createGeneralName(GeneralName requestedName, Set<GeneralNameMode> modes) throws BadCertTemplateException {
        ParamUtil.requireNonNull((String)"requestedName", (Object)requestedName);
        int tag = requestedName.getTagNo();
        GeneralNameMode mode = null;
        if (modes != null) {
            for (GeneralNameMode m : modes) {
                if (m.getTag().getTag() != tag) continue;
                mode = m;
                break;
            }
            if (mode == null) {
                throw new BadCertTemplateException("generalName tag " + tag + " is not allowed");
            }
        }
        switch (tag) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return new GeneralName(tag, requestedName.getName());
            }
            case 0: {
                ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)requestedName.getName());
                int size = reqSeq.size();
                if (size != 2) {
                    throw new BadCertTemplateException("invalid otherName sequence: size is not 2: " + size);
                }
                ASN1ObjectIdentifier type = ASN1ObjectIdentifier.getInstance((Object)reqSeq.getObjectAt(0));
                if (mode != null && !mode.getAllowedTypes().contains(type)) {
                    throw new BadCertTemplateException("otherName.type " + type.getId() + " is not allowed");
                }
                ASN1Encodable asn1 = reqSeq.getObjectAt(1);
                if (!(asn1 instanceof ASN1TaggedObject)) {
                    throw new BadCertTemplateException("otherName.value is not tagged Object");
                }
                int tagNo = ASN1TaggedObject.getInstance((Object)asn1).getTagNo();
                if (tagNo != 0) {
                    throw new BadCertTemplateException("otherName.value does not have tag 0: " + tagNo);
                }
                ASN1EncodableVector vector = new ASN1EncodableVector();
                vector.add((ASN1Encodable)type);
                vector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)ASN1TaggedObject.getInstance((Object)asn1).getObject()));
                return new GeneralName(0, (ASN1Encodable)new DERSequence(vector));
            }
            case 5: {
                DirectoryString ds;
                ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)requestedName.getName());
                int size = reqSeq.size();
                String nameAssigner = null;
                int idx = 0;
                if (size > 1) {
                    ds = DirectoryString.getInstance((Object)ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(idx++)).getObject());
                    nameAssigner = ds.getString();
                }
                ds = DirectoryString.getInstance((Object)ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(idx++)).getObject());
                String partyName = ds.getString();
                ASN1EncodableVector vector = new ASN1EncodableVector();
                if (nameAssigner != null) {
                    vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DirectoryString(nameAssigner)));
                }
                vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DirectoryString(partyName)));
                return new GeneralName(5, (ASN1Encodable)new DERSequence(vector));
            }
        }
        throw new RuntimeException("should not reach here, unknown GeneralName tag " + tag);
    }
}

