/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.util.ParamUtil;

public class ExtensionValues {
    private final Map<ASN1ObjectIdentifier, ExtensionValue> extensions = new HashMap<ASN1ObjectIdentifier, ExtensionValue>();

    public boolean addExtension(ASN1ObjectIdentifier type, boolean critical, ASN1Encodable value) {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        ParamUtil.requireNonNull((String)"value", (Object)value);
        if (this.extensions.containsKey(type)) {
            return false;
        }
        this.extensions.put(type, new ExtensionValue(critical, value));
        return true;
    }

    public boolean addExtension(ASN1ObjectIdentifier type, ExtensionValue value) {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        ParamUtil.requireNonNull((String)"value", (Object)value);
        if (this.extensions.containsKey(type)) {
            return false;
        }
        this.extensions.put(type, value);
        return true;
    }

    public Set<ASN1ObjectIdentifier> getExtensionTypes() {
        return Collections.unmodifiableSet(this.extensions.keySet());
    }

    public ExtensionValue getExtensionValue(ASN1ObjectIdentifier type) {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        return this.extensions.get(type);
    }

    public boolean removeExtensionTuple(ASN1ObjectIdentifier type) {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        return this.extensions.remove(type) != null;
    }

    public boolean containsExtension(ASN1ObjectIdentifier type) {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        return this.extensions.containsKey(type);
    }

    public int size() {
        return this.extensions.size();
    }
}

