/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import org.xipki.util.StringUtil;

public class Range {
    private Integer min;
    private Integer max;

    public Range(Integer min, Integer max) {
        this.setRange(min, max);
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setRange(Integer min, Integer max) {
        if (min == null && max == null) {
            throw new IllegalArgumentException("min and max must not be both null");
        }
        if (min != null && max != null && min > max) {
            throw new IllegalArgumentException(String.format("min must not be greater than max: %d > %d", min, max));
        }
        this.min = min;
        this.max = max;
    }

    public boolean match(int val) {
        if (this.min != null && val < this.min) {
            return false;
        }
        return this.max == null || val <= this.max;
    }

    public String toString() {
        return StringUtil.concatObjects((Object)"[", (Object[])new Object[]{this.min == null ? "" : this.min, ",", this.max == null ? "" : this.max, "]"});
    }
}

