/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.ca.api.profile.Range;
import org.xipki.ca.api.profile.StringType;
import org.xipki.util.ParamUtil;

public class RdnControl {
    private final int minOccurs;
    private final int maxOccurs;
    private final ASN1ObjectIdentifier type;
    private Pattern pattern;
    private StringType stringType;
    private Range stringLengthRange;
    private String prefix;
    private String suffix;
    private String group;

    public RdnControl(ASN1ObjectIdentifier type) {
        this(type, 1, 1);
    }

    public RdnControl(ASN1ObjectIdentifier type, int minOccurs, int maxOccurs) {
        if (minOccurs < 0 || maxOccurs < 1 || minOccurs > maxOccurs) {
            throw new IllegalArgumentException(String.format("illegal minOccurs=%s, maxOccurs=%s", minOccurs, maxOccurs));
        }
        this.type = (ASN1ObjectIdentifier)ParamUtil.requireNonNull((String)"type", (Object)type);
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public ASN1ObjectIdentifier getType() {
        return this.type;
    }

    public StringType getStringType() {
        return this.stringType;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Range getStringLengthRange() {
        return this.stringLengthRange;
    }

    public void setStringType(StringType stringType) {
        this.stringType = stringType;
    }

    public void setStringLengthRange(Range stringLengthRange) {
        this.stringLengthRange = stringLengthRange;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

