/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.xipki.util.ParamUtil;

public enum StringType {
    teletexString,
    printableString,
    utf8String,
    bmpString,
    ia5String;


    public ASN1Encodable createString(String text) {
        ParamUtil.requireNonNull((String)"text", (Object)text);
        if (teletexString == this) {
            return new DERT61String(text);
        }
        if (printableString == this) {
            return new DERPrintableString(text);
        }
        if (utf8String == this) {
            return new DERUTF8String(text);
        }
        if (bmpString == this) {
            return new DERBMPString(text);
        }
        if (ia5String == this) {
            return new DERIA5String(text, true);
        }
        throw new RuntimeException("should not reach here, unknown StringType " + this.name());
    }
}

