/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.ca.api.profile.RdnControl;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class SubjectControl {
    private final Map<ASN1ObjectIdentifier, RdnControl> controls;
    private final Map<ASN1ObjectIdentifier, String> typeGroups;
    private final Map<String, Set<ASN1ObjectIdentifier>> groupTypes;
    private final Set<String> groups;
    private final List<ASN1ObjectIdentifier> types;

    public SubjectControl(List<RdnControl> controls, boolean keepRdnOrder) {
        ParamUtil.requireNonEmpty((String)"controls", controls);
        this.typeGroups = new HashMap<ASN1ObjectIdentifier, String>();
        ArrayList<ASN1ObjectIdentifier> sortedOids = new ArrayList<ASN1ObjectIdentifier>(controls.size());
        if (keepRdnOrder) {
            for (RdnControl rdnControl : controls) {
                sortedOids.add(rdnControl.getType());
            }
        } else {
            HashSet<ASN1ObjectIdentifier> oidSet = new HashSet<ASN1ObjectIdentifier>();
            for (RdnControl rdnControl : controls) {
                oidSet.add(rdnControl.getType());
            }
            List<ASN1ObjectIdentifier> list = SubjectDnSpec.getForwardDNs();
            for (ASN1ObjectIdentifier oid : list) {
                if (!oidSet.contains(oid)) continue;
                sortedOids.add(oid);
            }
            for (ASN1ObjectIdentifier oid : oidSet) {
                if (sortedOids.contains(oid)) continue;
                sortedOids.add(oid);
            }
        }
        this.types = Collections.unmodifiableList(sortedOids);
        HashSet<String> groupSet = new HashSet<String>();
        this.groupTypes = new HashMap<String, Set<ASN1ObjectIdentifier>>();
        this.controls = new HashMap<ASN1ObjectIdentifier, RdnControl>();
        for (RdnControl rdnControl : controls) {
            ASN1ObjectIdentifier type = rdnControl.getType();
            this.controls.put(type, rdnControl);
            String group = rdnControl.getGroup();
            if (StringUtil.isBlank((String)group)) continue;
            groupSet.add(group);
            this.typeGroups.put(type, group);
            Set<ASN1ObjectIdentifier> typeSet = this.groupTypes.get(group);
            if (typeSet == null) {
                typeSet = new HashSet<ASN1ObjectIdentifier>();
                this.groupTypes.put(group, typeSet);
            }
            typeSet.add(type);
        }
        this.groups = Collections.unmodifiableSet(groupSet);
    }

    public RdnControl getControl(ASN1ObjectIdentifier type) {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        return this.controls.isEmpty() ? SubjectDnSpec.getRdnControl(type) : this.controls.get(type);
    }

    public String getGroup(ASN1ObjectIdentifier type) {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        return this.typeGroups.get(type);
    }

    public Set<ASN1ObjectIdentifier> getTypesForGroup(String group) {
        ParamUtil.requireNonNull((String)"group", (Object)group);
        return this.groupTypes.get(group);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public List<ASN1ObjectIdentifier> getTypes() {
        return this.types;
    }
}

