/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import org.xipki.util.ParamUtil;

public enum X509CertVersion {
    v1(1),
    v2(2),
    v3(3);

    private int versionNumber;

    private X509CertVersion(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public static X509CertVersion forName(String version) {
        ParamUtil.requireNonNull((String)"version", (Object)version);
        for (X509CertVersion m : X509CertVersion.values()) {
            if (!m.name().equalsIgnoreCase(version)) continue;
            return m;
        }
        throw new IllegalArgumentException("invalid X509CertVersion " + version);
    }

    public static X509CertVersion forValue(int versionNumber) {
        for (X509CertVersion m : X509CertVersion.values()) {
            if (m.versionNumber != versionNumber) continue;
            return m;
        }
        throw new IllegalArgumentException("invalid X509CertVersion " + versionNumber);
    }
}

